/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.config.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.Savable;
import org.anti_ad.mc.common.config.IConfigElement;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.extensions.JsonKt;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\fR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R.\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00068B@BX\u0082\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u0012\u0004\b\u001e\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/anti_ad/mc/common/config/builder/ConfigSaveLoadManager;", "Lorg/anti_ad/mc/common/Savable;", "", "modId", "fileName", "Lkotlin/Function0;", "Lorg/anti_ad/mc/common/config/IConfigElement;", "configSource", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "", "save", "()V", "load", "Lkotlin/jvm/functions/Function0;", "Ljava/nio/file/Path;", "configFile", "Ljava/nio/file/Path;", "path", "Ljava/lang/String;", "value", "config", "Lorg/anti_ad/mc/common/config/IConfigElement;", "getConfig", "()Lorg/anti_ad/mc/common/config/IConfigElement;", "setConfig", "(Lorg/anti_ad/mc/common/config/IConfigElement;)V", "Lkotlinx/serialization/json/Json;", "encoder", "Lkotlinx/serialization/json/Json;", "getEncoder$annotations", "fabric-1.21.11"})
public class ConfigSaveLoadManager
implements Savable {
    @NotNull
    private final Function0<IConfigElement> configSource;
    @NotNull
    private final Path configFile;
    @NotNull
    private final String path;
    @Nullable
    private IConfigElement config;
    @NotNull
    private final Json encoder;

    public ConfigSaveLoadManager(@NotNull String modId, @NotNull String fileName, @NotNull Function0<? extends IConfigElement> configSource) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(configSource, (String)"configSource");
        this.configSource = configSource;
        this.configFile = Java_ioKt.div(VanillaUtil.INSTANCE.configDirectory(modId), fileName);
        this.path = Java_ioKt.getLoggingPath(this.configFile);
        this.encoder = kotlinx.serialization.json.JsonKt.Json$default(null, ConfigSaveLoadManager::encoder$lambda$0, (int)1, null);
    }

    private final IConfigElement getConfig() {
        if (this.config == null) {
            this.config = (IConfigElement)this.configSource.invoke();
        }
        return this.config;
    }

    private final void setConfig(IConfigElement value) {
        if (value == null) {
            this.config = null;
        }
    }

    private static /* synthetic */ void getEncoder$annotations() {
    }

    @Override
    public void save() {
        try {
            IConfigElement iConfigElement = this.getConfig();
            Intrinsics.checkNotNull((Object)iConfigElement);
            JsonElement el = iConfigElement.toJsonElement();
            SerializationStrategy serializationStrategy = (SerializationStrategy)JsonElement.Companion.serializer();
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(this.configFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            JvmStreamsKt.encodeToStream((Json)this.encoder, (SerializationStrategy)serializationStrategy, (Object)el, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.INSTANCE.error("I/O error while writing config file " + this.path, e);
        }
        catch (Exception e) {
            Log.INSTANCE.error("Error write config file " + this.path, e);
        }
    }

    @Override
    public void load() {
        try {
            if (!Java_ioKt.exists(this.configFile)) {
                return;
            }
            JsonElement j = JsonKt.toJsonElement(PathsKt.readText$default((Path)this.configFile, null, (int)1, null));
            IConfigElement iConfigElement = this.getConfig();
            Intrinsics.checkNotNull((Object)iConfigElement);
            iConfigElement.fromJsonElement(j);
        }
        catch (IOException e) {
            Log.INSTANCE.error("Failed to read config file " + this.path, e);
        }
        catch (SerializationException e) {
            Log.INSTANCE.error("Failed to parse config file " + this.path + " as JSON", e);
        }
        catch (Exception e) {
            Log.INSTANCE.error("Error write config file " + this.path, e);
        }
    }

    private static final Unit encoder$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrintIndent("    ");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

