/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_fabric.functions;

import com.natamus.collective_common_fabric.functions.DataFunctions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConfigFunctions {
    public static List<String> getRawConfigValues(String modid) {
        return ConfigFunctions.getRawConfigValues(modid, false);
    }

    public static List<String> getRawConfigValues(String modid, boolean tve) {
        Object dirpath = DataFunctions.getConfigDirectory();
        if (tve) {
            dirpath = (String)dirpath + File.separator + "TVE";
        }
        File dir = new File((String)dirpath);
        File file = new File((String)dirpath + File.separator + modid + ".json5");
        ArrayList<String> values = new ArrayList<String>();
        if (dir.isDirectory() && file.isFile()) {
            try {
                String content = new String(Files.readAllBytes(Paths.get((String)dirpath + File.separator + modid + ".json5", new String[0])));
                for (String line : content.split("\n")) {
                    String trimmedline = line.trim();
                    if (!trimmedline.startsWith("\"")) continue;
                    if (trimmedline.endsWith(",")) {
                        trimmedline = trimmedline.substring(0, trimmedline.length() - 1);
                    }
                    values.add(trimmedline);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return values;
    }

    public static HashMap<String, String> getDictValues(String modid) {
        return ConfigFunctions.getDictValues(modid, false);
    }

    public static HashMap<String, String> getDictValues(String modid, boolean tve) {
        HashMap<String, String> hm = new HashMap<String, String>();
        List<String> rawvalues = ConfigFunctions.getRawConfigValues(modid, tve);
        for (String rawvalue : rawvalues) {
            String[] rvspl;
            if (rawvalue.length() < 3) continue;
            String rv = rawvalue.replace("\"", "");
            if (rv.contains("=")) {
                rvspl = rv.split("=");
            } else {
                if (!rv.contains(":")) continue;
                rvspl = rv.split(":");
            }
            if (rvspl.length < 2) continue;
            String keystr = rvspl[0].trim();
            String valuestr = rvspl[1].trim();
            hm.put(keystr, valuestr);
        }
        return hm;
    }
}

