/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.services;

import com.natamus.collective_common_neoforge.services.helpers.ToolFunctionsHelper;
import java.util.Set;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class NeoForgeToolFunctionsHelper
implements ToolFunctionsHelper {
    public static final ItemAbility LIGHT_CAMPFIRE = ItemAbility.get((String)"light_campfire");

    @Override
    public boolean isTool(ItemStack itemstack) {
        return this.isPickaxe(itemstack) || this.isAxe(itemstack) || this.isShovel(itemstack) || this.isHoe(itemstack) || this.isShears(itemstack);
    }

    @Override
    public boolean isSword(ItemStack itemStack) {
        return itemStack.is(ItemTags.SWORDS) || itemStack.canPerformAction(ItemAbilities.SWORD_SWEEP);
    }

    @Override
    public boolean isShield(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShieldItem;
    }

    @Override
    public boolean isPickaxe(ItemStack itemStack) {
        return itemStack.is(ItemTags.PICKAXES);
    }

    @Override
    public boolean isAxe(ItemStack itemStack) {
        return itemStack.getItem() instanceof AxeItem || itemStack.is(ItemTags.AXES) || NeoForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ItemAbilities.DEFAULT_AXE_ACTIONS);
    }

    @Override
    public boolean isShovel(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShovelItem || itemStack.is(ItemTags.SHOVELS) || NeoForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ItemAbilities.DEFAULT_SHOVEL_ACTIONS);
    }

    @Override
    public boolean isHoe(ItemStack itemStack) {
        return itemStack.getItem() instanceof HoeItem || itemStack.is(ItemTags.HOES) || NeoForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ItemAbilities.DEFAULT_HOE_ACTIONS);
    }

    @Override
    public boolean isShears(ItemStack itemStack) {
        return itemStack.getItem() instanceof ShearsItem || NeoForgeToolFunctionsHelper.canPerformOneOfActions(itemStack, ItemAbilities.DEFAULT_SHEARS_ACTIONS);
    }

    @Override
    public boolean isFlintAndSteel(ItemStack itemStack) {
        return itemStack.getItem() instanceof FlintAndSteelItem || itemStack.canPerformAction(LIGHT_CAMPFIRE);
    }

    private static boolean canPerformOneOfActions(ItemStack itemStack, Set<ItemAbility> itemAbilities) {
        for (ItemAbility itemAbility : itemAbilities) {
            if (!itemStack.canPerformAction(itemAbility)) continue;
            return true;
        }
        return false;
    }
}

