/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.dataproviders;

import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_638;

public class BaseDataProvider
implements OverlayDataProvider {
    public static void init() {
        BaseDataProvider dp = new BaseDataProvider();
        ModeManager.registerDataProvider(dp.getIdentifier(), dp);
    }

    @Override
    public OverlayData compute(class_638 level, class_2818 chunk, class_2338 pos, class_2382 rPos) {
        class_2680 blockState = chunk.method_8320(pos);
        if (LightyHelper.isBlocked(blockState, pos, level, chunk)) {
            return OverlayData.INVALID;
        }
        class_2338 posUp = pos.method_10084();
        int blockLightLevel = level.method_8314(class_1944.field_9282, posUp);
        if (!((Boolean)Config.SHOW_SAFE.getValue()).booleanValue() && LightyHelper.isSafe(blockLightLevel)) {
            return OverlayData.INVALID;
        }
        float offset = LightyHelper.getOffset(blockState, pos, level, chunk);
        if (offset == -1.0f) {
            return OverlayData.INVALID;
        }
        int skyLightLevel = level.method_8314(class_1944.field_9284, posUp);
        int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
        return new OverlayData(true, color, skyLightLevel, blockLightLevel, pos, rPos, offset);
    }

    @Override
    public class_2960 getIdentifier() {
        return class_2960.method_60655((String)"lighty", (String)"data_provider_base");
    }
}

