/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.core;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.core.BufferHolder;
import dev.schmarrn.lighty.core.LightyPipelines;
import dev.schmarrn.lighty.core.RendererRegistry;
import dev.schmarrn.lighty.overlaystate.SMACH;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10896;
import net.minecraft.class_11282;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class LightyRenderer {
    private static final Vector4f UNIT_COLOR_MODULATOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Matrix4f DEFAULT_TEXTURE_MATRIX = new Matrix4f();

    private static int addChunkSectionInfo(class_4076 chunkSection, int width, int height, List<class_11282.class_12294> uniformList) {
        class_2338 origin = chunkSection.method_19767();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        uniformList.add(new class_11282.class_12294((Matrix4fc)modelViewMatrix, origin.method_10263(), origin.method_10264(), origin.method_10260(), 1.0f, width, height));
        return uniformList.size() - 1;
    }

    private static int addTransform(class_4076 chunkSection, class_243 camPos, List<class_11282.class_11283> uniformList) {
        class_243 origin = new class_243((class_2382)chunkSection.method_19767());
        class_243 dPos = origin.method_1020(camPos);
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        modelViewMatrix.translate((float)dPos.field_1352, (float)dPos.field_1351, (float)dPos.field_1350);
        uniformList.add(new class_11282.class_11283((Matrix4fc)modelViewMatrix, (Vector4fc)UNIT_COLOR_MODULATOR, (Vector3fc)new Vector3f(), (Matrix4fc)DEFAULT_TEXTURE_MATRIX));
        return uniformList.size() - 1;
    }

    private static int addData(class_10896 gpuBuffer, int biggestBufferSize, List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, String uniformName, int currentIndex) {
        if (gpuBuffer.method_68544() == null && gpuBuffer.method_68546() > biggestBufferSize) {
            biggestBufferSize = gpuBuffer.method_68546();
        }
        drawList.add((RenderPass.class_10884<GpuBufferSlice[]>)new RenderPass.class_10884(0, gpuBuffer.method_68540(), gpuBuffer.method_68544(), gpuBuffer.method_68547(), 0, gpuBuffer.method_68546(), (bufferSlice, uniformUploader) -> uniformUploader.upload(uniformName, bufferSlice[currentIndex])));
        return biggestBufferSize;
    }

    private static int goThroughEachBuffer(Object2ObjectOpenHashMap<class_4076, BufferHolder> cache, DoTheThing fn) {
        int biggestBufferSize = 0;
        ObjectIterator cacheIterator = cache.object2ObjectEntrySet().fastIterator();
        while (cacheIterator.hasNext()) {
            Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)cacheIterator.next();
            class_4076 chunkSection = (class_4076)entry.getKey();
            BufferHolder cachedBuffer = (BufferHolder)entry.getValue();
            Object2ObjectOpenHashMap<class_2960, class_10896> gpuBuffers = cachedBuffer.getGpuBuffers();
            ObjectIterator bufferIterator = gpuBuffers.object2ObjectEntrySet().fastIterator();
            while (bufferIterator.hasNext()) {
                Object2ObjectMap.Entry bufferEntry = (Object2ObjectMap.Entry)bufferIterator.next();
                if (!cachedBuffer.isValid((class_2960)bufferEntry.getKey())) continue;
                biggestBufferSize = fn.theThing((class_10896)bufferEntry.getValue(), biggestBufferSize, chunkSection);
            }
        }
        return biggestBufferSize;
    }

    private static String getUniformName(OverlayRenderer renderer) {
        if (renderer.getPipeline() == LightyPipelines.TERRAIN_TRANSLUCENT || renderer.getPipeline() == LightyPipelines.TERRAIN_CUTOUT) {
            return "ChunkSection";
        }
        if (renderer.getPipeline() == LightyPipelines.LINES) {
            return "DynamicTransforms";
        }
        Lighty.LOGGER.error("LightyRenderer: getUniformName: Don't how to handle RenderPipeline {} of mode {}.", (Object)renderer.getPipeline(), (Object)renderer.getIdentifier().toString());
        throw new RuntimeException("Lighty unknown RenderPipeline");
    }

    public static DrawListData prepareData(Object2ObjectOpenHashMap<class_4076, BufferHolder> cache, class_243 camPos, GpuTextureView tex, OverlayRenderer renderer) {
        GpuBufferSlice[] dynamicTransforms;
        int biggestBufferSize;
        ArrayList<RenderPass.class_10884<GpuBufferSlice[]>> drawList = new ArrayList<RenderPass.class_10884<GpuBufferSlice[]>>();
        String uniformName = LightyRenderer.getUniformName(renderer);
        if (uniformName.equals("ChunkSection")) {
            ArrayList chunkSectionInfoList = new ArrayList();
            biggestBufferSize = LightyRenderer.goThroughEachBuffer(cache, (buffers, previousBiggestBufferSize, chunkSection) -> LightyRenderer.addData(buffers, previousBiggestBufferSize, drawList, "ChunkSection", LightyRenderer.addChunkSectionInfo(chunkSection, tex.getWidth(0), tex.getHeight(0), chunkSectionInfoList)));
            dynamicTransforms = RenderSystem.getDynamicUniforms().method_76294(chunkSectionInfoList.toArray(new class_11282.class_12294[0]));
        } else if (uniformName.equals("DynamicTransforms")) {
            ArrayList transformList = new ArrayList();
            biggestBufferSize = LightyRenderer.goThroughEachBuffer(cache, (buffers, previousBiggestBufferSize, chunkSection) -> LightyRenderer.addData(buffers, previousBiggestBufferSize, drawList, "DynamicTransforms", LightyRenderer.addTransform(chunkSection, camPos, transformList)));
            dynamicTransforms = RenderSystem.getDynamicUniforms().method_71107(transformList.toArray(new class_11282.class_11283[0]));
        } else {
            throw new IllegalStateException("unknown uniform type");
        }
        return new DrawListData(drawList, biggestBufferSize, dynamicTransforms, true);
    }

    public static void render(class_243 camPos, Object2ObjectOpenHashMap<class_4076, BufferHolder> cache) {
        class_276 renderTarget;
        if (!SMACH.isEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        OverlayRenderer renderer = RendererRegistry.getRenderer();
        GpuDevice device = RenderSystem.getDevice();
        GpuTextureView tex = minecraft.method_1531().method_4619(renderer.getTextureLocation()).method_71659();
        DrawListData data = LightyRenderer.prepareData(cache, camPos, tex, renderer);
        RenderPipeline pipeline = renderer.getPipeline();
        class_276 class_2762 = renderTarget = renderer.getPipeline() == LightyPipelines.TERRAIN_TRANSLUCENT ? minecraft.field_1769.method_29360() : minecraft.method_1522();
        if (renderTarget == null) {
            renderTarget = minecraft.method_1522();
        }
        RenderSystem.class_5590 asib = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        GpuBuffer baseIndexBuffer = data.maxIndicesRequired == 0 ? null : asib.method_68274(data.maxIndicesRequired);
        VertexFormat.class_5595 baseIndexType = data.maxIndicesRequired == 0 ? null : asib.method_31924();
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(() -> "Lighty Render Pass for" + String.valueOf(pipeline.getLocation()), renderTarget.method_71639(), OptionalInt.empty(), renderTarget.method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.bindTexture("Sampler2", minecraft.field_1773.method_22974().method_71650(), RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR));
            pass.setPipeline(pipeline);
            pass.bindTexture("Sampler0", tex, RenderSystem.getSamplerCache().method_75294(FilterMode.NEAREST));
            pass.drawMultipleIndexed(pipeline == LightyPipelines.TERRAIN_TRANSLUCENT ? data.drawList.reversed() : data.drawList, baseIndexBuffer, baseIndexType, List.of(LightyRenderer.getUniformName(renderer)), (Object)data.uniforms);
        }
    }

    private static interface DoTheThing {
        public int theThing(class_10896 var1, int var2, class_4076 var3);
    }

    public record DrawListData(List<RenderPass.class_10884<GpuBufferSlice[]>> drawList, int maxIndicesRequired, GpuBufferSlice[] uniforms, boolean isChunkSectionUniform) {
    }
}

