/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.data.CameraPresetManager;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.CameraPreset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2806;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_761;

public class CameraUtils {
    private static float cameraYaw;
    private static float cameraPitch;
    private static boolean freeCameraSpectator;

    public static void setFreeCameraSpectator(boolean isSpectator) {
        freeCameraSpectator = isSpectator;
    }

    public static boolean getFreeCameraSpectator() {
        return freeCameraSpectator;
    }

    public static boolean shouldPreventPlayerInputs() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_INPUTS.getBooleanValue();
    }

    public static boolean shouldPreventPlayerMovement() {
        return FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue() && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue();
    }

    public static float getCameraYaw() {
        return class_3532.method_15393((float)cameraYaw);
    }

    public static float getCameraPitch() {
        return class_3532.method_15393((float)cameraPitch);
    }

    public static void setCameraYaw(float yaw) {
        cameraYaw = yaw;
    }

    public static void setCameraPitch(float pitch) {
        cameraPitch = pitch;
    }

    public static void setCameraRotations(float yaw, float pitch) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.setCameraRotations(yaw, pitch);
        }
    }

    public static void updateCameraRotations(float yawChange, float pitchChange) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null) {
            camera.updateCameraRotations(yawChange, pitchChange);
        }
    }

    public static void markChunksForRebuild(int chunkX, int chunkZ, int lastChunkX, int lastChunkZ) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || chunkX == lastChunkX && chunkZ == lastChunkZ) {
            return;
        }
        int viewDistance = (Integer)mc.field_1690.method_42503().method_41753();
        if (chunkX != lastChunkX) {
            int minCX = chunkX > lastChunkX ? lastChunkX + viewDistance : chunkX - viewDistance;
            int maxCX = chunkX > lastChunkX ? chunkX + viewDistance : lastChunkX - viewDistance;
            for (int cx = minCX; cx <= maxCX; ++cx) {
                for (int cz = chunkZ - viewDistance; cz <= chunkZ + viewDistance; ++cz) {
                    if (!CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
                }
            }
        }
        if (chunkZ != lastChunkZ) {
            int minCZ = chunkZ > lastChunkZ ? lastChunkZ + viewDistance : chunkZ - viewDistance;
            int maxCZ = chunkZ > lastChunkZ ? chunkZ + viewDistance : lastChunkZ - viewDistance;
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = chunkX - viewDistance; cx <= chunkX + viewDistance; ++cx) {
                    if (!CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                    CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
                }
            }
        }
    }

    public static void markChunksForRebuildOnDeactivation(int lastChunkX, int lastChunkZ) {
        class_310 mc = class_310.method_1551();
        int viewDistance = (Integer)mc.field_1690.method_42503().method_41753();
        class_1297 entity = EntityUtils.getCameraEntity();
        if (mc.field_1687 == null || entity == null) {
            return;
        }
        int chunkX = class_3532.method_15357((double)(entity.method_23317() / 16.0)) >> 4;
        int chunkZ = class_3532.method_15357((double)(entity.method_23321() / 16.0)) >> 4;
        int minCameraCX = lastChunkX - viewDistance;
        int maxCameraCX = lastChunkX + viewDistance;
        int minCameraCZ = lastChunkZ - viewDistance;
        int maxCameraCZ = lastChunkZ + viewDistance;
        int minCX = chunkX - viewDistance;
        int maxCX = chunkX + viewDistance;
        int minCZ = chunkZ - viewDistance;
        int maxCZ = chunkZ + viewDistance;
        for (int cz = minCZ; cz <= maxCZ; ++cz) {
            for (int cx = minCX; cx <= maxCX; ++cx) {
                if (cx >= minCameraCX && cx <= maxCameraCX && cz >= minCameraCZ && cz <= maxCameraCZ || !CameraUtils.isClientChunkLoaded(mc.field_1687, cx, cz)) continue;
                CameraUtils.markChunkForReRender(mc.field_1769, cx, cz);
            }
        }
    }

    public static void markChunkForReRender(class_761 renderer, int chunkX, int chunkZ) {
        for (int cy = 0; cy < 16; ++cy) {
            renderer.method_8571(chunkX, cy, chunkZ);
        }
    }

    public static boolean isClientChunkLoaded(class_638 world, int chunkX, int chunkZ) {
        return world.method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false) != null;
    }

    public static String fixPresetName(String in) {
        return in.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(",", "");
    }

    public static boolean addPreset(@Nonnull CameraPreset preset) {
        if (!CameraPresetManager.getInstance().hasPosition(preset)) {
            CameraPresetManager.getInstance().add(preset);
            Tweakeroo.debugLog("CameraUtils#addPreset(): Added new preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean updatePreset(@Nonnull CameraPreset preset) {
        CameraPresetManager.getInstance().update(preset, false);
        Tweakeroo.debugLog("CameraUtils#updatePreset(): Updated preset: {}", preset.toShortString());
        return true;
    }

    public static boolean deletePreset(@Nullable CameraPreset oldPreset) {
        if (oldPreset != null) {
            CameraPresetManager.getInstance().remove(oldPreset.getId(), false);
            Tweakeroo.debugLog("CameraUtils#deletePreset(): Deleted preset: {}", oldPreset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean deletePresetAtPosition(class_310 mc) {
        CameraPreset preset;
        if (mc.method_1560() != null && (preset = CameraPresetManager.getInstance().getAtPosition(mc.method_1560())) != null) {
            CameraPresetManager.getInstance().remove(preset.getId(), false);
            Tweakeroo.debugLog("CameraUtils#deletePresetAtPosition(): Deleted preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean deleteAllPresets(class_5321<class_1937> dimKey) {
        if (dimKey != null) {
            CameraPresetManager.getInstance().clear(dimKey, false);
            Tweakeroo.debugLog("CameraUtils#deletePresetAtPosition(): Deleted all presets for dimension '{}'", dimKey.method_29177().toString());
            return true;
        }
        return false;
    }

    public static boolean renamePreset(@Nullable CameraPreset preset, String newName) {
        if (preset != null) {
            String oldName = preset.getName();
            preset.setName(CameraUtils.fixPresetName(newName));
            CameraPresetManager.getInstance().update(preset, false);
            Tweakeroo.debugLog("CameraUtils#renamePreset(): Renamed preset: [{}] / '{}' -> '{}'", preset.getId(), oldName, preset.getName());
            return true;
        }
        return false;
    }

    public static boolean recallPreset(@Nonnull CameraPreset preset, class_310 mc) {
        if (!preset.equals(mc.method_1560()) && mc.field_1687 != null && mc.field_1687.method_27983().method_29177().equals((Object)preset.getDim())) {
            CameraPresetManager.getInstance().setLastPreset(preset.getId());
            if (FeatureToggle.TWEAK_FREE_CAMERA.getBooleanValue()) {
                CameraEntity.updatePositionAtPreset(preset);
            } else {
                FeatureToggle.TWEAK_FREE_CAMERA.setEnabledNoCallback();
                CameraEntity.setCameraState(true, preset);
            }
            Tweakeroo.debugLog("CameraUtils#recallPreset(): Recall preset: {}", preset.toShortString());
            return true;
        }
        return false;
    }

    public static boolean cyclePreset(class_310 mc) {
        if (mc.field_1687 != null) {
            class_5321 dimKey = mc.field_1687.method_27983();
            CameraPreset preset = CameraPresetManager.getInstance().cycle((class_5321<class_1937>)dimKey);
            if (preset != null) {
                return CameraUtils.recallPreset(preset, mc);
            }
        }
        return false;
    }
}

