/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractNautilus;
import fi.dy.masa.malilib.mixin.entity.IMixinPiglinEntity;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayRefresher;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.data.EntityDataManager;
import net.minecraft.class_12116;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4836;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class InventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final InventoryOverlayHandler INSTANCE = new InventoryOverlayHandler();
    InventoryOverlayContext context = null;
    InventoryOverlayRefresher refresher = null;
    IDataSyncer syncer = null;
    private Pair<class_2338, InventoryOverlayContext> lastBlockEntityContext = null;
    private Pair<Integer, InventoryOverlayContext> lastEntityContext = null;

    public static InventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    public String getModId() {
        return "tweakeroo";
    }

    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = EntityDataManager.getInstance();
        }
        return this.syncer;
    }

    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    public InventoryOverlayRefresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    public boolean isEmpty() {
        return this.context == null;
    }

    @Nullable
    public InventoryOverlayContext getRenderContextNullable() {
        return this.context;
    }

    @Nullable
    public InventoryOverlayContext getRenderContext(GuiContext ctx, class_3695 profiler) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(ctx.mc());
        if (!this.isEmpty()) {
            this.renderInventoryOverlay(ctx, this.getRenderContextNullable(), Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue(), Configs.Generic.INVENTORY_PREVIEW_VILLAGER_BG_COLOR.getBooleanValue());
        }
        profiler.method_15407();
        return this.getRenderContextNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public InventoryOverlayContext getTargetInventory(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null || mc.field_1687 == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = cameraEntity != mc.field_1724 ? RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, (class_1297)cameraEntity, (class_3959.class_242)class_3959.class_242.field_1348) : mc.field_1765;
        CompoundData data = new CompoundData();
        if (trace == null || trace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            if (!(blockTmp instanceof class_2343)) return null;
            if (world instanceof class_3218) {
                be = world.method_8500(pos).method_8321(pos);
                if (be != null) {
                    data = DataConverterNbt.fromVanillaCompound((class_2487)be.method_38242((class_7225.class_7874)world.method_30349()));
                }
            } else {
                Pair pair = this.getDataSyncer().requestBlockEntity(world, pos);
                if (pair != null) {
                    data = (CompoundData)pair.getRight();
                }
            }
            InventoryOverlayContext ctx = this.getTargetInventoryFromBlock(world, pos, be, data);
            if (this.lastBlockEntityContext != null && !((class_2338)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) {
                this.lastBlockEntityContext = null;
            }
            if (ctx != null && ctx.inv() != null) {
                this.lastBlockEntityContext = Pair.of((Object)pos, (Object)ctx);
                this.context = ctx;
                return this.context;
            }
            if (this.lastBlockEntityContext == null || !((class_2338)this.lastBlockEntityContext.getLeft()).equals((Object)pos)) return null;
            this.context = (InventoryOverlayContext)this.lastBlockEntityContext.getRight();
            return this.context;
        }
        if (trace.method_17783() != class_239.class_240.field_1331) return null;
        class_1297 entity = ((class_3966)trace).method_17782();
        if (cameraEntity.method_5667().equals(entity.method_5667())) {
            return null;
        }
        if (world instanceof class_3218) {
            if ((entity = world.method_8469(entity.method_5628())) == null) return null;
            data = DataEntityUtils.invokeEntityDataTagNoPassengers((class_1297)entity, (int)entity.method_5628());
        } else {
            Pair pair = this.getDataSyncer().requestEntity(world, entity.method_5628());
            if (pair != null) {
                data = (CompoundData)pair.getRight();
            }
        }
        InventoryOverlayContext ctx = this.getTargetInventoryFromEntity(world.method_8469(entity.method_5628()), data);
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.method_5628()) {
            this.lastEntityContext = null;
        }
        if (ctx != null && ctx.inv() != null && !ctx.inv().method_5442()) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() != null && ctx.inv().method_5442() && ctx.data() != null && ctx.data().containsLenient("Offers")) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (ctx != null && ctx.inv() == null && (ctx.type() == InventoryOverlayType.WOLF || ctx.type() == InventoryOverlayType.VILLAGER || ctx.type() == InventoryOverlayType.HORSE || ctx.type() == InventoryOverlayType.PLAYER || ctx.type() == InventoryOverlayType.ARMOR_STAND || ctx.type() == InventoryOverlayType.LIVING_ENTITY)) {
            this.lastEntityContext = Pair.of((Object)entity.method_5628(), (Object)ctx);
            this.context = ctx;
            return this.context;
        }
        if (this.lastEntityContext != null && ((Integer)this.lastEntityContext.getLeft()).intValue() == entity.method_5628() && ctx != null && ctx.inv() != null && ctx.inv().method_5442() && (ctx.type() == InventoryOverlayType.VILLAGER || ctx.type() == InventoryOverlayType.HORSE || ctx.type() == InventoryOverlayType.PLAYER)) {
            this.context = (InventoryOverlayContext)this.lastEntityContext.getRight();
            return this.context;
        }
        if (this.lastEntityContext == null || ((Integer)this.lastEntityContext.getLeft()).intValue() != entity.method_5628()) return null;
        this.context = (InventoryOverlayContext)this.lastEntityContext.getRight();
        return this.context;
    }

    @Nullable
    public InventoryOverlayContext getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, CompoundData data) {
        class_1657 player;
        class_2591 beType;
        class_1263 inv;
        if (world == null) {
            return null;
        }
        if (be != null) {
            if (data.isEmpty()) {
                data = DataConverterNbt.fromVanillaCompound((class_2487)be.method_38242((class_7225.class_7874)world.method_30349()));
            }
            inv = InventoryUtils.getInventory((class_1937)world, (class_2338)pos);
        } else {
            Pair pair;
            if (data.isEmpty() && (pair = this.requestBlockEntityAt(world, pos)) != null) {
                data = (CompoundData)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        class_2591 class_25912 = beType = data != null ? DataBlockUtils.getBlockEntityType((CompoundData)data) : null;
        if ((beType != null && beType.equals(class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null) {
            Pair enderPair = this.getDataSyncer().requestEntity(world, player.method_5628());
            class_1730 enderItems = null;
            enderItems = enderPair != null && enderPair.getRight() != null && ((CompoundData)enderPair.getRight()).contains("EnderItems", 9) ? InventoryUtils.getPlayerEnderItemsFromData((CompoundData)((CompoundData)enderPair.getRight()), (class_5455)world.method_30349()) : player.method_7274();
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (data != null && !data.isEmpty()) {
            class_1263 inv2 = InventoryUtils.getDataInventory((CompoundData)data, (int)(inv != null ? inv.method_5439() : -1), (class_5455)world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        if (inv == null || data == null) {
            return null;
        }
        this.context = new InventoryOverlayContext(InventoryOverlay.getBestInventoryType((class_1263)inv, (CompoundData)data), inv, be != null ? be : world.method_8321(pos), null, data, this.getRefreshHandler());
        return this.context;
    }

    @Nullable
    public InventoryOverlayContext getTargetInventoryFromEntity(class_1297 entity, CompoundData data) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().method_67533().toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1646) {
            inv = ((class_1646)entity).method_35199();
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_12116) {
            inv = ((IMixinAbstractNautilus)entity).malilib_getNautilusInventory();
        } else if (entity instanceof class_4836) {
            inv = ((IMixinPiglinEntity)entity).malilib_getInventory();
        }
        if (!data.isEmpty()) {
            class_1263 inv2;
            if (inv != null && data.contains("Items", 9) && data.getList("Items").size() > 1) {
                inv2 = entity instanceof class_1496 || entity instanceof class_12116 ? InventoryUtils.getDataInventoryHorseFix((CompoundData)data, (int)-1, (class_5455)entity.method_56673()) : InventoryUtils.getDataInventory((CompoundData)data, (int)-1, (class_5455)entity.method_56673());
                inv = null;
            } else if (inv != null && data.containsLenient("equipment") && data.containsLenient("EatingHaystack")) {
                inv2 = InventoryUtils.getDataInventoryHorseFix((CompoundData)data, (int)inv.method_5439(), (class_5455)entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && data.contains("Inventory", 9) && !data.getList("Inventory").isEmpty()) {
                inv2 = InventoryUtils.getDataInventory((CompoundData)data, (int)8, (class_5455)entity.method_56673());
                inv = null;
            } else {
                inv2 = InventoryUtils.getDataInventory((CompoundData)data, (int)(inv != null ? inv.method_5439() : -1), (class_5455)entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlayContext(inv != null ? InventoryOverlay.getBestInventoryType((class_1263)inv, (CompoundData)data) : InventoryOverlay.getInventoryType((CompoundData)data), inv, null, entityLivingBase, data, this.getRefreshHandler());
        return this.context;
    }

    private static void dumpContext(InventoryOverlayContext ctx) {
        System.out.print("Context Dump --> ");
        if (ctx == null) {
            System.out.print("NULL!\n");
            return;
        }
        System.out.printf("\nTYPE: [%s]\n", ctx.type().name());
        System.out.printf("BE  : [%s]\n", ctx.be() != null ? class_7923.field_41181.method_10221((Object)ctx.be().method_11017()) : "<NULL>");
        System.out.printf("ENT : [%s]\n", ctx.entity() != null ? class_7923.field_41177.method_10221((Object)ctx.entity().method_5864()) : "<NULL>");
        System.out.printf("INV : [%s]\n", ctx.inv() != null ? "size: " + ctx.inv().method_5439() + "/ empty: " + ctx.inv().method_5442() : "<NULL>");
        System.out.printf("DATA: [%s]\n", ctx.data() != null ? ctx.data().toString() : "<NULL>");
        System.out.print("--> EOF\n");
    }

    public static class Refresher
    implements InventoryOverlayRefresher {
        public InventoryOverlayContext onContextRefresh(InventoryOverlayContext data, class_1937 world) {
            if (data.be() != null) {
                InventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().method_11016());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().method_10997(), data.be().method_11016(), data.be(), data.data());
            } else if (data.entity() != null) {
                InventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().method_5628());
                data = InventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((class_1297)data.entity(), data.data());
            }
            return data;
        }
    }
}

