/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.Map;
import java.util.Set;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;

public class LRUMap<K, V>
extends Object2ObjectLinkedOpenHashMap<K, V> {
    private Set<K> permanentEntries = Set.of();

    public LRUMap(Map<K, V> map) {
        super(map);
    }

    public V put(K k, V v) {
        return (V)this.putAndMoveToLast(k, v);
    }

    public V get(Object k) {
        return (V)this.getAndMoveToLast(k);
    }

    public void setPermanentEntries(Set<K> permanentEntries) {
        this.permanentEntries = permanentEntries;
    }

    public void dropEntriesToMeetSize(int size) {
        int expectedQuota = size;
        int prevSize = this.size();
        if (this.size() > (size += this.permanentEntries.size())) {
            ObjectBidirectionalIterator iterator = this.entrySet().iterator();
            while (this.size() > size && iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Object key = entry.getKey();
                if (key == null || this.permanentEntries.contains(key)) continue;
                iterator.remove();
            }
            this.trim(this.size() + expectedQuota);
            if (ModernFixPlatformHooks.INSTANCE.isDevEnv()) {
                ModernFix.LOGGER.warn("Trimmed map from {} to {} entries", (Object)prevSize, (Object)size);
            }
        }
    }
}

