/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.category.General;
import com.gitlab.cdagaming.craftpresence.core.integrations.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.CheckBoxControl;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import craftpresence.external.com.jagrosh.discordipc.entities.DiscordBuild;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_364;

public class GeneralSettingsGui
extends ConfigurationGui<General> {
    private final General INSTANCE;
    private final General DEFAULTS;
    private ExtendedButtonControl preferredClientLevelButton;
    private CheckBoxControl detectCurseManifestButton;
    private CheckBoxControl detectMultiMCManifestButton;
    private CheckBoxControl detectMCUpdaterInstanceButton;
    private CheckBoxControl detectTechnicPackButton;
    private CheckBoxControl detectATLauncherButton;
    private CheckBoxControl detectModrinthPackButton;
    private CheckBoxControl detectBiomeDataButton;
    private CheckBoxControl detectDimensionDataButton;
    private CheckBoxControl detectWorldDataButton;
    private CheckBoxControl enableJoinRequestButton;
    private CheckBoxControl resetTimeOnInitButton;
    private CheckBoxControl autoRegisterButton;
    private TextWidget clientId;
    private TextWidget defaultIcon;
    private int currentPreferredClient = DiscordBuild.ANY.ordinal();

    GeneralSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.general", new Object[0]));
        this.DEFAULTS = this.getCurrentData().getDefaults();
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    public void constructElements() {
        super.constructElements();
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    public void appendElements() {
        super.appendElements();
        this.clientId = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            this.getInstanceData().clientId = this.clientId.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.general.client_id", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.client_id", new Object[0])))));
        this.clientId.setControlMessage(this.getInstanceData().clientId);
        this.clientId.setControlMaxLength(32);
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.defaultIcon = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, () -> {
            this.getInstanceData().defaultIcon = this.defaultIcon.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.general.default_icon", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.default_icon", new Object[0])))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().defaultIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().defaultIcon);
        this.currentPreferredClient = this.getInstanceData().preferredClientLevel;
        this.preferredClientLevelButton = (ExtendedButtonControl)this.childFrame.addControl((class_364)new ExtendedButtonControl(calc2, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.general.preferred_client", new Object[0]) + " => " + DiscordBuild.from(this.currentPreferredClient).name(), () -> {
            this.currentPreferredClient = (this.currentPreferredClient + 1) % DiscordBuild.values().length;
            this.preferredClientLevelButton.setControlMessage(Constants.TRANSLATOR.translate("gui.config.name.general.preferred_client", new Object[0]) + " => " + DiscordBuild.from(this.currentPreferredClient).name());
            this.getInstanceData().preferredClientLevel = this.currentPreferredClient;
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.preferred_client", new Object[0]))), new String[0]));
        this.detectCurseManifestButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(3), Constants.TRANSLATOR.translate("gui.config.name.general.detect_curse_manifest", new Object[0]), this.getInstanceData().detectCurseManifest, () -> {
            this.getInstanceData().detectCurseManifest = this.detectCurseManifestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_curse_manifest", new Object[0])))));
        this.detectMultiMCManifestButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(3), Constants.TRANSLATOR.translate("gui.config.name.general.detect_multimc_manifest", new Object[0]), this.getInstanceData().detectMultiMCManifest, () -> {
            this.getInstanceData().detectMultiMCManifest = this.detectMultiMCManifestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_multimc_manifest", new Object[0])))));
        this.detectMCUpdaterInstanceButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(4, -10), Constants.TRANSLATOR.translate("gui.config.name.general.detect_mcupdater_instance", new Object[0]), this.getInstanceData().detectMCUpdaterInstance, () -> {
            this.getInstanceData().detectMCUpdaterInstance = this.detectMCUpdaterInstanceButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_mcupdater_instance", new Object[0])))));
        this.detectTechnicPackButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(4, -10), Constants.TRANSLATOR.translate("gui.config.name.general.detect_technic_pack", new Object[0]), this.getInstanceData().detectTechnicPack, () -> {
            this.getInstanceData().detectTechnicPack = this.detectTechnicPackButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_technic_pack", new Object[0])))));
        this.detectATLauncherButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(5, -20), Constants.TRANSLATOR.translate("gui.config.name.general.detect_atlauncher_instance", new Object[0]), this.getInstanceData().detectATLauncherInstance, () -> {
            this.getInstanceData().detectATLauncherInstance = this.detectATLauncherButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_atlauncher_instance", new Object[0])))));
        this.detectModrinthPackButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(5, -20), Constants.TRANSLATOR.translate("gui.config.name.general.detect_modrinth_pack", new Object[0]), this.getInstanceData().detectModrinthPack, () -> {
            this.getInstanceData().detectModrinthPack = this.detectModrinthPackButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_modrinth_pack", new Object[0])))));
        this.enableJoinRequestButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(6, -30), Constants.TRANSLATOR.translate("gui.config.name.general.enable_join_request", new Object[0]), this.getInstanceData().enableJoinRequests, () -> {
            this.getInstanceData().enableJoinRequests = this.enableJoinRequestButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.enable_join_request", new Object[0])))));
        this.detectDimensionDataButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(6, -30), Constants.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]), this.getInstanceData().detectDimensionData, () -> {
            this.getInstanceData().detectDimensionData = this.detectDimensionDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_dimension_data", new Object[0])))));
        this.autoRegisterButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(7, -40), Constants.TRANSLATOR.translate("gui.config.name.general.auto_register", new Object[0]), this.getInstanceData().autoRegister, () -> {
            this.getInstanceData().autoRegister = this.autoRegisterButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.auto_register", new Object[0])))));
        this.detectBiomeDataButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(7, -40), Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]), this.getInstanceData().detectBiomeData, () -> {
            this.getInstanceData().detectBiomeData = this.detectBiomeDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_biome_data", new Object[0])))));
        this.resetTimeOnInitButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc1, this.getButtonY(8, -50), Constants.TRANSLATOR.translate("gui.config.name.general.reset_time_on_init", new Object[0]), this.getInstanceData().resetTimeOnInit, () -> {
            this.getInstanceData().resetTimeOnInit = this.resetTimeOnInitButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.reset_time_on_init", new Object[0])))));
        this.detectWorldDataButton = (CheckBoxControl)this.childFrame.addControl((class_364)new CheckBoxControl(calc2, this.getButtonY(8, -50), Constants.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]), this.getInstanceData().detectWorldData, () -> {
            this.getInstanceData().detectWorldData = this.detectWorldDataButton.isChecked();
        }, () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.general.detect_world_data", new Object[0])))));
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(DiscordAssetUtils.isValidId(this.clientId.getControlMessage()));
    }

    @Override
    protected General getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected General getCurrentData() {
        return CraftPresence.CONFIG.generalSettings;
    }

    @Override
    protected General getDefaultData() {
        return this.DEFAULTS;
    }
}

