/*
 * Decompiled with CFR 0.152.
 */
package io.github.samispoggers.beacon_bounding_boxes.mixin;

import io.github.samispoggers.beacon_bounding_boxes.client.BeaconBoundingBoxesClient;
import io.github.samispoggers.beacon_bounding_boxes.mixin.ConduitBlockEntityAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11961;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2597;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_829;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_829.class})
public class MixinConduitRenderer {
    @Unique
    private final Map<class_2338, Vector3f> conduitColors = new HashMap<class_2338, Vector3f>();

    @Inject(method={"method_22750"}, at={@At(value="HEAD")})
    public void onSubmitConduit(class_11961 conduitRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        if (!BeaconBoundingBoxesClient.renderConduitBounds) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2586 be = world.method_8321(conduitRenderState.field_62673);
        if (!(be instanceof class_2597)) {
            return;
        }
        class_2597 conduit = (class_2597)be;
        this.renderBoundingBox(conduit, poseStack, submitNodeCollector);
    }

    @Unique
    private void renderBoundingBox(class_2597 conduit, class_4587 poseStack, class_11659 submitNodeCollector) {
        class_2338 blockPos = conduit.method_11016();
        Vector3f color = this.conduitColors.computeIfAbsent(blockPos, p -> {
            Random random = new Random(p.method_10063());
            return new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        });
        int activatingBlocks = ((ConduitBlockEntityAccessor)conduit).getEffectBlocks().size();
        if (activatingBlocks < 16) {
            return;
        }
        int rangeSteps = Math.min((activatingBlocks - 1) / 7, 5);
        int range = rangeSteps * 16 - 1;
        submitNodeCollector.method_73483(poseStack, class_12249.method_76015(), (pose, buffer) -> this.drawSphereOutline(pose, buffer, range, color.x(), color.y(), color.z(), 48));
    }

    @Unique
    private void drawSphereOutline(class_4587.class_4665 pose, class_4588 buffer, float radius, float r, float g, float b, int segments) {
        float x2;
        float z1;
        for (int i = 0; i < segments; ++i) {
            double theta1 = Math.PI * 2 * (double)i / (double)segments;
            double theta2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            float x1 = (float)((double)radius * Math.cos(theta1));
            float z12 = (float)((double)radius * Math.sin(theta1));
            float x22 = (float)((double)radius * Math.cos(theta2));
            float z2 = (float)((double)radius * Math.sin(theta2));
            buffer.method_56824(pose, x1, 0.0f, z12).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
            buffer.method_56824(pose, x22, 0.0f, z2).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
        }
        int latitudeBands = 4;
        for (int band = 1; band <= latitudeBands; ++band) {
            double phi = 1.5707963267948966 * ((double)band / (double)(latitudeBands + 1));
            float y = (float)((double)radius * Math.sin(phi));
            float yNeg = -y;
            float bandRadius = (float)((double)radius * Math.cos(phi));
            for (int i = 0; i < segments; ++i) {
                double theta1 = Math.PI * 2 * (double)i / (double)segments;
                double theta2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
                float x1 = (float)((double)bandRadius * Math.cos(theta1));
                z1 = (float)((double)bandRadius * Math.sin(theta1));
                x2 = (float)((double)bandRadius * Math.cos(theta2));
                float z2 = (float)((double)bandRadius * Math.sin(theta2));
                buffer.method_56824(pose, x1, y, z1).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
                buffer.method_56824(pose, x2, y, z2).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
                buffer.method_56824(pose, x1, yNeg, z1).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
                buffer.method_56824(pose, x2, yNeg, z2).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
            }
        }
        for (int i = 0; i < segments; ++i) {
            double theta1 = Math.PI * 2 * (double)i / (double)segments;
            double theta2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            for (int j = 0; j <= segments; ++j) {
                double phi1 = Math.PI * (double)j / (double)segments - 1.5707963267948966;
                double phi2 = Math.PI * (double)(j + 1) / (double)segments - 1.5707963267948966;
                float x1 = (float)((double)radius * Math.cos(phi1) * Math.cos(theta1));
                float y1 = (float)((double)radius * Math.sin(phi1));
                z1 = (float)((double)radius * Math.cos(phi1) * Math.sin(theta1));
                x2 = (float)((double)radius * Math.cos(phi2) * Math.cos(theta1));
                float y2 = (float)((double)radius * Math.sin(phi2));
                float z2 = (float)((double)radius * Math.cos(phi2) * Math.sin(theta1));
                buffer.method_56824(pose, x1, y1, z1).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
                buffer.method_56824(pose, x2, y2, z2).method_22915(r, g, b, 1.0f).method_60831(pose, 0.0f, 1.0f, 0.0f).method_75298(1.0f);
            }
        }
    }
}

