/*
 * Decompiled with CFR 0.152.
 */
package io.github.samispoggers.beacon_bounding_boxes.mixin;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.samispoggers.beacon_bounding_boxes.client.BeaconBoundingBoxesClient;
import io.github.samispoggers.beacon_bounding_boxes.config.BeaconBoundingBoxesConfig;
import io.github.samispoggers.beacon_bounding_boxes.mixin.BeaconBlockEntityAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11659;
import net.minecraft.class_11950;
import net.minecraft.class_12075;
import net.minecraft.class_12247;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_822;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_822.class})
public abstract class MixinBeaconRenderer {
    @Unique
    private static final RenderPipeline TRANSLUCENT_BOX_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withLocation("pipeline/translucent_box").withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).withCull(false).withDepthWrite(false).build();
    @Unique
    private static final class_1921 TRANSLUCENT_BOX = class_1921.method_75940((String)"beacon_bounding_boxes:translucent_box", (class_12247)class_12247.method_75927((RenderPipeline)TRANSLUCENT_BOX_PIPELINE).method_75938());
    @Unique
    private final Map<class_2338, Vector3f> beaconColors = new HashMap<class_2338, Vector3f>();

    @Inject(method={"method_74342"}, at={@At(value="HEAD")})
    private void onSubmitBeacon(class_11950 beaconRenderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        if (!BeaconBoundingBoxesClient.renderBeaconBounds) {
            return;
        }
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        class_2586 be = world.method_8321(beaconRenderState.field_62673);
        if (!(be instanceof class_2580)) {
            return;
        }
        class_2580 beacon = (class_2580)be;
        this.renderBoundingBox(beacon, poseStack, submitNodeCollector);
    }

    @Unique
    private void renderBoundingBox(class_2580 beacon, class_4587 poseStack, class_11659 submitNodeCollector) {
        class_2338 blockPos = beacon.method_11016();
        Vector3f color = this.beaconColors.computeIfAbsent(blockPos, p -> {
            Random random = new Random(p.method_10063());
            return new Vector3f(random.nextFloat(), random.nextFloat(), random.nextFloat());
        });
        int level = ((BeaconBlockEntityAccessor)beacon).getLevels();
        if (level <= 0) {
            return;
        }
        class_238 box = MixinBeaconRenderer.getBox(beacon, level);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        if (BeaconBoundingBoxesConfig.get().boxMode == BeaconBoundingBoxesConfig.BoxMode.BOX) {
            submitNodeCollector.method_73483(poseStack, TRANSLUCENT_BOX, (pose, consumer) -> this.drawBoxFaces(pose, consumer, box, color.x(), color.y(), color.z(), 0.3f));
        }
        submitNodeCollector.method_73483(poseStack, class_12249.method_76015(), (pose, consumer) -> this.renderLineBox(pose, consumer, box, color.x(), color.y(), color.z(), 1.0f));
        poseStack.method_22909();
    }

    @Unique
    @NotNull
    private static class_238 getBox(class_2580 beacon, int level) {
        int[] levelRanges = new int[]{0, 20, 30, 40, 50};
        int range = levelRanges[Math.min(level, levelRanges.length - 1)];
        int yMin = -range;
        int yMax = switch (BeaconBoundingBoxesConfig.get().heightMode) {
            case BeaconBoundingBoxesConfig.HeightMode.WORLD_HEIGHT -> 319 - beacon.method_11016().method_10264();
            case BeaconBoundingBoxesConfig.HeightMode.CUSTOM -> BeaconBoundingBoxesConfig.get().customYLevel - beacon.method_11016().method_10264();
            default -> range + 1;
        };
        class_243 min = new class_243((double)(-range), (double)yMin, (double)(-range));
        class_243 max = new class_243((double)(range + 1), (double)yMax, (double)(range + 1));
        return new class_238(min, max);
    }

    @Unique
    private void renderLineBox(class_4587.class_4665 pose, class_4588 consumer, class_238 box, float r, float g, float b, float a) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        this.addLine(consumer, pose, minX, minY, minZ, maxX, minY, minZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, minY, minZ, maxX, minY, maxZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, minY, maxZ, minX, minY, maxZ, r, g, b, a);
        this.addLine(consumer, pose, minX, minY, maxZ, minX, minY, minZ, r, g, b, a);
        this.addLine(consumer, pose, minX, maxY, minZ, maxX, maxY, minZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, maxY, minZ, maxX, maxY, maxZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, maxY, maxZ, minX, maxY, maxZ, r, g, b, a);
        this.addLine(consumer, pose, minX, maxY, maxZ, minX, maxY, minZ, r, g, b, a);
        this.addLine(consumer, pose, minX, minY, minZ, minX, maxY, minZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, minY, minZ, maxX, maxY, minZ, r, g, b, a);
        this.addLine(consumer, pose, maxX, minY, maxZ, maxX, maxY, maxZ, r, g, b, a);
        this.addLine(consumer, pose, minX, minY, maxZ, minX, maxY, maxZ, r, g, b, a);
    }

    @Unique
    private void addLine(class_4588 consumer, class_4587.class_4665 pose, float x1, float y1, float z1, float x2, float y2, float z2, float r, float g, float b, float a) {
        Vector3f normal = new Vector3f(x2 - x1, y2 - y1, z2 - z1).normalize();
        consumer.method_56824(pose, x1, y1, z1).method_22915(r, g, b, a).method_60831(pose, normal.x, normal.y, normal.z).method_75298(1.0f);
        consumer.method_56824(pose, x2, y2, z2).method_22915(r, g, b, a).method_60831(pose, normal.x, normal.y, normal.z).method_75298(1.0f);
    }

    @Unique
    private void drawBoxFaces(class_4587.class_4665 pose, class_4588 buffer, class_238 box, float r, float g, float b, float a) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        this.addVertex(buffer, pose, minX, minY, minZ, r, g, b, a, 0.0f, -1.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, minY, minZ, r, g, b, a, 0.0f, -1.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, minY, maxZ, r, g, b, a, 0.0f, -1.0f, 0.0f);
        this.addVertex(buffer, pose, minX, minY, maxZ, r, g, b, a, 0.0f, -1.0f, 0.0f);
        this.addVertex(buffer, pose, minX, maxY, minZ, r, g, b, a, 0.0f, 1.0f, 0.0f);
        this.addVertex(buffer, pose, minX, maxY, maxZ, r, g, b, a, 0.0f, 1.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, maxY, maxZ, r, g, b, a, 0.0f, 1.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, maxY, minZ, r, g, b, a, 0.0f, 1.0f, 0.0f);
        this.addVertex(buffer, pose, minX, minY, minZ, r, g, b, a, 0.0f, 0.0f, -1.0f);
        this.addVertex(buffer, pose, minX, maxY, minZ, r, g, b, a, 0.0f, 0.0f, -1.0f);
        this.addVertex(buffer, pose, maxX, maxY, minZ, r, g, b, a, 0.0f, 0.0f, -1.0f);
        this.addVertex(buffer, pose, maxX, minY, minZ, r, g, b, a, 0.0f, 0.0f, -1.0f);
        this.addVertex(buffer, pose, minX, minY, maxZ, r, g, b, a, 0.0f, 0.0f, 1.0f);
        this.addVertex(buffer, pose, maxX, minY, maxZ, r, g, b, a, 0.0f, 0.0f, 1.0f);
        this.addVertex(buffer, pose, maxX, maxY, maxZ, r, g, b, a, 0.0f, 0.0f, 1.0f);
        this.addVertex(buffer, pose, minX, maxY, maxZ, r, g, b, a, 0.0f, 0.0f, 1.0f);
        this.addVertex(buffer, pose, minX, minY, minZ, r, g, b, a, -1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, minX, minY, maxZ, r, g, b, a, -1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, minX, maxY, maxZ, r, g, b, a, -1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, minX, maxY, minZ, r, g, b, a, -1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, minY, minZ, r, g, b, a, 1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, maxY, minZ, r, g, b, a, 1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, maxY, maxZ, r, g, b, a, 1.0f, 0.0f, 0.0f);
        this.addVertex(buffer, pose, maxX, minY, maxZ, r, g, b, a, 1.0f, 0.0f, 0.0f);
    }

    @Unique
    private void addVertex(class_4588 buffer, class_4587.class_4665 pose, float x, float y, float z, float r, float g, float b, float a, float normalX, float normalY, float normalZ) {
        buffer.method_56824(pose, x, y, z).method_22915(r, g, b, a).method_60831(pose, normalX, normalY, normalZ);
    }
}

