/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.interndep.flowsched.executor;

import ca.spottedleaf.starlight.interndep.flowsched.executor.ExecutorManager;
import ca.spottedleaf.starlight.interndep.flowsched.executor.Task;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FlowSched Executor Worker Thread");
    private final ExecutorManager executorManager;
    private volatile boolean shutdown = false;

    public WorkerThread(ExecutorManager executorManager) {
        this.executorManager = executorManager;
    }

    @Override
    public void run() {
        block0: while (true) {
            this.executorManager.waitObj.acquireUninterruptibly();
            if (this.shutdown) {
                return;
            }
            while (true) {
                if (this.shutdown || this.pollTasks()) continue block0;
                Thread.onSpinWait();
            }
            break;
        }
    }

    private boolean pollTasks() {
        Task task = this.executorManager.getGlobalWorkQueue().dequeue();
        if (task == null) {
            return false;
        }
        if (!this.executorManager.tryLock(task)) {
            return true;
        }
        try {
            AtomicBoolean released = new AtomicBoolean(false);
            try {
                task.run(() -> {
                    if (released.compareAndSet(false, true)) {
                        this.executorManager.releaseLocks(task);
                    }
                });
            }
            catch (Throwable t) {
                try {
                    if (released.compareAndSet(false, true)) {
                        this.executorManager.releaseLocks(task);
                    }
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                    LOGGER.error("Exception thrown while releasing locks", t);
                }
                try {
                    task.propagateException(t);
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                    LOGGER.error("Exception thrown while propagating exception", t);
                }
            }
            return true;
        }
        catch (Throwable t) {
            LOGGER.error("Exception thrown while executing task", t);
            return true;
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

