/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby.util;

import com.google.common.net.PercentEscaper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileSystemUtils {
    private static final PercentEscaper FALLBACK_NAME_ENCODER = new PercentEscaper(".-_ ", false);

    public static Path resolveSafeDirectoryName(Path parent, String name) {
        if (!name.contains("%") && FileSystemUtils.isUsable(parent, name)) {
            return parent.resolve(name);
        }
        return parent.resolve(FALLBACK_NAME_ENCODER.escape(name));
    }

    private static boolean isUsable(Path parent, String name) {
        Path path;
        if (name.contains(parent.getFileSystem().getSeparator())) {
            return false;
        }
        try {
            path = parent.resolve(name);
        }
        catch (InvalidPathException e) {
            return false;
        }
        if (Files.exists(path, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            return false;
        }
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

