/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.implementation.mixin;

import com.mojang.authlib.GameProfile;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.Optional;
import me.aleksilassila.litematica.printer.LitematicaMixinMod;
import me.aleksilassila.litematica.printer.Printer;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.UpdateChecker;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_746.class})
public class MixinClientPlayerEntity
extends class_742 {
    @Unique
    private static boolean didCheckForUpdates = false;
    @Final
    @Shadow
    protected class_310 field_3937;
    @Final
    @Shadow
    public class_634 field_3944;

    public MixinClientPlayerEntity(class_638 world, GameProfile profile) {
        super(world, profile);
    }

    @Inject(at={@At(value="TAIL")}, method={"method_5773()V"})
    public void tick(CallbackInfo ci) {
        class_746 clientPlayer = (class_746)this;
        if (!didCheckForUpdates) {
            didCheckForUpdates = true;
        }
        if (LitematicaMixinMod.printer == null || LitematicaMixinMod.printer.player != clientPlayer) {
            Printer.printDebug("Initializing printer, player: {}, client: {}", clientPlayer, this.field_3937);
            LitematicaMixinMod.printer = new Printer(this.field_3937, clientPlayer);
        }
        boolean didFindPlacement = true;
        for (int i = 0; i < 10; ++i) {
            if (didFindPlacement) {
                didFindPlacement = LitematicaMixinMod.printer.onGameTick();
            }
            LitematicaMixinMod.printer.actionHandler.onGameTick();
        }
    }

    @Unique
    public void checkForUpdates() {
        new Thread(() -> {
            String version = UpdateChecker.version;
            String newVersion = UpdateChecker.getPrinterVersion();
            Printer.printDebug("Current version: [{}], detected version [{}]", version, newVersion);
            if (!version.equals(newVersion)) {
                this.field_3937.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"New version of Litematica Printer available in https://github.com/aleksilassila/litematica-printer/releases"));
            }
        }).start();
    }

    @Inject(method={"method_7311(Lnet/minecraft/class_2625;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openEditSignScreen(class_2625 sign, boolean front, CallbackInfo ci) {
        this.getTargetSignEntity(sign).ifPresent(signBlockEntity -> {
            class_2877 packet = new class_2877(sign.method_11016(), front, signBlockEntity.method_49843(front).method_49859(0, false).getString(), signBlockEntity.method_49843(front).method_49859(1, false).getString(), signBlockEntity.method_49843(front).method_49859(2, false).getString(), signBlockEntity.method_49843(front).method_49859(3, false).getString());
            this.field_3944.method_52787((class_2596)packet);
            ci.cancel();
        });
    }

    @Unique
    private Optional<class_2625> getTargetSignEntity(class_2625 sign) {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        if (sign.method_10997() == null || worldSchematic == null) {
            return Optional.empty();
        }
        SchematicBlockState state = new SchematicBlockState(sign.method_10997(), worldSchematic, sign.method_11016());
        class_2586 targetBlockEntity = worldSchematic.method_8321(state.blockPos);
        if (targetBlockEntity instanceof class_2625) {
            class_2625 targetSignEntity = (class_2625)targetBlockEntity;
            return Optional.of(targetSignEntity);
        }
        return Optional.empty();
    }
}

