/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.guides.placement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.actions.Action;
import me.aleksilassila.litematica.printer.actions.PrepareAction;
import me.aleksilassila.litematica.printer.guides.placement.GeneralPlacementGuide;
import me.aleksilassila.litematica.printer.implementation.PrinterPlacementContext;
import net.minecraft.class_2215;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2508;
import net.minecraft.class_2546;
import net.minecraft.class_2549;
import net.minecraft.class_2551;
import net.minecraft.class_2741;
import net.minecraft.class_746;

public class RotatingBlockGuide
extends GeneralPlacementGuide {
    public RotatingBlockGuide(SchematicBlockState state) {
        super(state);
    }

    @Override
    protected List<class_2350> getPossibleSides() {
        class_2248 block = this.state.targetState.method_26204();
        if (block instanceof class_2549 || block instanceof class_2551 || block instanceof class_2546) {
            Optional<class_2350> side = RotatingBlockGuide.getProperty(this.state.targetState, class_2741.field_12481).map(class_2350::method_10153);
            return side.map(Collections::singletonList).orElseGet(Collections::emptyList);
        }
        return Collections.singletonList(class_2350.field_11033);
    }

    @Override
    public boolean skipOtherGuides() {
        return true;
    }

    @Override
    @Nonnull
    public List<Action> execute(class_746 player) {
        PrinterPlacementContext ctx = this.getPlacementContext(player);
        if (ctx == null) {
            return new ArrayList<Action>();
        }
        int rotation = RotatingBlockGuide.getProperty(this.state.targetState, class_2741.field_12532).orElse(0);
        if (this.targetState.method_26204() instanceof class_2215 || this.targetState.method_26204() instanceof class_2508) {
            rotation = (rotation + 8) % 16;
        }
        int distTo0 = rotation > 8 ? 16 - rotation : rotation;
        float yaw = Math.round((float)distTo0 / 8.0f * 180.0f * (float)(rotation > 8 ? -1 : 1));
        List<Action> actions = super.execute(player);
        actions.set(0, new PrepareAction(ctx, yaw, 0.0f));
        return actions;
    }
}

