/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.guides.placement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.guides.placement.GuesserGuide;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;

public class RailGuesserGuide
extends GuesserGuide {
    static final class_2768[] STRAIGHT_RAIL_SHAPES = new class_2768[]{class_2768.field_12665, class_2768.field_12674};

    public RailGuesserGuide(SchematicBlockState state) {
        super(state);
    }

    @Override
    public boolean skipOtherGuides() {
        return true;
    }

    @Override
    protected boolean statesEqual(class_2680 resultState, class_2680 targetState) {
        if (!this.wouldConnectCorrectly()) {
            return false;
        }
        if (this.getRailShape(resultState).isPresent() && Arrays.stream(STRAIGHT_RAIL_SHAPES).anyMatch(shape -> shape == this.getRailShape(resultState).orElse(null))) {
            return super.statesEqualIgnoreProperties(resultState, targetState, new class_2769[]{class_2741.field_12507, class_2741.field_12542, class_2741.field_12484});
        }
        return super.statesEqual(resultState, targetState);
    }

    private boolean wouldConnectCorrectly() {
        class_2768 targetShape = this.getRailShape(this.state.targetState).orElse(null);
        if (targetShape == null) {
            return false;
        }
        List<class_2350> allowedConnections = this.getRailDirections(targetShape);
        ArrayList<class_2350> possibleConnections = new ArrayList<class_2350>();
        for (class_2350 d : class_2350.values()) {
            SchematicBlockState neighbor;
            if (d.method_10166().method_10178() || !this.hasFreeConnections(neighbor = this.state.offset(d))) continue;
            possibleConnections.add(d);
        }
        if (possibleConnections.size() > 2) {
            return false;
        }
        return new HashSet<class_2350>(allowedConnections).containsAll(possibleConnections);
    }

    private boolean hasFreeConnections(SchematicBlockState state) {
        List<class_2350> possibleConnections = this.getRailDirections(state);
        if (possibleConnections.isEmpty()) {
            return false;
        }
        for (class_2350 d : possibleConnections) {
            SchematicBlockState neighbor = state.offset(d);
            if (neighbor.currentState.method_26204() == neighbor.currentState.method_26204()) continue;
            return false;
        }
        return possibleConnections.stream().anyMatch(possibleDirection -> {
            SchematicBlockState neighbor = state.offset((class_2350)possibleDirection);
            return !this.getRailDirections(neighbor).contains(possibleDirection.method_10153());
        });
    }

    private List<class_2350> getRailDirections(SchematicBlockState state) {
        class_2768 shape = this.getRailShape(state.currentState).orElse(null);
        if (shape == null) {
            return new ArrayList<class_2350>();
        }
        return this.getRailDirections(shape);
    }

    private List<class_2350> getRailDirections(class_2768 railShape) {
        String name = railShape.method_35309();
        if (railShape.method_11897()) {
            class_2350 d = class_2350.valueOf((String)name.replace("ascending_", "").toUpperCase());
            return Arrays.asList(d, d.method_10153());
        }
        class_2350 d1 = class_2350.valueOf((String)name.split("_")[0].toUpperCase());
        class_2350 d2 = class_2350.valueOf((String)name.split("_")[1].toUpperCase());
        return Arrays.asList(d1, d2);
    }

    Optional<class_2768> getRailShape(class_2680 state) {
        Optional<class_2768> shape = RailGuesserGuide.getProperty(state, class_2741.field_12507);
        if (shape.isEmpty()) {
            return RailGuesserGuide.getProperty(state, class_2741.field_12542);
        }
        return shape;
    }
}

