/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.guides.placement;

import fi.dy.masa.litematica.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.aleksilassila.litematica.printer.Printer;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.actions.Action;
import me.aleksilassila.litematica.printer.actions.PrepareAction;
import me.aleksilassila.litematica.printer.actions.ReleaseShiftAction;
import me.aleksilassila.litematica.printer.config.Configs;
import me.aleksilassila.litematica.printer.guides.Guide;
import me.aleksilassila.litematica.printer.implementation.PrinterPlacementContext;
import me.aleksilassila.litematica.printer.implementation.actions.InteractActionImpl;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2478;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import net.minecraft.class_746;

public abstract class PlacementGuide
extends Guide {
    public PlacementGuide(SchematicBlockState state) {
        super(state);
    }

    protected class_1799 getBlockItem(class_2680 state) {
        return ItemUtils.getItemForBlock((class_1937)this.state.world, (class_2338)this.state.blockPos, (class_2680)state, (boolean)true);
    }

    protected Optional<class_2248> getRequiredItemAsBlock(class_746 player) {
        Optional<class_1799> requiredItem = this.getRequiredItem(player);
        if (requiredItem.isEmpty()) {
            return Optional.empty();
        }
        class_1799 itemStack = requiredItem.get();
        if (itemStack.method_7909() instanceof class_1747) {
            return Optional.of(((class_1747)itemStack.method_7909()).method_7711());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected List<class_1799> getRequiredItems() {
        Printer.printDebug("PlacementGuide#getRequiredItems() - target state [{}]", this.state.targetState.toString());
        return Collections.singletonList(this.getBlockItem(this.state.targetState));
    }

    protected abstract boolean getUseShift(SchematicBlockState var1);

    @Nullable
    public abstract PrinterPlacementContext getPlacementContext(class_746 var1);

    @Override
    public boolean canExecute(class_746 player) {
        if (!super.canExecute(player)) {
            return false;
        }
        List<class_1799> requiredItems = this.getRequiredItems();
        if (requiredItems.isEmpty() || requiredItems.stream().allMatch(i -> i.method_31574(class_1802.field_8162))) {
            return false;
        }
        PrinterPlacementContext ctx = this.getPlacementContext(player);
        if (ctx == null || !ctx.method_7716()) {
            return false;
        }
        if (!Configs.REPLACE_FLUIDS_SOURCE_BLOCKS.getBooleanValue() && PlacementGuide.getProperty(this.state.currentState, class_2404.field_11278).orElse(1) == 0) {
            return false;
        }
        class_2680 resultState = this.getRequiredItemAsBlock(player).orElse(this.targetState.method_26204()).method_9605((class_1750)ctx);
        if (resultState != null) {
            if (!resultState.method_26184((class_4538)this.state.world, this.state.blockPos)) {
                return false;
            }
            return !(this.currentState.method_26204() instanceof class_2404) || this.canPlaceInWater(resultState);
        }
        return false;
    }

    @Override
    @Nonnull
    public List<Action> execute(class_746 player) {
        ArrayList<Action> actions = new ArrayList<Action>();
        PrinterPlacementContext ctx = this.getPlacementContext(player);
        if (ctx == null) {
            return actions;
        }
        actions.add(new PrepareAction(ctx));
        actions.add(new InteractActionImpl(ctx));
        if (ctx.shouldSneak) {
            actions.add(new ReleaseShiftAction());
        }
        return actions;
    }

    protected static boolean canBeClicked(class_1937 world, class_2338 pos) {
        return PlacementGuide.getOutlineShape(world, pos) != class_259.method_1073() && !(world.method_8320(pos).method_26204() instanceof class_2478);
    }

    private static class_265 getOutlineShape(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26218((class_1922)world, pos);
    }

    public boolean isInteractive(class_2248 block) {
        for (Class clazz : interactiveBlocks) {
            if (!clazz.isInstance(block)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceInWater(class_2680 blockState) {
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2402) {
            return true;
        }
        if (!(block instanceof class_2323 || blockState.method_26204() instanceof class_2478 || blockState.method_27852(class_2246.field_9983) || blockState.method_27852(class_2246.field_10424) || blockState.method_27852(class_2246.field_10422))) {
            return blockState.method_51366();
        }
        return true;
    }
}

