/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.guides.placement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import me.aleksilassila.litematica.printer.Printer;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.config.Configs;
import me.aleksilassila.litematica.printer.guides.placement.PlacementGuide;
import me.aleksilassila.litematica.printer.implementation.PrinterPlacementContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2771;
import net.minecraft.class_3965;
import net.minecraft.class_746;

public class GeneralPlacementGuide
extends PlacementGuide {
    public GeneralPlacementGuide(SchematicBlockState state) {
        super(state);
    }

    protected List<class_2350> getPossibleSides() {
        return Arrays.asList(class_2350.values());
    }

    protected Optional<class_2350> getLookDirection() {
        return Optional.empty();
    }

    protected boolean getRequiresSupport() {
        return false;
    }

    protected boolean getRequiresExplicitShift() {
        return false;
    }

    protected class_243 getHitModifier(class_2350 validSide) {
        return new class_243(0.0, 0.0, 0.0);
    }

    private Optional<class_2350> getValidSide(SchematicBlockState state) {
        boolean printInAir = Configs.PRINT_IN_AIR.getBooleanValue();
        List<class_2350> sides = this.getPossibleSides();
        if (sides.isEmpty()) {
            return Optional.empty();
        }
        if (printInAir && !this.getRequiresSupport()) {
            return Optional.of(class_2350.field_11036);
        }
        ArrayList<class_2350> validSides = new ArrayList<class_2350>();
        for (class_2350 side : sides) {
            SchematicBlockState neighborState = state.offset(side);
            if (GeneralPlacementGuide.getProperty(neighborState.currentState, class_2482.field_11501).orElse(null) == class_2771.field_12682) {
                validSides.add(side);
                continue;
            }
            if (!GeneralPlacementGuide.canBeClicked(neighborState.world, neighborState.blockPos) || neighborState.currentState.method_45474()) continue;
            validSides.add(side);
        }
        for (class_2350 validSide : validSides) {
            if (this.isInteractive(state.offset((class_2350)validSide).currentState.method_26204())) continue;
            return Optional.of(validSide);
        }
        return validSides.isEmpty() ? Optional.empty() : Optional.of((class_2350)validSides.getFirst());
    }

    @Override
    protected boolean getUseShift(SchematicBlockState state) {
        if (this.getRequiresExplicitShift()) {
            return true;
        }
        class_2350 clickSide = this.getValidSide(state).orElse(null);
        if (clickSide == null) {
            return false;
        }
        return this.isInteractive(state.offset((class_2350)clickSide).currentState.method_26204());
    }

    private Optional<class_243> getHitVector(SchematicBlockState state) {
        boolean printInAir = Configs.PRINT_IN_AIR.getBooleanValue();
        if (printInAir && !this.getRequiresSupport()) {
            return Optional.of(class_243.method_24953((class_2382)state.blockPos));
        }
        return this.getValidSide(state).map(side -> class_243.method_24953((class_2382)state.blockPos).method_1019(class_243.method_24954((class_2382)side.method_62675()).method_1021(0.5)).method_1019(this.getHitModifier((class_2350)side)));
    }

    @Override
    @Nullable
    public PrinterPlacementContext getPlacementContext(class_746 player) {
        try {
            Optional<class_2350> validSide = this.getValidSide(this.state);
            Optional<class_243> hitVec = this.getHitVector(this.state);
            Optional<class_1799> requiredItem = this.getRequiredItem(player);
            int requiredSlot = this.getRequiredItemStackSlot(player);
            if (validSide.isEmpty() || hitVec.isEmpty() || requiredItem.isEmpty() || requiredSlot == -1) {
                return null;
            }
            Optional<class_2350> lookDirection = this.getLookDirection();
            boolean requiresShift = this.getUseShift(this.state);
            boolean printInAir = Configs.PRINT_IN_AIR.getBooleanValue();
            class_3965 blockHitResult = printInAir && !this.getRequiresSupport() ? new class_3965(hitVec.get(), class_2350.field_11033, this.state.blockPos, false) : new class_3965(hitVec.get(), validSide.get().method_10153(), this.state.blockPos.method_10093(validSide.get()), false);
            return new PrinterPlacementContext((class_1657)player, blockHitResult, requiredItem.get(), requiredSlot, lookDirection.orElse(null), requiresShift);
        }
        catch (Exception e) {
            Printer.logger.error("getPlacementContext(): Exception caught: {}", (Object)e.getMessage());
            return null;
        }
    }
}

