/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer.guides;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.actions.Action;
import me.aleksilassila.litematica.printer.implementation.BlockHelperImpl;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2301;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_746;

public abstract class Guide
extends BlockHelperImpl {
    protected final SchematicBlockState state;
    protected final class_2680 currentState;
    protected final class_2680 targetState;

    public Guide(SchematicBlockState state) {
        this.state = state;
        this.currentState = state.currentState;
        this.targetState = state.targetState;
    }

    protected boolean playerHasRightItem(class_746 player) {
        return this.getRequiredItemStackSlot(player) != -1;
    }

    protected int getSlotWithItem(class_746 player, class_1799 itemStack) {
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_67533().size(); ++i) {
            if (itemStack.method_7960() && ((class_1799)inventory.method_67533().get(i)).method_31574(itemStack.method_7909())) {
                return i;
            }
            if (((class_1799)inventory.method_67533().get(i)).method_7960() || !class_1799.method_7984((class_1799)((class_1799)inventory.method_67533().get(i)), (class_1799)itemStack)) continue;
            return i;
        }
        return -1;
    }

    protected int getRequiredItemStackSlot(class_746 player) {
        if (player.method_31549().field_7477) {
            return player.method_31548().method_67532();
        }
        Optional<class_1799> requiredItem = this.getRequiredItem(player);
        return requiredItem.map(itemStack -> this.getSlotWithItem(player, (class_1799)itemStack)).orElse(-1);
    }

    public boolean canExecute(class_746 player) {
        if (!this.playerHasRightItem(player)) {
            return false;
        }
        class_2680 targetState = this.state.targetState;
        class_2680 currentState = this.state.currentState;
        return !this.statesEqual(targetState, currentState);
    }

    @Nonnull
    public abstract List<Action> execute(class_746 var1);

    @Nonnull
    protected abstract List<class_1799> getRequiredItems();

    protected Optional<class_1799> getRequiredItem(class_746 player) {
        List<class_1799> requiredItems = this.getRequiredItems();
        for (class_1799 requiredItem : requiredItems) {
            if (player.method_31549().field_7477) {
                return Optional.of(requiredItem);
            }
            int slot = this.getSlotWithItem(player, requiredItem);
            if (slot <= -1) continue;
            return Optional.of(requiredItem);
        }
        return Optional.empty();
    }

    protected boolean statesEqualIgnoreProperties(class_2680 state1, class_2680 state2, class_2769<?> ... propertiesToIgnore) {
        if (state1.method_26204() != state2.method_26204()) {
            return false;
        }
        block2: for (class_2769 property : state1.method_28501()) {
            if (property == class_2741.field_12508 && !(state1.method_26204() instanceof class_2301)) continue;
            for (class_2769<?> ignoredProperty : propertiesToIgnore) {
                if (property == ignoredProperty) continue block2;
            }
            try {
                if (state1.method_11654(property).equals(state2.method_11654(property))) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected static <T extends Comparable<T>> Optional<T> getProperty(class_2680 blockState, class_2769<T> property) {
        if (blockState.method_28498(property)) {
            return Optional.of(blockState.method_11654(property));
        }
        return Optional.empty();
    }

    protected boolean statesEqual(class_2680 state1, class_2680 state2) {
        return this.statesEqualIgnoreProperties(state1, state2, new class_2769[0]);
    }

    public boolean skipOtherGuides() {
        return false;
    }
}

