/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.aleksilassila.litematica.printer.ActionHandler;
import me.aleksilassila.litematica.printer.SchematicBlockState;
import me.aleksilassila.litematica.printer.actions.Action;
import me.aleksilassila.litematica.printer.config.Configs;
import me.aleksilassila.litematica.printer.config.Hotkeys;
import me.aleksilassila.litematica.printer.guides.Guide;
import me.aleksilassila.litematica.printer.guides.Guides;
import net.minecraft.class_1297;
import net.minecraft.class_1656;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Printer {
    public static final Logger logger = LogManager.getLogger((String)"litematica_printer");
    @Nonnull
    public final class_746 player;
    public final ActionHandler actionHandler;
    private final Guides interactionGuides = new Guides();

    public Printer(@Nonnull class_310 client, @Nonnull class_746 player) {
        this.player = player;
        this.actionHandler = new ActionHandler(client, player);
    }

    public boolean onGameTick() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        if (!this.actionHandler.acceptsActions()) {
            return false;
        }
        if (worldSchematic == null) {
            return false;
        }
        if (!Configs.PRINT_MODE.getBooleanValue() && !Hotkeys.PRINT.getKeybind().isPressed()) {
            return false;
        }
        class_1656 abilities = this.player.method_31549();
        if (!abilities.field_7476) {
            return false;
        }
        List<class_2338> positions = this.getReachablePositions();
        block0: for (class_2338 position : positions) {
            SchematicBlockState state = new SchematicBlockState(this.player.method_73183(), worldSchematic, position);
            if (state.targetState.equals((Object)state.currentState) || state.targetState.method_26215()) continue;
            Guide[] guides = this.interactionGuides.getInteractionGuides(state);
            class_3965 result = RayTraceUtils.traceToSchematicWorld((class_1297)this.player, (double)10.0, (boolean)true, (boolean)true);
            boolean isCurrentlyLookingSchematic = result != null && result.method_17777().equals((Object)position);
            for (Guide guide : guides) {
                if (guide.canExecute(this.player) && Configs.INTERACT_BLOCKS.getBooleanValue()) {
                    Printer.printDebug("Executing {} for {}", guide, state);
                    List<Action> actions = guide.execute(this.player);
                    this.actionHandler.addActions((Action[])actions.toArray(Action[]::new));
                    return true;
                }
                if (guide.skipOtherGuides()) continue block0;
            }
        }
        return false;
    }

    private List<class_2338> getReachablePositions() {
        int maxReach = (int)Math.ceil(Configs.PRINTING_RANGE.getDoubleValue());
        double maxReachSquared = class_3532.method_33723((double)Configs.PRINTING_RANGE.getDoubleValue());
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int y = -maxReach; y < maxReach + 1; ++y) {
            for (int x = -maxReach; x < maxReach + 1; ++x) {
                for (int z = -maxReach; z < maxReach + 1; ++z) {
                    class_2338 blockPos = this.player.method_24515().method_10076(x).method_10088(z).method_10086(y);
                    if (!DataManager.getRenderLayerRange().isPositionWithinRange(blockPos) || this.player.method_33571().method_1025(class_243.method_24953((class_2382)blockPos)) > maxReachSquared) continue;
                    positions.add(blockPos);
                }
            }
        }
        return positions.stream().filter(p -> {
            class_243 vec = class_243.method_24953((class_2382)p);
            return this.player.method_73189().method_1025(vec) > 1.0 && this.player.method_33571().method_1025(vec) > 1.0;
        }).sorted((a, b) -> {
            double aDistance = this.player.method_73189().method_1025(class_243.method_24953((class_2382)a));
            double bDistance = this.player.method_73189().method_1025(class_243.method_24953((class_2382)b));
            return Double.compare(aDistance, bDistance);
        }).toList();
    }

    public static void printDebug(String key, Object ... args) {
        if (Configs.PRINT_DEBUG.getBooleanValue()) {
            logger.info(key, args);
        }
    }
}

