/*
 * Decompiled with CFR 0.152.
 */
package me.aleksilassila.litematica.printer;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import me.aleksilassila.litematica.printer.Printer;
import me.aleksilassila.litematica.printer.actions.Action;
import me.aleksilassila.litematica.printer.actions.PrepareAction;
import me.aleksilassila.litematica.printer.config.Configs;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ActionHandler {
    private final class_310 client;
    private final class_746 player;
    private final Queue<Action> actionQueue = new LinkedList<Action>();
    public PrepareAction lookAction = null;
    private int tick = 0;

    public ActionHandler(class_310 client, class_746 player) {
        this.client = client;
        this.player = player;
    }

    public void onGameTick() {
        int tickRate = Configs.PRINTING_INTERVAL.getIntegerValue();
        int n = this.tick = this.tick % tickRate == tickRate - 1 ? 0 : this.tick + 1;
        if (this.tick % tickRate != 0) {
            return;
        }
        Action nextAction = this.actionQueue.poll();
        if (nextAction != null) {
            Printer.printDebug("Sending action {}", nextAction);
            nextAction.send(this.client, this.player);
        } else {
            this.lookAction = null;
        }
    }

    public boolean acceptsActions() {
        return this.actionQueue.isEmpty();
    }

    public void addActions(Action ... actions) {
        if (!this.acceptsActions()) {
            return;
        }
        for (Action action : actions) {
            if (!(action instanceof PrepareAction)) continue;
            this.lookAction = (PrepareAction)action;
        }
        this.actionQueue.addAll(List.of(actions));
    }
}

