/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.util.UriBuilder;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Ldev/dediamondpro/resourcify/util/ImageURLUtils;", "", "<init>", "()V", "Ljava/net/URI;", "url", "", "width", "height", "Ldev/dediamondpro/resourcify/util/ImageURLUtils$Fit;", "fit", "getTransformedImageUrl", "(Ljava/net/URI;Ljava/lang/Float;Ljava/lang/Float;Ldev/dediamondpro/resourcify/util/ImageURLUtils$Fit;)Ljava/net/URI;", "uri", "", "getExtension", "(Ljava/net/URI;)Ljava/lang/String;", "", "hasImageReaderFor", "(Ljava/net/URI;)Z", "Lkotlin/text/Regex;", "urlExtensionRegex", "Lkotlin/text/Regex;", "", "allowedHostNames", "Ljava/util/List;", "Fit", "Resourcify (1.21.11-fabric)-1.8.0"})
public final class ImageURLUtils {
    @NotNull
    public static final ImageURLUtils INSTANCE = new ImageURLUtils();
    @NotNull
    private static final Regex urlExtensionRegex = new Regex(".*\\.(\\w+)$");
    @NotNull
    private static final List<String> allowedHostNames;

    private ImageURLUtils() {
    }

    @NotNull
    public final URI getTransformedImageUrl(@NotNull URI url, @Nullable Float width, @Nullable Float height, @NotNull Fit fit) {
        URI uRI;
        boolean useProxy;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)fit), (String)"fit");
        boolean canReadType = this.hasImageReaderFor(url);
        boolean bl = useProxy = !allowedHostNames.contains(url.getHost()) || !canReadType || width != null || height != null;
        if (!useProxy) {
            uRI = Intrinsics.areEqual((Object)url.getHost(), (Object)"img.shields.io") ? new URI(url.getScheme(), url.getUserInfo(), "raster.shields.io", url.getPort(), url.getPath(), url.getQuery(), url.getFragment()) : url;
        } else {
            UriBuilder uriBuilder;
            UriBuilder $this$getTransformedImageUrl_u24lambda_u240 = uriBuilder = new UriBuilder("https://wsrv.nl/");
            boolean bl2 = false;
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $this$getTransformedImageUrl_u24lambda_u240.addParameter("url", string);
            if (!canReadType) {
                $this$getTransformedImageUrl_u24lambda_u240.addParameter("output", "png");
            }
            if (width != null) {
                $this$getTransformedImageUrl_u24lambda_u240.addParameter("w", width.toString());
            }
            if (height != null) {
                $this$getTransformedImageUrl_u24lambda_u240.addParameter("h", height.toString());
            }
            if (width != null || height != null) {
                String string2 = fit.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                $this$getTransformedImageUrl_u24lambda_u240.addParameter("fit", string2);
                $this$getTransformedImageUrl_u24lambda_u240.addParameter("we", "");
            }
            uRI = uriBuilder.build();
        }
        return uRI;
    }

    public static /* synthetic */ URI getTransformedImageUrl$default(ImageURLUtils imageURLUtils, URI uRI, Float f, Float f2, Fit fit, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        if ((n & 4) != 0) {
            f2 = null;
        }
        if ((n & 8) != 0) {
            fit = Fit.INSIDE;
        }
        return imageURLUtils.getTransformedImageUrl(uRI, f, f2, fit);
    }

    @NotNull
    public final String getExtension(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getRawPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawPath(...)");
        String extension = urlExtensionRegex.replace((CharSequence)string, "$1");
        if (Intrinsics.areEqual((Object)extension, (Object)uri.getRawPath())) {
            return "";
        }
        return extension;
    }

    private final boolean hasImageReaderFor(URI uri) {
        String extension = this.getExtension(uri);
        return ((CharSequence)extension).length() == 0 || ImageIO.getImageReadersBySuffix(extension).hasNext();
    }

    static {
        Object[] objectArray = new String[]{"imgur.com", "i.imgur.com", "cdn-raw.modrinth.com", "cdn.modrinth.com", "staging-cdn-raw.modrinth.com", "staging-cdn.modrinth.com", "github.com", "raw.githubusercontent.com", "user-images.githubusercontent.com", "avatars.githubusercontent.com", "img.shields.io", "raster.shields.io", "i.postimg.cc", "wsrv.nl", "cf.way2muchnoise.eu", "bstats.org", "media.forgecdn.net", "static.planetminecraft.com"};
        allowedHostNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ldev/dediamondpro/resourcify/util/ImageURLUtils$Fit;", "", "<init>", "(Ljava/lang/String;I)V", "INSIDE", "OUTSIDE", "COVER", "FILL", "CONTAIN", "Resourcify (1.21.11-fabric)-1.8.0"})
    public static final class Fit
    extends Enum<Fit> {
        public static final /* enum */ Fit INSIDE = new Fit();
        public static final /* enum */ Fit OUTSIDE = new Fit();
        public static final /* enum */ Fit COVER = new Fit();
        public static final /* enum */ Fit FILL = new Fit();
        public static final /* enum */ Fit CONTAIN = new Fit();
        private static final /* synthetic */ Fit[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Fit[] values() {
            return (Fit[])$VALUES.clone();
        }

        public static Fit valueOf(String value) {
            return Enum.valueOf(Fit.class, value);
        }

        @NotNull
        public static EnumEntries<Fit> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = fitArray = new Fit[]{Fit.INSIDE, Fit.OUTSIDE, Fit.COVER, Fit.FILL, Fit.CONTAIN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

