/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.elements.image.IUIImage;
import dev.dediamondpro.resourcify.elements.image.UIAnimatedImage;
import dev.dediamondpro.resourcify.elements.image.UIImageWrapper;
import dev.dediamondpro.resourcify.libs.elementa.components.UIImage;
import dev.dediamondpro.resourcify.libs.minemark.providers.ImageProvider;
import dev.dediamondpro.resourcify.util.AnimatedImageCache;
import dev.dediamondpro.resourcify.util.EmptyImage;
import dev.dediamondpro.resourcify.util.ImageCache;
import dev.dediamondpro.resourcify.util.ImageURLUtils;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J3\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/dediamondpro/resourcify/util/CachingImageProvider;", "Ldev/dediamondpro/resourcify/libs/minemark/providers/ImageProvider;", "Ldev/dediamondpro/resourcify/elements/image/IUIImage;", "<init>", "()V", "", "src", "Ljava/util/function/Consumer;", "Ldev/dediamondpro/resourcify/libs/minemark/providers/ImageProvider$Dimension;", "dimensionCallback", "imageCallback", "", "getImage", "(Ljava/lang/String;Ljava/util/function/Consumer;Ljava/util/function/Consumer;)V", "Resourcify (1.21.11-fabric)-1.8.0"})
public final class CachingImageProvider
implements ImageProvider<IUIImage> {
    @NotNull
    public static final CachingImageProvider INSTANCE = new CachingImageProvider();

    private CachingImageProvider() {
    }

    @Override
    public void getImage(@NotNull String src, @NotNull Consumer<ImageProvider.Dimension> dimensionCallback, @NotNull Consumer<IUIImage> imageCallback) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter(dimensionCallback, (String)"dimensionCallback");
        Intrinsics.checkNotNullParameter(imageCallback, (String)"imageCallback");
        CompletableFuture.runAsync(() -> CachingImageProvider.getImage$lambda$4(src, dimensionCallback, imageCallback));
    }

    private static final List getImage$lambda$4$lambda$0(URI $transformedUri) {
        URL uRL = $transformedUri.toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        InputStream inputStream = NetworkUtilKt.getImageInputStream(uRL);
        if (inputStream == null) {
            throw new IllegalStateException("Failed to setup connection".toString());
        }
        return UIAnimatedImage.Companion.provideFrames(inputStream);
    }

    private static final List getImage$lambda$4$lambda$1(List $frames) {
        return $frames;
    }

    private static final BufferedImage getImage$lambda$4$lambda$3$lambda$2(URI $transformedUri) {
        URL uRL = $transformedUri.toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return ImageIO.read(NetworkUtilKt.getImageInputStream(uRL));
    }

    private static final UIImage getImage$lambda$4$lambda$3(URI $transformedUri) {
        return new UIImage(MultiThreadingKt.supply(() -> CachingImageProvider.getImage$lambda$4$lambda$3$lambda$2($transformedUri)), EmptyImage.INSTANCE, null, 4, null);
    }

    private static final void getImage$lambda$4(String $src, Consumer $dimensionCallback, Consumer $imageCallback) {
        URI transformedUri = ImageURLUtils.getTransformedImageUrl$default(ImageURLUtils.INSTANCE, NetworkUtilKt.toURI($src), null, null, null, 14, null);
        if (UIAnimatedImage.Companion.supportsExtension(ImageURLUtils.INSTANCE.getExtension(transformedUri))) {
            List frames = (List)AnimatedImageCache.INSTANCE.getOrPut(transformedUri, () -> CachingImageProvider.getImage$lambda$4$lambda$0(transformedUri));
            UIAnimatedImage image = new UIAnimatedImage(MultiThreadingKt.supply(() -> CachingImageProvider.getImage$lambda$4$lambda$1(frames)), EmptyImage.INSTANCE, null, 4, null);
            $dimensionCallback.accept(new ImageProvider.Dimension(image.getImageWidth(), image.getImageHeight()));
            $imageCallback.accept(image);
        } else {
            UIImageWrapper image = new UIImageWrapper((UIImage)ImageCache.INSTANCE.getOrPut(transformedUri, () -> CachingImageProvider.getImage$lambda$4$lambda$3(transformedUri)));
            $dimensionCallback.accept(new ImageProvider.Dimension(image.getImageWidth(), image.getImageHeight()));
            $imageCallback.accept(image);
        }
    }
}

