/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.client.defaults;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.client.WhereIsItClient;
import red.jackf.whereisit.client.api.events.SearchInvoker;
import red.jackf.whereisit.client.render.Rendering;
import red.jackf.whereisit.networking.ClientboundResultsPacket;
import red.jackf.whereisit.networking.ServerboundSearchForItemPacket;

@Environment(value=EnvType.CLIENT)
public class SearchInvokerDefaults {
    private static final AtomicLong packetCounter = new AtomicLong(0L);
    private static final ConcurrentMap<Long, Consumer<Collection<SearchResult>>> consumers = new ConcurrentHashMap<Long, Consumer<Collection<SearchResult>>>();
    private static final Timer consumerCleanupTimer = new Timer("WhereIsIt Network Consumer Cleanup", true);
    private static final Long CONSUMER_CLEANUP_DELAY = 10000L;

    private static TimerTask removeFromConsumerMap(final long id) {
        return new TimerTask(){

            @Override
            public void run() {
                consumers.remove(id);
            }
        };
    }

    static void setup() {
        SearchInvoker.EVENT.register((request, resultConsumer) -> {
            if (ClientPlayNetworking.canSend(ServerboundSearchForItemPacket.TYPE)) {
                long id = packetCounter.incrementAndGet();
                ClientPlayNetworking.send((class_8710)new ServerboundSearchForItemPacket(id, request));
                consumers.put(id, resultConsumer);
                consumerCleanupTimer.schedule(SearchInvokerDefaults.removeFromConsumerMap(id), CONSUMER_CLEANUP_DELAY);
                return true;
            }
            return false;
        });
        ClientPlayNetworking.registerGlobalReceiver(ClientboundResultsPacket.TYPE, (packet, context) -> {
            if (packet.id() == -1L) {
                Rendering.resetSearchTime();
                WhereIsItClient.recieveResults(packet.results());
            } else {
                Consumer consumer = (Consumer)consumers.remove(packet.id());
                if (consumer != null) {
                    context.client().execute(() -> consumer.accept(packet.results()));
                }
            }
            if (packet.request() != null) {
                Rendering.setLastRequest(packet.request());
            }
        });
    }
}

