/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.whereisit.api;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import red.jackf.whereisit.util.Codecs;

public final class SearchResult {
    public static final class_9139<class_9129, SearchResult> STREAM_CODEC = class_9139.method_56906((class_9139)class_2338.field_48404, SearchResult::pos, (class_9139)class_1799.field_48349.method_56433(class_9135::method_56382).method_56432(opt -> opt.orElse(null), Optional::ofNullable), SearchResult::item, (class_9139)class_8824.field_48985.method_56432(opt -> opt.orElse(null), Optional::ofNullable), SearchResult::name, (class_9139)Codecs.VEC3.method_56433(class_9135::method_56382).method_56432(opt -> opt.orElse(null), Optional::ofNullable), SearchResult::customNameOffset, (class_9139)class_2338.field_48404.method_56433(class_9135.method_56374(HashSet::new)), SearchResult::otherPositions, SearchResult::new);
    private final class_2338 pos;
    @Nullable
    private final class_1799 item;
    @Nullable
    private final class_2561 name;
    @Nullable
    private final class_243 nameOffset;
    private final Set<class_2338> otherPositions = new HashSet<class_2338>();

    private SearchResult(class_2338 pos, @Nullable class_1799 item, @Nullable class_2561 name, @Nullable class_243 nameOffset, Collection<class_2338> otherPositions) {
        this.pos = pos;
        this.item = item;
        this.name = name;
        this.nameOffset = nameOffset;
        this.otherPositions.addAll(otherPositions);
    }

    public static Builder builder(class_2338 pos) {
        return new Builder(pos.method_10062());
    }

    public class_2338 pos() {
        return this.pos;
    }

    @Nullable
    public class_1799 item() {
        return this.item;
    }

    @Nullable
    public class_2561 name() {
        return this.name;
    }

    @Nullable
    public class_243 customNameOffset() {
        return this.nameOffset;
    }

    public Set<class_2338> otherPositions() {
        return this.otherPositions;
    }

    public class_243 nameOffset() {
        return this.nameOffset == null ? this.calculateDefaultOffset() : this.nameOffset;
    }

    public SearchResult withOtherPositions(List<class_2338> otherPositions) {
        SearchResult copy = new SearchResult(this.pos, this.item, this.name, this.nameOffset, otherPositions);
        copy.otherPositions.addAll(otherPositions);
        copy.otherPositions.remove(this.pos);
        return copy;
    }

    @ApiStatus.Internal
    private class_243 calculateDefaultOffset() {
        if (this.otherPositions.isEmpty()) {
            return new class_243(0.0, 1.0, 0.0);
        }
        class_243 base = class_243.method_24954((class_2382)this.pos);
        for (class_2338 otherPos : this.otherPositions) {
            base = base.method_1019(class_243.method_24954((class_2382)otherPos));
        }
        double factor = 1.0 / (double)(this.otherPositions.size() + 1);
        return base.method_18805(factor, factor, factor).method_1020(class_243.method_24954((class_2382)this.pos)).method_1031(0.0, 1.0, 0.0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult result = (SearchResult)o;
        return Objects.equals(this.pos, result.pos) && Objects.equals(this.item, result.item) && Objects.equals(this.name, result.name) && Objects.equals(this.nameOffset, result.nameOffset) && Objects.equals(this.otherPositions, result.otherPositions);
    }

    public int hashCode() {
        return Objects.hash(this.pos, this.item, this.name, this.nameOffset, this.otherPositions);
    }

    public String toString() {
        return "SearchResult{pos=" + String.valueOf(this.pos) + ", item=" + String.valueOf(this.item) + ", name=" + String.valueOf(this.name) + ", nameOffset=" + String.valueOf(this.nameOffset) + ", otherPositions=" + String.valueOf(this.otherPositions) + "}";
    }

    public static class Builder {
        private final class_2338 pos;
        @Nullable
        private class_1799 item;
        @Nullable
        private class_2561 name;
        @Nullable
        private class_243 nameOffset;
        private final Set<class_2338> otherPositions = new HashSet<class_2338>();

        private Builder(class_2338 pos) {
            this.pos = pos;
        }

        public Builder item(class_1799 item) {
            this.item = item;
            return this;
        }

        public Builder name(class_2561 name, class_243 offset) {
            this.name = name;
            this.nameOffset = offset;
            return this;
        }

        public Builder otherPositions(Collection<class_2338> others) {
            this.otherPositions.addAll(others);
            return this;
        }

        public SearchResult build() {
            return new SearchResult(this.pos, this.item, this.name, this.nameOffset, this.otherPositions);
        }
    }
}

