/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.FileBasedBackend;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class NbtBackend
extends FileBasedBackend {
    private static final Logger LOGGER = LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/NBT"));
    private final Map<String, CompletableFuture<Boolean>> pendingSavesNbt = new ConcurrentHashMap<String, CompletableFuture<Boolean>>();
    private final Map<String, Object> saveLocks = new ConcurrentHashMap<String, Object>();

    @Override
    @Nullable
    public MemoryBankImpl load(String id, @Nullable class_7225.class_7874 registries) {
        Optional<Metadata> meta = this.loadMetadata(id);
        if (meta.isEmpty()) {
            return null;
        }
        Path path = Constants.STORAGE_DIR.resolve(id + this.extension());
        Pair<Optional, Long> result = Misc.time(() -> FileUtil.loadFromNbt(MemoryBankImpl.DATA_CODEC, path, registries));
        if (((Optional)result.getFirst()).isPresent()) {
            LOGGER.debug("Loaded {} in {}ns", (Object)path, result.getSecond());
            return new MemoryBankImpl(meta.get(), (Map)((Optional)result.getFirst()).get());
        }
        return new MemoryBankImpl(meta.get(), new HashMap<class_2960, MemoryKeyImpl>());
    }

    @Override
    public boolean save(MemoryBankImpl memoryBank, @Nullable class_7225.class_7874 registries) {
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.AsyncSaving) {
            String id = memoryBank.getId();
            int entriesCount = memoryBank.getMemories().values().stream().mapToInt(key -> key.getMemories().size()).sum();
            Metadata metadataSnapshot = memoryBank.getMetadata().deepCopy();
            HashMap<class_2960, MemoryKeyImpl> memoriesSnapshot = new HashMap<class_2960, MemoryKeyImpl>(memoryBank.getMemories());
            metadataSnapshot.updateModified();
            LOGGER.debug("Created snapshot for {} ({} entries)", (Object)id, (Object)entriesCount);
            CompletableFuture<Boolean> previous = this.pendingSavesNbt.get(id);
            if (previous != null && !previous.isDone()) {
                LOGGER.debug("Previous save for {} still in progress, cancelling...", (Object)id);
                previous.cancel(true);
                try {
                    previous.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOGGER.warn("Previous save cancellation timed out or failed", (Throwable)e);
                }
            }
            CompletionStage future = CompletableFuture.supplyAsync(() -> {
                Object lock;
                Object object = lock = this.saveLocks.computeIfAbsent(id, k -> new Object());
                synchronized (object) {
                    if (Thread.currentThread().isInterrupted()) {
                        LOGGER.debug("Save for {} was cancelled before start", (Object)id);
                        return false;
                    }
                    LOGGER.debug("Starting async save for {}", (Object)id);
                    Path finalFile = Constants.STORAGE_DIR.resolve(id + this.extension());
                    long timestamp = System.currentTimeMillis();
                    Path tempFile = Constants.STORAGE_DIR.resolve(id + this.extension() + ".tmp." + timestamp);
                    Path oldFile = Constants.STORAGE_DIR.resolve(id + this.extension() + ".old");
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            LOGGER.debug("Save for {} was cancelled", (Object)id);
                            return false;
                        }
                        if (!this.saveMetadata(id, metadataSnapshot)) {
                            LOGGER.error("Failed to save metadata for {}", (Object)id);
                            return false;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            LOGGER.debug("Save for {} was cancelled during metadata save", (Object)id);
                            return false;
                        }
                        LOGGER.debug("Saving {} to temporary file: {}", (Object)id, (Object)tempFile.getFileName());
                        boolean saveSuccess = FileUtil.saveToNbt(memoriesSnapshot, MemoryBankImpl.DATA_CODEC, tempFile, registries);
                        if (!saveSuccess) {
                            LOGGER.error("Failed to save NBT data to temporary file for {}", (Object)id);
                            Files.deleteIfExists(tempFile);
                            return false;
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            LOGGER.debug("Save for {} was cancelled after NBT save", (Object)id);
                            Files.deleteIfExists(tempFile);
                            return false;
                        }
                        if (Files.exists(oldFile, new LinkOption[0])) {
                            LOGGER.debug("Removing previous .old file: {}", (Object)oldFile.getFileName());
                            try {
                                Files.delete(oldFile);
                            }
                            catch (IOException e) {
                                LOGGER.warn("Failed to delete old backup file: {}", (Object)oldFile.getFileName(), (Object)e);
                            }
                        }
                        if (Files.exists(finalFile, new LinkOption[0])) {
                            LOGGER.debug("Renaming current file to .old");
                            try {
                                Files.move(finalFile, oldFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to rename current file to .old for {}", (Object)id, (Object)e);
                                Files.deleteIfExists(tempFile);
                                return false;
                            }
                        }
                        LOGGER.debug("Renaming temporary file to final");
                        try {
                            Files.move(tempFile, finalFile, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (AtomicMoveNotSupportedException e) {
                            LOGGER.warn("Atomic move not supported, using regular move");
                            Files.move(tempFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to rename temporary file to final for {}", (Object)id, (Object)e);
                            if (Files.exists(oldFile, new LinkOption[0])) {
                                try {
                                    Files.move(oldFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
                                    LOGGER.info("Restored from .old backup");
                                }
                                catch (IOException restoreEx) {
                                    LOGGER.error("Failed to restore from backup!", (Throwable)restoreEx);
                                }
                            }
                            Files.deleteIfExists(tempFile);
                            return false;
                        }
                        LOGGER.debug("Successfully completed atomic save for {}", (Object)id);
                        try {
                            Files.list(Constants.STORAGE_DIR).filter(p -> p.getFileName().toString().startsWith(id + this.extension() + ".tmp.")).filter(p -> !p.equals(tempFile)).forEach(p -> {
                                try {
                                    Files.deleteIfExists(p);
                                    LOGGER.debug("Cleaned up old temporary file: {}", (Object)p.getFileName());
                                }
                                catch (IOException e) {
                                    LOGGER.debug("Could not clean up old temp file: {}", (Object)e.getMessage());
                                }
                            });
                        }
                        catch (IOException e) {
                            LOGGER.debug("Could not list directory for cleanup: {}", (Object)e.getMessage());
                        }
                        return true;
                    }
                    catch (IOException e) {
                        LOGGER.error("IO Exception during atomic save for {}", (Object)id, (Object)e);
                        try {
                            Files.deleteIfExists(tempFile);
                        }
                        catch (IOException cleanupEx) {
                            LOGGER.warn("Failed to cleanup temporary file", (Throwable)cleanupEx);
                        }
                        return false;
                    }
                }
            }, (Executor)class_156.method_18349()).exceptionally(ex -> {
                LOGGER.error("Exception during async save for {}", (Object)id, ex);
                return false;
            });
            this.pendingSavesNbt.put(id, (CompletableFuture<Boolean>)future);
            ((CompletableFuture)future).thenAccept(success -> {
                this.pendingSavesNbt.remove(id);
                if (!success.booleanValue()) {
                    LOGGER.warn("Save failed for {}, data may be incomplete", (Object)id);
                } else {
                    LOGGER.debug("Successfully saved {} ({} entries)", (Object)id, (Object)entriesCount);
                }
            });
            return true;
        }
        LOGGER.debug("Saving {}", (Object)memoryBank.getId());
        memoryBank.getMetadata().updateModified();
        if (!this.saveMetadata(memoryBank.getId(), memoryBank.getMetadata())) {
            return false;
        }
        return FileUtil.saveToNbt(memoryBank.getMemories(), MemoryBankImpl.DATA_CODEC, Constants.STORAGE_DIR.resolve(memoryBank.getId() + this.extension()), registries);
    }

    public void waitForPendingSaves() {
        if (this.pendingSavesNbt.isEmpty()) {
            LOGGER.debug("No pending saves to wait for");
            return;
        }
        LOGGER.debug("Waiting for {} pending save(s) to complete...", (Object)this.pendingSavesNbt.size());
        CompletableFuture<Void> allSaves = CompletableFuture.allOf(this.pendingSavesNbt.values().toArray(new CompletableFuture[0]));
        try {
            allSaves.get(300L, TimeUnit.SECONDS);
            LOGGER.debug("All pending saves completed");
        }
        catch (Exception ex) {
            LOGGER.error("Error or timeout waiting for saves to complete", (Throwable)ex);
        }
    }

    @Override
    public String extension() {
        return ".nbt";
    }
}

