/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.storage.backend;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.chesttracker.impl.storage.backend.FileBasedBackend;
import red.jackf.chesttracker.impl.util.Constants;
import red.jackf.chesttracker.impl.util.FileUtil;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class JsonBackend
extends FileBasedBackend {
    private static final Logger LOGGER = LogManager.getLogger((String)(ChestTracker.class.getCanonicalName() + "/JSON"));
    private final Map<String, CompletableFuture<Boolean>> pendingSavesJson = new ConcurrentHashMap<String, CompletableFuture<Boolean>>();
    private final Map<String, Object> saveLocks = new ConcurrentHashMap<String, Object>();

    @Override
    public String extension() {
        return ".json";
    }

    @Override
    @Nullable
    public MemoryBankImpl load(String id, @Nullable class_7225.class_7874 registries) {
        JsonOps ops = registries == null ? JsonOps.INSTANCE : registries.method_57093((DynamicOps)JsonOps.INSTANCE);
        Optional<Metadata> metadata = this.loadMetadata(id);
        if (metadata.isEmpty()) {
            return null;
        }
        Path dataPath = Constants.STORAGE_DIR.resolve(id + this.extension());
        Pair<Map, Long> result = Misc.time(() -> JsonBackend.lambda$load$0(dataPath, (DynamicOps)ops));
        HashMap<class_2960, MemoryKeyImpl> data = result.getFirst() == null ? new HashMap() : (Map)result.getFirst();
        LOGGER.debug("Loaded {} in {}ns", (Object)dataPath, result.getSecond());
        return new MemoryBankImpl(metadata.get(), data);
    }

    @Override
    public boolean save(MemoryBankImpl memoryBank, @Nullable class_7225.class_7874 registries) {
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.AsyncSaving) {
            String id = memoryBank.getId();
            int entriesCount = memoryBank.getMemories().values().stream().mapToInt(key -> key.getMemories().size()).sum();
            JsonOps ops = registries == null ? JsonOps.INSTANCE : registries.method_57093((DynamicOps)JsonOps.INSTANCE);
            Metadata metadataSnapshot = memoryBank.getMetadata().deepCopy();
            HashMap<class_2960, MemoryKeyImpl> memoriesSnapshot = new HashMap<class_2960, MemoryKeyImpl>(memoryBank.getMemories());
            metadataSnapshot.updateModified();
            LOGGER.debug("Created snapshot for {} ({} entries)", (Object)id, (Object)entriesCount);
            CompletableFuture<Boolean> previous = this.pendingSavesJson.get(id);
            if (previous != null && !previous.isDone()) {
                LOGGER.debug("Previous save for {} still in progress, cancelling...", (Object)id);
                previous.cancel(true);
                try {
                    previous.get(5L, TimeUnit.SECONDS);
                }
                catch (CancellationException e) {
                    LOGGER.debug("Previous save for {} was successfully cancelled", (Object)id);
                }
                catch (TimeoutException e) {
                    LOGGER.warn("Previous save cancellation timed out for {}", (Object)id);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while waiting for previous save cancellation", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOGGER.warn("Previous save failed with exception", (Throwable)e);
                }
            }
            CompletionStage future = CompletableFuture.supplyAsync(() -> this.lambda$save$6(id, metadataSnapshot, (DynamicOps)ops, memoriesSnapshot), (Executor)class_156.method_18349()).exceptionally(ex -> {
                LOGGER.error("Exception during async save for {}", (Object)id, ex);
                return false;
            });
            this.pendingSavesJson.put(id, (CompletableFuture<Boolean>)future);
            ((CompletableFuture)future).thenAccept(success -> {
                this.pendingSavesJson.remove(id);
                if (!success.booleanValue()) {
                    LOGGER.warn("JSON save failed for {}, data may be incomplete", (Object)id);
                } else {
                    LOGGER.debug("JSON successfully saved {} ({} entries)", (Object)id, (Object)entriesCount);
                }
            });
            return true;
        }
        LOGGER.debug("Saving {}", (Object)memoryBank.getId());
        JsonOps ops = registries == null ? JsonOps.INSTANCE : registries.method_57093((DynamicOps)JsonOps.INSTANCE);
        memoryBank.getMetadata().updateModified();
        boolean metaSaveSuccess = this.saveMetadata(memoryBank.getId(), memoryBank.getMetadata());
        if (!metaSaveSuccess) {
            return false;
        }
        Path path = Constants.STORAGE_DIR.resolve(memoryBank.getId() + this.extension());
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Optional memoryJson = MemoryBankImpl.DATA_CODEC.encodeStart((DynamicOps)ops, memoryBank.getMemories()).resultOrPartial(class_156.method_29188((String)"Error encoding memories", arg_0 -> ((Logger)LOGGER).error(arg_0)));
            if (memoryJson.isPresent()) {
                FileUtils.write((File)path.toFile(), (CharSequence)FileUtil.gson().toJson((JsonElement)memoryJson.get()), (Charset)StandardCharsets.UTF_8);
                return true;
            }
            LOGGER.error("Unknown error encoding memories for {}", (Object)memoryBank.getId());
        }
        catch (IOException ex2) {
            LOGGER.error("Error saving memories for {}", (Object)memoryBank.getId(), (Object)ex2);
        }
        return false;
    }

    public void waitForPendingSaves() {
        if (this.pendingSavesJson.isEmpty()) {
            LOGGER.debug("No pending JSON saves to wait for");
            return;
        }
        LOGGER.debug("Waiting for {} pending JSON save(s) to complete...", (Object)this.pendingSavesJson.size());
        CompletableFuture<Void> allSaves = CompletableFuture.allOf(this.pendingSavesJson.values().toArray(new CompletableFuture[0]));
        try {
            allSaves.get(300L, TimeUnit.SECONDS);
            LOGGER.debug("All pending JSON saves completed");
        }
        catch (Exception ex) {
            LOGGER.error("Error or timeout waiting for JSON saves to complete", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ Boolean lambda$save$6(String id, Metadata metadataSnapshot, DynamicOps ops, HashMap memoriesSnapshot) {
        Object lock;
        Object object = lock = this.saveLocks.computeIfAbsent(id, k -> new Object());
        synchronized (object) {
            if (Thread.currentThread().isInterrupted()) {
                LOGGER.debug("Save for {} was cancelled before start", (Object)id);
                return false;
            }
            LOGGER.debug("Starting async save for {}", (Object)id);
            Path finalFile = Constants.STORAGE_DIR.resolve(id + this.extension());
            long timestamp = System.currentTimeMillis();
            Path tempFile = Constants.STORAGE_DIR.resolve(id + this.extension() + ".tmp." + timestamp);
            Path oldFile = Constants.STORAGE_DIR.resolve(id + this.extension() + ".old");
            try {
                if (Thread.currentThread().isInterrupted()) {
                    LOGGER.debug("Save for {} was cancelled", (Object)id);
                    return false;
                }
                if (!this.saveMetadata(id, metadataSnapshot)) {
                    LOGGER.error("Failed to save metadata for {}", (Object)id);
                    return false;
                }
                if (Thread.currentThread().isInterrupted()) {
                    LOGGER.debug("Save for {} was cancelled during metadata save", (Object)id);
                    return false;
                }
                LOGGER.debug("Encoding JSON data for {}", (Object)id);
                Optional memoryJson = MemoryBankImpl.DATA_CODEC.encodeStart(ops, (Object)memoriesSnapshot).resultOrPartial(class_156.method_29188((String)"Error encoding memories", arg_0 -> ((Logger)LOGGER).error(arg_0)));
                if (memoryJson.isEmpty()) {
                    LOGGER.error("Failed to encode JSON data for {}", (Object)id);
                    return false;
                }
                if (Thread.currentThread().isInterrupted()) {
                    LOGGER.debug("Save for {} was cancelled after encoding", (Object)id);
                    return false;
                }
                LOGGER.debug("Saving {} to temporary file: {}", (Object)id, (Object)tempFile.getFileName());
                Files.createDirectories(tempFile.getParent(), new FileAttribute[0]);
                FileUtils.write((File)tempFile.toFile(), (CharSequence)FileUtil.gson().toJson((JsonElement)memoryJson.get()), (Charset)StandardCharsets.UTF_8);
                if (Thread.currentThread().isInterrupted()) {
                    LOGGER.debug("Save for {} was cancelled after JSON save", (Object)id);
                    Files.deleteIfExists(tempFile);
                    return false;
                }
                if (Files.exists(oldFile, new LinkOption[0])) {
                    LOGGER.debug("Removing previous .old file: {}", (Object)oldFile.getFileName());
                    try {
                        Files.delete(oldFile);
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to delete old backup file: {}", (Object)oldFile.getFileName(), (Object)e);
                    }
                }
                if (Files.exists(finalFile, new LinkOption[0])) {
                    LOGGER.debug("Renaming current file to .old");
                    try {
                        Files.move(finalFile, oldFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to rename current file to .old for {}", (Object)id, (Object)e);
                        Files.deleteIfExists(tempFile);
                        return false;
                    }
                }
                LOGGER.debug("Renaming temporary file to final");
                try {
                    Files.move(tempFile, finalFile, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    LOGGER.warn("Atomic move not supported, using regular move");
                    Files.move(tempFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to rename temporary file to final for {}", (Object)id, (Object)e);
                    if (Files.exists(oldFile, new LinkOption[0])) {
                        try {
                            Files.move(oldFile, finalFile, StandardCopyOption.REPLACE_EXISTING);
                            LOGGER.info("Restored from .old backup");
                        }
                        catch (IOException restoreEx) {
                            LOGGER.error("Failed to restore from backup!", (Throwable)restoreEx);
                        }
                    }
                    Files.deleteIfExists(tempFile);
                    return false;
                }
                LOGGER.debug("Successfully completed atomic save for {}", (Object)id);
                try {
                    Files.list(Constants.STORAGE_DIR).filter(p -> p.getFileName().toString().startsWith(id + this.extension() + ".tmp.")).filter(p -> !p.equals(tempFile)).forEach(p -> {
                        try {
                            Files.deleteIfExists(p);
                            LOGGER.debug("Cleaned up old temporary file: {}", (Object)p.getFileName());
                        }
                        catch (IOException e) {
                            LOGGER.debug("Could not clean up old temp file: {}", (Object)e.getMessage());
                        }
                    });
                }
                catch (IOException e) {
                    LOGGER.debug("Could not list directory for cleanup: {}", (Object)e.getMessage());
                }
                return true;
            }
            catch (IOException e) {
                LOGGER.error("IO Exception during atomic save for {}", (Object)id, (Object)e);
                try {
                    Files.deleteIfExists(tempFile);
                }
                catch (IOException cleanupEx) {
                    LOGGER.warn("Failed to cleanup temporary file", (Throwable)cleanupEx);
                }
                return false;
            }
        }
    }

    private static /* synthetic */ Map lambda$load$0(Path dataPath, DynamicOps ops) {
        if (Files.isRegularFile(dataPath, new LinkOption[0])) {
            try {
                String str = FileUtils.readFileToString((File)dataPath.toFile(), (Charset)StandardCharsets.UTF_8);
                JsonElement json = (JsonElement)FileUtil.gson().fromJson(str, JsonElement.class);
                DataResult decoded = MemoryBankImpl.DATA_CODEC.decode(ops, (Object)json);
                if (decoded.isError()) {
                    throw new IOException("Invalid Memories JSON: %s".formatted(((DataResult.Error)decoded.error().get()).message()));
                }
                return (Map)((Pair)decoded.result().get()).getFirst();
            }
            catch (JsonParseException | IOException ex) {
                LOGGER.error("Error loading %s".formatted(dataPath), ex);
                FileUtil.tryMove(dataPath, dataPath.resolveSibling(String.valueOf(dataPath.getFileName()) + ".corrupt"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return null;
    }
}

