/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.rendering;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryKey;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.rendering.NameRenderMode;
import red.jackf.whereisit.client.api.RenderUtils;
import red.jackf.whereisit.client.render.WhereIsItPipelines;
import red.jackf.whereisit.config.WhereIsItConfig;

@Environment(value=EnvType.CLIENT)
public class NameRenderer {
    private static final class_310 MC = class_310.method_1551();
    private static final List<ScheduledLabel> scheduledLabels = new ArrayList<ScheduledLabel>();

    public static void scheduleLabels() {
        scheduledLabels.clear();
        if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).debug.disableContainerNames) {
            return;
        }
        MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> {
            if (bank.getMetadata().getCompatibilitySettings().nameRenderMode == NameRenderMode.DISABLED) {
                return;
            }
            bank.getKey(ProviderUtils.getPlayersCurrentKey()).ifPresent(key -> {
                class_239 hitResult = NameRenderer.MC.field_1765;
                NameRenderer.collectLabels(key, bank, hitResult);
            });
        });
    }

    private static void collectLabels(MemoryKey key, MemoryBankImpl bank, @Nullable class_239 hitResult) {
        class_2561 name;
        class_3965 blockHit;
        @Nullable Memory focused = null;
        if (hitResult instanceof class_3965 && (blockHit = (class_3965)hitResult).method_17783() != class_239.class_240.field_1333) {
            focused = key.get(blockHit.method_17777()).filter(Memory::hasCustomName).orElse(null);
        }
        if (bank.getMetadata().getCompatibilitySettings().nameRenderMode == NameRenderMode.FULL) {
            Map<class_2338, Memory> named = key.getNamedMemories();
            int maxRangeSq = ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).rendering.nameRange * ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).rendering.nameRange;
            Set alreadyRendering = RenderUtils.getCurrentlyRenderedWithNames();
            for (Map.Entry<class_2338, Memory> entry : named.entrySet()) {
                class_2561 name2;
                if (entry.getValue() == focused || alreadyRendering.contains(entry.getKey()) || !(entry.getKey().method_19770((class_2374)NameRenderer.MC.field_1724.method_73189()) < (double)maxRangeSq) || (name2 = entry.getValue().renderName()) == null) continue;
                class_243 pos = entry.getValue().getCenterPosition().method_1031(0.0, 1.0, 0.0);
                scheduledLabels.add(new ScheduledLabel(pos, name2, false));
            }
        }
        if (focused != null && (name = focused.renderName()) != null) {
            class_243 pos = focused.getCenterPosition().method_1031(0.0, 1.0, 0.0);
            scheduledLabels.add(new ScheduledLabel(pos, name, true));
        }
    }

    public static boolean hasScheduledLabels() {
        return !scheduledLabels.isEmpty();
    }

    public static void clearScheduledLabels() {
        scheduledLabels.clear();
    }

    public static void renderLabels(class_4587 ignoredPoseStack, class_4184 camera, class_4597 consumers) {
        if (scheduledLabels.isEmpty()) {
            return;
        }
        class_243 camPos = camera.method_71156();
        class_4587 pose = new class_4587();
        pose.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
        pose.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
        scheduledLabels.stream().sorted(Comparator.comparingDouble(label -> -camPos.method_1025(label.position))).forEach(label -> NameRenderer.renderLabel(label, pose, camera, camPos, consumers));
        scheduledLabels.clear();
    }

    private static void renderLabel(ScheduledLabel label, class_4587 pose, class_4184 camera, class_243 camPos, class_4597 consumers) {
        pose.method_22903();
        double xOffset = label.position.field_1352 - camPos.field_1352;
        double yOffset = label.position.field_1351 - camPos.field_1351;
        double zOffset = label.position.field_1350 - camPos.field_1350;
        pose.method_22904(xOffset, yOffset, zOffset);
        pose.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-camera.method_19330()));
        pose.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
        float scale = 0.025f * ((WhereIsItConfig)WhereIsItConfig.INSTANCE.instance()).getClient().containerNameLabelScale;
        pose.method_22905(-scale, -scale, scale);
        Matrix4f matrix = pose.method_23760().method_23761();
        class_327 font = NameRenderer.MC.field_1772;
        int width = font.method_27525((class_5348)label.text);
        float x = (float)(-width) / 2.0f;
        class_4588 bgBuffer = consumers.method_73477(WhereIsItPipelines.TEXT_BACKGROUND_NO_DEPTH);
        int bgColour = (int)(NameRenderer.MC.field_1690.method_19343(0.25f) * 255.0f) << 24;
        bgBuffer.method_22918((Matrix4fc)matrix, x - 1.0f, -1.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918((Matrix4fc)matrix, x - 1.0f, 10.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918((Matrix4fc)matrix, x + (float)width, 10.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        bgBuffer.method_22918((Matrix4fc)matrix, x + (float)width, -1.0f, 0.0f).method_39415(bgColour).method_60803(0xF000F0);
        font.method_27522(label.text, x, 0.0f, -1, false, matrix, consumers, class_327.class_6415.field_33994, 0, 0xF000F0);
        pose.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private record ScheduledLabel(class_243 position, class_2561 text, boolean focused) {
    }
}

