/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory.metadata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.impl.memory.metadata.CompatibilitySettings;
import red.jackf.chesttracker.impl.memory.metadata.FilteringSettings;
import red.jackf.chesttracker.impl.memory.metadata.IntegritySettings;
import red.jackf.chesttracker.impl.memory.metadata.SearchSettings;
import red.jackf.chesttracker.impl.memory.metadata.VisualSettings;

@Environment(value=EnvType.CLIENT)
public class Metadata {
    public static final Codec<Metadata> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name").forGetter(meta -> Optional.ofNullable(meta.name)), (App)class_5699.field_39042.optionalFieldOf("lastModified").forGetter(meta -> Optional.of(meta.lastModified)), (App)Codec.LONG.fieldOf("loadedTime").forGetter(meta -> meta.loadedTime), (App)CompatibilitySettings.CODEC.optionalFieldOf("compatibility").forGetter(meta -> Optional.of(meta.compatibilitySettings)), (App)FilteringSettings.CODEC.optionalFieldOf("filtering").forGetter(meta -> Optional.of(meta.filteringSettings)), (App)IntegritySettings.CODEC.optionalFieldOf("integrity").forGetter(meta -> Optional.of(meta.integritySettings)), (App)SearchSettings.CODEC.optionalFieldOf("search").forGetter(meta -> Optional.of(meta.searchSettings)), (App)VisualSettings.CODEC.optionalFieldOf("visual").forGetter(meta -> Optional.of(meta.visualSettings))).apply((Applicative)instance, (name, lastModified, loadedTime, compatibility, filtering, integrity, search, visual) -> new Metadata(name.orElse(null), lastModified.orElse(Instant.now()), (long)loadedTime, compatibility.orElseGet(CompatibilitySettings::new), filtering.orElseGet(FilteringSettings::new), integrity.orElseGet(IntegritySettings::new), search.orElseGet(SearchSettings::new), visual.orElseGet(VisualSettings::new))));
    @Nullable
    private String name;
    private Instant lastModified;
    private long loadedTime;
    private final CompatibilitySettings compatibilitySettings;
    private final FilteringSettings filteringSettings;
    private final IntegritySettings integritySettings;
    private final SearchSettings searchSettings;
    private final VisualSettings visualSettings;

    public Metadata(@Nullable String name, Instant lastModified, long loadedTime, CompatibilitySettings compatibilitySettings, FilteringSettings filteringSettings, IntegritySettings integritySettings, SearchSettings searchSettings, VisualSettings visualSettings) {
        this.name = name;
        this.lastModified = lastModified;
        this.loadedTime = loadedTime;
        this.compatibilitySettings = compatibilitySettings;
        this.filteringSettings = filteringSettings;
        this.integritySettings = integritySettings;
        this.searchSettings = searchSettings;
        this.visualSettings = visualSettings;
    }

    public static Metadata blank() {
        return new Metadata(null, Instant.now(), 0L, new CompatibilitySettings(), new FilteringSettings(), new IntegritySettings(), new SearchSettings(), new VisualSettings());
    }

    public static Metadata blankWithName(String name) {
        Metadata blank = Metadata.blank();
        blank.setName(name);
        return blank;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void updateModified() {
        this.lastModified = Instant.now();
    }

    public long getLoadedTime() {
        return this.loadedTime;
    }

    public CompatibilitySettings getCompatibilitySettings() {
        return this.compatibilitySettings;
    }

    public FilteringSettings getFilteringSettings() {
        return this.filteringSettings;
    }

    public IntegritySettings getIntegritySettings() {
        return this.integritySettings;
    }

    public SearchSettings getSearchSettings() {
        return this.searchSettings;
    }

    public VisualSettings getVisualSettings() {
        return this.visualSettings;
    }

    public Metadata deepCopy() {
        return new Metadata(this.name, this.lastModified, this.loadedTime, this.compatibilitySettings.copy(), this.filteringSettings.copy(), this.integritySettings.copy(), this.searchSettings.copy(), this.visualSettings.copy());
    }

    public void incrementLoadedTime() {
        ++this.loadedTime;
    }
}

