/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;
import red.jackf.chesttracker.api.memory.CommonKeys;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.events.AfterPlayerDestroyBlock;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.memory.metadata.IntegritySettings;
import red.jackf.chesttracker.mixins.BlockEntityTypeAccessor;
import red.jackf.jackfredlib.api.base.Memoizer;
import red.jackf.jackfredlib.client.api.toasts.CustomToast;
import red.jackf.jackfredlib.client.api.toasts.ToastBuilder;
import red.jackf.jackfredlib.client.api.toasts.ToastFormat;
import red.jackf.jackfredlib.client.api.toasts.ToastIcon;
import red.jackf.jackfredlib.client.api.toasts.Toasts;

@Environment(value=EnvType.CLIENT)
public class MemoryIntegrity {
    private static final Logger LOGGER = ChestTracker.getLogger("Integrity");
    private static final int TICKS_BETWEEN_ENTRY_REFILL = 600;
    private static final double PERIODIC_CHECK_RANGE_SQUARED = 1024.0;
    private static final List<Map.Entry<class_2338, Memory>> currentEntryList = new ArrayList<Map.Entry<class_2338, Memory>>();
    private static long lastEntryCheckCompleteTick = -1L;
    private static int currentEntryKeyIndex = 0;
    private static class_2960 currentMemoryKeyId = CommonKeys.OVERWORLD;
    private static int lastEntryListIndex = 0;
    private static final Supplier<CustomToast> toast = Memoizer.of(() -> ToastBuilder.builder((ToastFormat)ToastFormat.WHITE, (class_2561)class_2561.method_43471((String)"chesttracker.gui.editMemoryBank.integrity")).withIcon(ToastIcon.modIcon((String)"chesttracker")).addMessage((class_2561)class_2561.method_43470((String)"Initial")).expiresWhenProgressComplete(2500L).progressPuller(toast1 -> {
        if (toast1.getProgress() >= 1.0f) {
            return Optional.empty();
        }
        if (currentEntryList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(class_3532.method_15363((float)((float)lastEntryListIndex / (float)currentEntryList.size()), (float)0.0f, (float)1.0f)));
    }).build());

    private MemoryIntegrity() {
    }

    public static void setup() {
        AfterPlayerDestroyBlock.EVENT.register(cbs -> MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> {
            if (bank.getMetadata().getIntegritySettings().removeOnPlayerBlockBreak) {
                ProviderUtils.getPlayersCurrentKey().ifPresent(currentKey -> {
                    bank.removeMemory((class_2960)currentKey, cbs.pos());
                    LOGGER.debug("Player Destroy Block: Removing {}@{}", (Object)cbs.pos().method_23854(), currentKey);
                });
            }
        }));
        ClientTickEvents.END_WORLD_TICK.register(level -> {
            Long expirySeconds;
            boolean hasOverride;
            MemoryBankImpl memoryBank = MemoryBankAccessImpl.INSTANCE.getLoadedInternal().orElse(null);
            if (memoryBank == null) {
                lastEntryCheckCompleteTick = -1L;
                currentEntryList.clear();
                return;
            }
            IntegritySettings integrity = memoryBank.getMetadata().getIntegritySettings();
            if (currentEntryList.isEmpty() && level.method_75260() >= lastEntryCheckCompleteTick + 600L) {
                Optional<MemoryKeyImpl> currentKey;
                ArrayList<class_2960> keys = new ArrayList<class_2960>(memoryBank.getMemoryKeys());
                if (keys.isEmpty()) {
                    return;
                }
                if (currentEntryKeyIndex >= keys.size()) {
                    currentEntryKeyIndex = 0;
                }
                if ((currentKey = memoryBank.getKeyInternal(currentMemoryKeyId = keys.get(currentEntryKeyIndex++))).isPresent() && !currentKey.get().isEmpty()) {
                    LOGGER.debug("Refreshing entry list <{}> @ {}", (Object)currentMemoryKeyId, (Object)level.method_75260());
                    currentEntryList.addAll(currentKey.get().getMemories().entrySet());
                    if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).debug.showDevHud) {
                        toast.get().setTitle((class_2561)class_2561.method_43470((String)("Integrity: " + String.valueOf(currentMemoryKeyId))));
                        toast.get().setProgress(0.0f);
                        Toasts.INSTANCE.send(toast.get());
                    }
                    lastEntryListIndex = 0;
                }
            }
            if (currentEntryList.isEmpty()) {
                return;
            }
            if (lastEntryListIndex >= currentEntryList.size() || !memoryBank.getKeys().contains(currentMemoryKeyId)) {
                LOGGER.debug("Done checking <{}> @ {}", (Object)currentMemoryKeyId, (Object)level.method_75260());
                if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).debug.showDevHud) {
                    toast.get().setProgress(1.0f);
                    toast.get().setMessage(List.of(class_2561.method_43470((String)"Complete")));
                }
                lastEntryCheckCompleteTick = level.method_75260();
                currentEntryList.clear();
                return;
            }
            Map.Entry<class_2338, Memory> currentEntry = currentEntryList.get(lastEntryListIndex++);
            if (((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).debug.showDevHud) {
                toast.get().setMessage(List.of(class_2561.method_43470((String)("Checking " + lastEntryListIndex + "/" + currentEntryList.size()))));
            }
            class_2338 currentPos = currentEntry.getKey();
            Memory currentMemory = currentEntry.getValue();
            Optional override = memoryBank.getKeyInternal(currentMemoryKeyId).flatMap(key -> Optional.ofNullable(key.overrides().get(currentPos)));
            boolean bl = hasOverride = override.isPresent() && ((OverrideInfo)override.get()).shouldKeep();
            if (!(integrity.preserveNamed && currentMemory.hasCustomName() || hasOverride || (expirySeconds = integrity.memoryLifetime.seconds) == null)) {
                long secondsPastExpiry = (switch (integrity.lifetimeCountMode) {
                    default -> throw new MatchException(null, null);
                    case IntegritySettings.LifetimeCountMode.REAL_TIME -> Duration.between(currentMemory.realTimestamp(), Instant.now()).toSeconds();
                    case IntegritySettings.LifetimeCountMode.WORLD_TIME -> (level.method_75260() - currentMemory.inGameTimestamp()) / 20L;
                    case IntegritySettings.LifetimeCountMode.LOADED_TIME -> (memoryBank.getMetadata().getLoadedTime() - currentMemory.loadedTimestamp()) / 20L;
                }) - expirySeconds;
                if (secondsPastExpiry > 0L) {
                    memoryBank.removeMemory(currentMemoryKeyId, currentPos);
                    LOGGER.debug("Expiry: Removing {}@{}, {} seconds out of date", (Object)currentPos, (Object)currentMemoryKeyId, (Object)secondsPastExpiry);
                    return;
                }
            }
            if (integrity.checkPeriodicallyForMissingBlocks) {
                class_2586 be;
                class_746 player = class_310.method_1551().field_1724;
                class_2960 playerCurrentKey = ProviderUtils.getPlayersCurrentKey().orElse(null);
                if (player != null && playerCurrentKey != null && playerCurrentKey.equals((Object)currentMemoryKeyId) && level.method_8477(currentPos) && currentPos.method_10262((class_2382)player.method_24515()) < 1024.0 && currentMemory.container().isPresent() && ((be = level.method_8321(currentPos)) == null || !((BlockEntityTypeAccessor)be.method_11017()).getValidBlocks().contains(currentMemory.container().get()))) {
                    memoryBank.removeMemory(playerCurrentKey, currentPos);
                    LOGGER.debug("Periodic Check: Removing {}@{}", (Object)currentPos, (Object)currentMemoryKeyId);
                }
            }
        });
    }
}

