/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import red.jackf.chesttracker.api.ClientBlockSource;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryBank;
import red.jackf.chesttracker.api.memory.MemoryKey;
import red.jackf.chesttracker.api.memory.counting.CountingPredicate;
import red.jackf.chesttracker.api.memory.counting.StackMergeMode;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.api.providers.ProviderUtils;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.key.ManualMode;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.memory.key.SearchContext;
import red.jackf.chesttracker.impl.memory.metadata.Metadata;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.SearchResult;

@Environment(value=EnvType.CLIENT)
public class MemoryBankImpl
implements MemoryBank {
    public static final Codec<Map<class_2960, MemoryKeyImpl>> DATA_CODEC = JFLCodecs.mutableMap((Codec)Codec.unboundedMap((Codec)class_2960.field_25139, MemoryKeyImpl.Codecs.MAIN));
    private final Map<class_2960, MemoryKeyImpl> memoryKeys;
    private Metadata metadata;
    private String id;

    public MemoryBankImpl(Metadata metadata, Map<class_2960, MemoryKeyImpl> keys) {
        this.metadata = metadata;
        this.memoryKeys = keys;
        this.memoryKeys.values().forEach(key -> key.setMemoryBank(this));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Map<class_2960, MemoryKeyImpl> getMemories() {
        return this.memoryKeys;
    }

    public void removeKey(class_2960 key) {
        this.memoryKeys.remove(key);
    }

    @Override
    public List<class_1799> getCounts(class_2960 key, CountingPredicate filter, StackMergeMode stackMergeMode, boolean unpackNested) {
        if (this.memoryKeys.containsKey(key)) {
            return this.memoryKeys.get(key).getCounts(filter, stackMergeMode, unpackNested);
        }
        return Collections.emptyList();
    }

    public List<SearchResult> doSearch(class_2960 key, SearchRequest request) {
        class_243 startPos;
        if (!this.memoryKeys.containsKey(key)) {
            return Collections.emptyList();
        }
        MemoryKeyImpl memoryKey = this.memoryKeys.get(key);
        class_243 class_2432 = startPos = class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.method_73189() : null;
        if (startPos == null) {
            return Collections.emptyList();
        }
        return memoryKey.doSearch(new SearchContext(request, startPos, this.metadata));
    }

    public Set<class_2960> getKeys() {
        return this.memoryKeys.keySet();
    }

    @Override
    public Set<class_2960> getMemoryKeys() {
        return Set.copyOf(this.memoryKeys.keySet());
    }

    @Override
    public Map<class_2960, MemoryKey> getAllMemories() {
        return Map.copyOf(this.memoryKeys);
    }

    @Override
    public Optional<Memory> getMemory(ClientBlockSource cbs) {
        Optional target = ProviderUtils.getCurrentProvider().flatMap(provider -> provider.getMemoryLocation(cbs));
        if (target.isEmpty()) {
            return Optional.empty();
        }
        return this.getMemory(((MemoryLocation)target.get()).memoryKey(), ((MemoryLocation)target.get()).position());
    }

    @Override
    public Optional<MemoryKey> getKey(class_2960 keyId) {
        return Optional.ofNullable((MemoryKey)this.memoryKeys.get(keyId));
    }

    public Optional<MemoryKeyImpl> getKeyInternal(class_2960 key) {
        return Optional.ofNullable(this.memoryKeys.get(key));
    }

    public MemoryKeyImpl getOrCreateKeyInternal(class_2960 key) {
        return this.memoryKeys.computeIfAbsent(key, ignored -> {
            MemoryKeyImpl newKey = new MemoryKeyImpl();
            newKey.setMemoryBank(this);
            return newKey;
        });
    }

    @Override
    public void addMemory(class_2960 keyId, class_2338 location, Memory memory) {
        MemoryKeyImpl key = this.getOrCreateKeyInternal(keyId);
        key.add(location, memory);
        if (key.isEmpty()) {
            this.memoryKeys.remove(keyId);
        }
    }

    @Override
    public void removeMemory(class_2960 key, class_2338 pos) {
        MemoryKeyImpl memoryKey = this.memoryKeys.get(key);
        if (memoryKey != null) {
            memoryKey.remove(pos);
            if (memoryKey.isEmpty()) {
                this.memoryKeys.remove(key);
            }
        }
    }

    public void setManualModeOverride(class_2960 key, class_2338 pos, ManualMode mode) {
        if (mode == ManualMode.DEFAULT && !this.getKeys().contains(key)) {
            return;
        }
        MemoryKeyImpl keyImpl = this.getOrCreateKeyInternal(key);
        Map<class_2338, OverrideInfo> overrides = keyImpl.overrides();
        if (mode == ManualMode.DEFAULT && !overrides.containsKey(pos)) {
            return;
        }
        OverrideInfo override = overrides.computeIfAbsent(pos, pos1 -> new OverrideInfo());
        override.setManualMode(mode);
        if (!override.shouldKeep()) {
            overrides.remove(pos);
            if (keyImpl.isEmpty()) {
                this.removeKey(key);
            }
        }
    }

    public void setNameOverride(class_2960 key, class_2338 pos, @NotNull String name) {
        boolean shouldRemove = name.isBlank();
        if (shouldRemove && !this.getKeys().contains(key)) {
            return;
        }
        MemoryKeyImpl keyImpl = this.getOrCreateKeyInternal(key);
        Map<class_2338, OverrideInfo> overrides = keyImpl.overrides();
        if (shouldRemove && !overrides.containsKey(pos)) {
            return;
        }
        name = shouldRemove ? null : name.strip();
        OverrideInfo override = overrides.computeIfAbsent(pos, pos1 -> new OverrideInfo());
        override.setCustomName(name);
        if (!shouldRemove) {
            boolean manualMode = this.getMetadata().getFilteringSettings().manualMode;
            if (manualMode) {
                override.setManualMode(ManualMode.REMEMBER);
            } else if (override.getManualMode() == ManualMode.BLOCK) {
                override.setManualMode(ManualMode.DEFAULT);
            }
        }
        if (!override.shouldKeep()) {
            overrides.remove(pos);
            if (keyImpl.isEmpty()) {
                this.removeKey(key);
            }
        }
    }
}

