/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3532;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.storage.backend.Backend;

@Environment(value=EnvType.CLIENT)
public class ChestTrackerConfig {
    private static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("chesttracker.json5");
    public static final ConfigClassHandler<ChestTrackerConfig> INSTANCE = ConfigClassHandler.createBuilder(ChestTrackerConfig.class).id(ChestTracker.id("config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(PATH).setJson5(true).build()).build();
    @SerialEntry
    public Gui gui = new Gui();
    @SerialEntry
    public Rendering rendering = new Rendering();
    @SerialEntry
    public Debug debug = new Debug();
    @SerialEntry
    public Storage storage = new Storage();
    @SerialEntry
    public Compatibility compatibility = new Compatibility();

    public static void init() {
        try {
            INSTANCE.load();
            ((ChestTrackerConfig)INSTANCE.instance()).validate();
        }
        catch (Exception ex) {
            ChestTracker.LOGGER.error("Error loading Chest Tracker config, backing it up and restoring default", (Throwable)ex);
            try {
                Files.move(PATH, PATH.resolveSibling(PATH.getFileName().toString() + ".errored"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ChestTracker.LOGGER.fatal("Error backing up errored config", (Throwable)e);
            }
        }
        INSTANCE.save();
    }

    public void validate() {
        this.gui.gridWidth = class_3532.method_15340((int)this.gui.gridWidth, (int)9, (int)18);
        this.gui.gridHeight = class_3532.method_15340((int)this.gui.gridHeight, (int)6, (int)12);
        this.gui.itemListTextScale = class_3532.method_15340((int)this.gui.itemListTextScale, (int)-6, (int)0);
        this.rendering.nameRange = class_3532.method_15340((int)this.rendering.nameRange, (int)4, (int)24);
        if (this.storage.storageBackend == null) {
            this.storage.storageBackend = Backend.Type.NBT;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Gui {
        @SerialEntry(comment="Whether to automatically focus the search bar when the GUI is opened.")
        public boolean autofocusSearchBar = false;
        @SerialEntry(comment="Show Autocomplete for Search Bar.")
        public boolean showAutocomplete = true;
        @SerialEntry(comment="Show Unnamed Items in Autocomplete.")
        public boolean autocompleteShowsRegularNames = true;
        @SerialEntry(comment="Show Resize Widget.")
        public boolean showResizeWidget = true;
        @SerialEntry(comment="Grid Width. Range: [9, 18] slots")
        public int gridWidth = 9;
        @SerialEntry(comment="Grid Height. Range: [6, 12] slots")
        public int gridHeight = 6;
        @SerialEntry(comment="Hide the Memory Bank ID from the edit GUIs, for example in case you want to hide an IP.")
        public boolean hideMemoryIds = true;
        @SerialEntry(comment="How to scale the text in-GUI, relative to Minecraft's GUI scale? Minimum of 1.")
        public int itemListTextScale = 0;
        @SerialEntry(comment="Whether to replace GUI titles with custom names when present.")
        public boolean useCustomNameInGUIs = true;
        @SerialEntry
        public InventoryButton inventoryButton = new InventoryButton();

        @Environment(value=EnvType.CLIENT)
        public static class InventoryButton {
            @SerialEntry(comment="Whether to enable the button that appears in inventory screens.")
            public boolean enabled = true;
            @SerialEntry(comment="If relevant, show additional buttons after hovering over the main button, such as deletion and filtering.")
            public boolean showExtra = true;
            @SerialEntry(comment="Always show the extra buttons, if available.")
            public boolean alwaysShowExtra = false;
            @SerialEntry(comment="Whether to show an export button for custom button positions. Files get placed in <gamedir>/chesttracker/export.")
            public boolean showExport = false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Rendering {
        @SerialEntry(comment="Name Render Range. Range: [4, 24] blocks")
        public int nameRange = 12;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Debug {
        @SerialEntry(comment="DEBUG: Show Developer Hud")
        public boolean showDevHud = false;
        @SerialEntry(comment="DEBUG: Disable all container names")
        public boolean disableContainerNames = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Storage {
        @SerialEntry(comment="Asynchronous file saving (unstable), or synchronous (causes freezes but works stably)")
        public boolean AsyncSaving = false;
        @SerialEntry(comment="Whether the JSON files in the memory directory should be readable, or compacted.")
        public boolean readableJsonMemories = false;
        @SerialEntry(comment="Defines the format that Memory Banks are stored between worlds/sessions. Valid values: NBT, JSON, MEMORY")
        public Backend.Type storageBackend = Backend.Type.NBT;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Compatibility {
        @SerialEntry
        public boolean shulkerBoxTooltipIntegration = true;
        @SerialEntry
        public boolean wthitIntegration = true;
        @SerialEntry
        public Litematica litematica = new Litematica();

        @Environment(value=EnvType.CLIENT)
        public static class Litematica {
            @SerialEntry
            public boolean materialListSearchButtons = true;
            @SerialEntry
            public boolean countEnderChestMaterials = true;
            @SerialEntry
            public boolean countNearbyMaterials = false;

            public boolean anyEnabled() {
                return this.materialListSearchButtons || this.countNearbyMaterials || this.countEnderChestMaterials;
            }
        }
    }
}

