/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.isxander.controlify.platform.network.SidedNetworkApi;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.server.packets.EntityVibrationPacket;
import dev.isxander.controlify.server.packets.OriginVibrationPacket;
import dev.isxander.controlify.server.packets.VibrationPacket;
import dev.isxander.controlify.utils.CUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_12090;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2277;
import net.minecraft.class_2321;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class VibrateCommand {
    private static final SuggestionProvider<class_2168> SOURCES_SUGGESTION = class_2321.method_10022((class_2960)CUtil.rl("vibration_sources"), (context, builder) -> class_2172.method_9270(RumbleSource.values().stream().map(RumbleSource::id).toList(), (SuggestionsBuilder)builder));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"vibratecontroller").requires((Predicate)class_2170.method_71774((class_12090)class_2170.field_31839))).then(class_2170.method_9244((String)"receivers", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"low_freq_vibration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(class_2170.method_9244((String)"high_freq_vibration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9247((String)"static").executes(context -> VibrateCommand.vibrateStatic((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"receivers"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), RumbleSource.MASTER)))).then(class_2170.method_9247((String)"positioned").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"range", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9735((boolean)true)).executes(context -> VibrateCommand.vibrateFromOrigin((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"receivers"), class_2277.method_9736((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"range"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), RumbleSource.MASTER)))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> VibrateCommand.vibrateFromEntity((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"receivers"), class_2186.method_9313((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"range"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), RumbleSource.MASTER))))))))));
    }

    private static int vibrateStatic(class_2168 source, Collection<class_3222> targets, float lowFreqMagnitude, float highFreqMagnitude, int durationTicks, RumbleSource rumbleSource) {
        Object[] frames = new RumbleState[durationTicks];
        Arrays.fill(frames, new RumbleState(lowFreqMagnitude, highFreqMagnitude));
        VibrationPacket packet = new VibrationPacket(rumbleSource, (RumbleState[])frames);
        for (class_3222 player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, VibrationPacket.CHANNEL, packet);
        }
        source.method_9226(() -> targets.size() == 1 ? class_2561.method_43471((String)"controlify.command.vibratecontroller.static.single") : class_2561.method_43469((String)"controlify.command.vibratecontroller.static.multiple", (Object[])new Object[]{targets.size()}), true);
        return targets.size();
    }

    private static int vibrateFromOrigin(class_2168 source, Collection<class_3222> targets, class_243 origin, float effectRange, int duration, float lowFreqMagnitude, float highFreqMagnitude, RumbleSource rumbleSource) {
        RumbleState state = new RumbleState(lowFreqMagnitude, highFreqMagnitude);
        OriginVibrationPacket packet = new OriginVibrationPacket(origin.method_46409(), effectRange, duration, state, rumbleSource);
        for (class_3222 player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, OriginVibrationPacket.CHANNEL, packet);
        }
        source.method_9226(() -> targets.size() == 1 ? class_2561.method_43469((String)"controlify.command.vibratecontroller.pos.single", (Object[])new Object[]{VibrateCommand.formatDouble(origin.field_1352), VibrateCommand.formatDouble(origin.field_1351), VibrateCommand.formatDouble(origin.field_1350)}) : class_2561.method_43469((String)"controlify.command.vibratecontroller.pos.multiple", (Object[])new Object[]{targets.size(), VibrateCommand.formatDouble(origin.field_1352), VibrateCommand.formatDouble(origin.field_1351), VibrateCommand.formatDouble(origin.field_1350)}), true);
        return targets.size();
    }

    private static int vibrateFromEntity(class_2168 source, Collection<class_3222> targets, class_1297 origin, float effectRange, int duration, float lowFreqMagnitude, float highFreqMagnitude, RumbleSource rumbleSource) {
        RumbleState state = new RumbleState(lowFreqMagnitude, highFreqMagnitude);
        EntityVibrationPacket packet = new EntityVibrationPacket(origin.method_5628(), effectRange, duration, state, rumbleSource);
        for (class_3222 player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, EntityVibrationPacket.CHANNEL, packet);
        }
        source.method_9226(() -> targets.size() == 1 ? class_2561.method_43469((String)"controlify.command.vibratecontroller.entity.single", (Object[])new Object[]{origin.method_5476()}) : class_2561.method_43469((String)"controlify.command.vibratecontroller.entity.multiple", (Object[])new Object[]{targets.size(), origin.method_5476()}), true);
        return targets.size();
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

