/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pathways;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class HorizonRenderer {
    private static final float TOP = 16.0f;
    private static final float BOTTOM = -16.0f;
    private GpuBuffer buffer;
    private int currentRenderDistance;
    private int indexCount = -1;

    public HorizonRenderer() {
        this.currentRenderDistance = class_310.method_1551().field_1690.method_38521();
        this.rebuildBuffer();
    }

    private void rebuildBuffer() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        class_287 buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27381, class_290.field_1592);
        this.buildHorizon(this.currentRenderDistance * 16, (class_4588)buffer);
        class_9801 meshData = buffer.method_60800();
        this.buffer = RenderSystem.getDevice().createBuffer(() -> "Horizon", 40, meshData.method_60818());
        this.indexCount = meshData.method_60822().comp_751();
        meshData.close();
        class_289.method_1348().method_60828();
    }

    private void buildHorizon(int radius, class_4588 consumer) {
        if (radius > 256) {
            radius = 256;
        }
        consumer.method_22912(0.0f, -16.0f, 0.0f);
        for (int i = 0; i <= 8; ++i) {
            float angle = (float)((double)(-i) * Math.PI / 4.0);
            float x = (float)((double)radius * Math.cos(angle));
            float z = (float)((double)radius * Math.sin(angle));
            consumer.method_22912(x, 16.0f, z);
        }
    }

    public void renderHorizon(Matrix4fc modelView, Matrix4fc projection, Vector4f fogColor) {
        if (this.currentRenderDistance != class_310.method_1551().field_1690.method_38521()) {
            this.currentRenderDistance = class_310.method_1551().field_1690.method_38521();
            this.rebuildBuffer();
        }
        RenderSystem.class_5590 indices = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27381);
        GpuBuffer indexBuffer = indices.method_68274(this.indexCount);
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106(modelView, (Vector4fc)fogColor, (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky", class_310.method_1551().method_1522().method_71639(), OptionalInt.empty(), class_310.method_1551().method_1522().method_71640(), OptionalDouble.empty());){
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", gpuBufferSlice);
            pass.setVertexBuffer(0, this.buffer);
            pass.setIndexBuffer(indexBuffer, indices.method_31924());
            pass.setPipeline(class_10799.field_56874);
            pass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }

    public void destroy() {
        this.buffer.close();
    }
}

