/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedFunction;

final class FunctionScalarSerializer<T>
extends ScalarSerializer<T> {
    private final CheckedFunction<Object, T, SerializationException> deserializer;
    private final BiFunction<T, Predicate<Class<?>>, Object> serializer;

    FunctionScalarSerializer(Type type2, CheckedFunction<Object, T, SerializationException> deserializer, BiFunction<T, Predicate<Class<?>>, Object> serializer) {
        super(type2);
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    @Override
    public T deserialize(Type type2, Object obj) throws SerializationException {
        try {
            return this.deserializer.apply(obj);
        }
        catch (SerializationException ex) {
            ex.initType(type2);
            throw ex;
        }
    }

    @Override
    public Object serialize(T item, Predicate<Class<?>> typeSupported) {
        return this.serializer.apply(item, typeSupported);
    }
}

