/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties;

import com.moulberry.axiom.AxiomServer;
import com.moulberry.axiom.editor.EditorWarningType;
import com.moulberry.axiom.hooks.ServerLevelExt;
import com.moulberry.axiom.packets.AxiomClientboundEditorWarning;
import com.moulberry.axiom.packets.AxiomClientboundSetWorldProperty;
import com.moulberry.axiom.world_properties.DefaultServerWorldProperties;
import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.server.ServerWorldPropertiesRegistry;
import com.moulberry.axiom.world_properties.server.ServerWorldProperty;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleBuilder;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleEvents;
import net.minecraft.class_12279;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class AxiomGameRules {
    public static class_12279<Boolean> RULE_DOBLOCKDROPS;
    public static class_12279<Boolean> RULE_DOBLOCKGRAVITY;
    public static class_12279<Boolean> RULE_DOTRAMPLEFARMLAND;
    public static class_12279<Boolean> RULE_PLAYERINVULNERABILITY;

    public static void register() {
        RULE_DOBLOCKDROPS = GameRuleBuilder.forBoolean((boolean)true).buildAndRegister(class_2960.method_60655((String)"axiom", (String)"do_block_drops"));
        RULE_DOBLOCKGRAVITY = GameRuleBuilder.forBoolean((boolean)true).buildAndRegister(class_2960.method_60655((String)"axiom", (String)"do_block_gravity"));
        RULE_DOTRAMPLEFARMLAND = GameRuleBuilder.forBoolean((boolean)true).buildAndRegister(class_2960.method_60655((String)"axiom", (String)"do_trample_farmland"));
        RULE_PLAYERINVULNERABILITY = GameRuleBuilder.forBoolean((boolean)false).buildAndRegister(class_2960.method_60655((String)"axiom", (String)"player_invulnerability"));
        GameRuleEvents.changeCallback(RULE_DOBLOCKDROPS).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.BLOCK_DROPS, value);
        });
        GameRuleEvents.changeCallback(RULE_DOBLOCKGRAVITY).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.BLOCK_GRAVITY, value);
        });
        GameRuleEvents.changeCallback(RULE_DOTRAMPLEFARMLAND).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.TRAMPLE_FARMLAND, value);
        });
        GameRuleEvents.changeCallback(RULE_PLAYERINVULNERABILITY).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.PLAYER_INVULNERABILITY, value);
        });
        GameRuleEvents.changeCallback((class_12279)class_1928.field_19390).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.MOB_SPAWNING, value);
        });
        GameRuleEvents.changeCallback((class_12279)class_1928.field_56559).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.FIRE_TICK, value > 0);
        });
        GameRuleEvents.changeCallback((class_12279)class_1928.field_19399).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setInteger(minecraftServer, DefaultServerWorldProperties.RANDOM_TICK_SPEED, value);
        });
        GameRuleEvents.changeCallback((class_12279)class_1928.field_19406).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomGameRules.setBoolean(minecraftServer, DefaultServerWorldProperties.PAUSE_WEATHER, value == false);
        });
        GameRuleEvents.changeCallback((class_12279)class_1928.field_19406).register((value, minecraftServer) -> {
            if (minecraftServer == null) {
                return;
            }
            AxiomClientboundEditorWarning packet = new AxiomClientboundEditorWarning(EditorWarningType.SPECTATORS_GENERATE_CHUNKS, value == false);
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                if (!AxiomServer.canUseAxiom(player)) continue;
                packet.send(player);
            }
        });
    }

    private static void setBoolean(MinecraftServer minecraftServer, class_2960 resourceLocation, boolean value) {
        for (class_3218 level : minecraftServer.method_3738()) {
            ServerWorldPropertiesRegistry propertiesRegistry = ((ServerLevelExt)level).axiom$getWorldProperties();
            ServerWorldProperty<?> property = propertiesRegistry.propertyMap.get(resourceLocation);
            property.setValue(value);
        }
        AxiomClientboundSetWorldProperty packet = new AxiomClientboundSetWorldProperty(resourceLocation, WorldPropertyDataType.BOOLEAN.getTypeId(), WorldPropertyDataType.BOOLEAN.serialize(value));
        for (class_3222 player : minecraftServer.method_3760().method_14571()) {
            if (!AxiomServer.canUseAxiom(player)) continue;
            packet.send(player);
        }
    }

    private static void setInteger(MinecraftServer minecraftServer, class_2960 resourceLocation, int value) {
        for (class_3218 level : minecraftServer.method_3738()) {
            ServerWorldPropertiesRegistry propertiesRegistry = ((ServerLevelExt)level).axiom$getWorldProperties();
            ServerWorldProperty<?> property = propertiesRegistry.propertyMap.get(resourceLocation);
            property.setValue(value);
        }
        AxiomClientboundSetWorldProperty packet = new AxiomClientboundSetWorldProperty(resourceLocation, WorldPropertyDataType.INTEGER.getTypeId(), WorldPropertyDataType.INTEGER.serialize(value));
        for (class_3222 player : minecraftServer.method_3760().method_14571()) {
            if (!AxiomServer.canUseAxiom(player)) continue;
            packet.send(player);
        }
    }
}

