/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_modification;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.RenderHelper;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.joml.Matrix4fc;

public class UndoRedoTracer {
    private final class_243[] points;
    private final int colour;
    private final boolean reverse;
    private int progress;

    public UndoRedoTracer(class_243 target, int colour, boolean reverse) {
        class_746 player = class_310.method_1551().field_1724;
        class_243 look = UndoRedoTracer.getLookVector(player);
        class_243 chest = player.method_73189().method_1031(0.0, 1.0, 0.0);
        class_243 p1 = chest.method_1020(look);
        float distance = (float)target.method_1022(p1);
        class_243 p2 = player.method_73189().method_1031(0.0, 1.0, 0.0).method_1019(look.method_1021((double)(distance / 3.0f)));
        this.points = UndoRedoTracer.bezierQuad(p1, p2, target, 70);
        this.colour = colour;
        this.reverse = reverse;
    }

    public boolean tick() {
        return ++this.progress >= 20;
    }

    public void render(class_4587 matrices, class_4184 camera, float partialTick) {
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 vertices = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        class_243 first = this.points[0];
        matrices.method_22903();
        matrices.method_22904(first.field_1352 - camera.method_71156().field_1352, first.field_1351 - camera.method_71156().field_1351, first.field_1350 - camera.method_71156().field_1350);
        class_4587.class_4665 pose = matrices.method_23760();
        class_243 last = null;
        float lastAlpha = 0.0f;
        int pointIndex = (int)(((float)(this.progress - 5) + partialTick) * 5.0f);
        for (int i = Math.max(pointIndex, 0); i <= pointIndex + 40 && i < this.points.length; ++i) {
            int j = i;
            if (this.reverse) {
                j = this.points.length - 1 - i;
            }
            class_243 point = this.points[j];
            float alpha = Math.min(1.0f, 1.0f - (float)Math.abs(i - pointIndex - 20) / 20.0f);
            if (last == null) {
                last = point;
                lastAlpha = alpha;
                continue;
            }
            class_243 delta = last.method_1020(point).method_1029();
            vertices.method_22918((Matrix4fc)pose.method_23761(), (float)(last.method_10216() - first.field_1352), (float)(last.method_10214() - first.field_1351), (float)(last.method_10215() - first.field_1350)).method_39415((int)(lastAlpha * 255.0f) << 24 | this.colour).method_60831(pose, (float)delta.method_10216(), (float)delta.method_10214(), (float)delta.method_10215()).method_75298(RenderHelper.baseLineWidth);
            vertices.method_22918((Matrix4fc)pose.method_23761(), (float)(point.method_10216() - first.field_1352), (float)(point.method_10214() - first.field_1351), (float)(point.method_10215() - first.field_1350)).method_39415((int)(alpha * 255.0f) << 24 | this.colour).method_60831(pose, (float)delta.method_10216(), (float)delta.method_10214(), (float)delta.method_10215()).method_75298(RenderHelper.baseLineWidth);
            last = point;
            lastAlpha = alpha;
        }
        matrices.method_22909();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
    }

    private static class_243 getLookVector(class_746 player) {
        float f = player.method_36455() * ((float)Math.PI / 180);
        float g2 = -player.method_5791() * ((float)Math.PI / 180);
        float h2 = class_3532.method_15362((double)g2);
        float i = class_3532.method_15374((double)g2);
        float j = class_3532.method_15362((double)f);
        float k = class_3532.method_15374((double)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h2 * j));
    }

    private static class_243[] bezierQuad(class_243 p1, class_243 p2, class_243 p3, int num) {
        class_243[] points = new class_243[num];
        for (int i = 0; i < num; ++i) {
            double f = (double)i / ((double)num - 1.0);
            double c1 = (1.0 - f) * (1.0 - f);
            double c2 = 2.0 * (1.0 - f) * f;
            double c3 = f * f;
            points[i] = new class_243(p1.method_10216() * c1 + p2.method_10216() * c2 + p3.method_10216() * c3, p1.method_10214() * c1 + p2.method_10214() * c2 + p3.method_10214() * c3, p1.method_10215() * c1 + p2.method_10215() * c2 + p3.method_10215() * c3);
        }
        return points;
    }
}

