/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.hooks.GameRendererExt;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_11278;
import net.minecraft.class_11286;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_758;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderHelper {
    public static float baseLineWidth = 2.5f;
    private static final class_11278 orthoProjectionMatrixBuffer = new class_11278("Axiom Cached Ortho", 1000.0f, 3000.0f, true);
    private static final class_11286 perspectiveProjectionMatrixBuffer = new class_11286("Axiom Perspective");
    private static GpuBufferSlice previousFogParameters = null;

    public static void updateBaseLineWidth(class_1041 window) {
        double screenScaleFactor = (double)(window.field_5181 * window.field_5196) / 2073600.0;
        baseLineWidth = Math.max(2.5f, (float)(Math.sqrt(screenScaleFactor) * 2.5));
    }

    public static void tryApplyModelViewMatrix() {
        AxiomRenderer.dirtyDynamicUniforms();
    }

    public static void tryFlush(class_332 guiGraphics) {
    }

    public static void setOrthoProjectionMatrix(float width, float height) {
        RenderSystem.setProjectionMatrix((GpuBufferSlice)orthoProjectionMatrixBuffer.method_71092(width, height), (class_10366)class_10366.field_54954);
    }

    public static void setPerspectiveProjectionMatrix(Matrix4f matrix4f) {
        RenderSystem.setProjectionMatrix((GpuBufferSlice)perspectiveProjectionMatrixBuffer.method_71123(matrix4f), (class_10366)class_10366.field_54953);
    }

    public static void pushDisableFog() {
        if (previousFogParameters != null && Axiom.enableAssertions) {
            throw new IllegalStateException("Fog disable was pushed twice");
        }
        previousFogParameters = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((GpuBufferSlice)((GameRendererExt)class_310.method_1551().field_1773).axiom$getFogRenderer().method_71109(class_758.class_4596.field_60101));
    }

    public static void popDisableFog() {
        if (previousFogParameters == null) {
            if (Axiom.enableAssertions) {
                throw new IllegalStateException("Fog disable was popped without being pushed");
            }
            return;
        }
        RenderSystem.setShaderFog((GpuBufferSlice)previousFogParameters);
        previousFogParameters = null;
    }

    public static void pushModelViewMatrix(Matrix4f matrix4f) {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.set((Matrix4fc)matrix4f);
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void pushModelViewStackWithIdentity() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void popModelViewStack() {
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.popMatrix();
        RenderHelper.tryApplyModelViewMatrix();
    }

    public static void setupFlatLighting() {
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
    }

    public static void setup3DLighting() {
        class_310.method_1551().field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
    }
}

