/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.utils;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.core_rendering.AxiomBlending;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.ProjectionMatrixBackup;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_10868;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_6367;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class FramebufferUtils {
    private static int dynamicReadFbo = -1;
    private static class_276 tempRenderTarget = null;

    public static void bindDepth(class_276 renderTarget) {
        if (dynamicReadFbo == -1) {
            dynamicReadFbo = GlStateManager.glGenFramebuffers();
        }
        int textureId = ((class_10868)renderTarget.method_30278()).method_68427();
        GlStateManager._glBindFramebuffer((int)36008, (int)dynamicReadFbo);
        GlStateManager._glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)0, (int)0);
        GlStateManager._glFramebufferTexture2D((int)36008, (int)36096, (int)3553, (int)textureId, (int)0);
    }

    public static int bindColour(class_276 renderTarget) {
        if (dynamicReadFbo == -1) {
            dynamicReadFbo = GlStateManager.glGenFramebuffers();
        }
        int textureId = ((class_10868)renderTarget.method_30277()).method_68427();
        GlStateManager._glBindFramebuffer((int)36008, (int)dynamicReadFbo);
        GlStateManager._glFramebufferTexture2D((int)36008, (int)36064, (int)3553, (int)textureId, (int)0);
        GlStateManager._glFramebufferTexture2D((int)36008, (int)36096, (int)3553, (int)0, (int)0);
        return dynamicReadFbo;
    }

    public static void unbind() {
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public static int getRawColorTextureId(class_276 renderTarget) {
        return ((class_10868)renderTarget.method_30277()).method_68427();
    }

    public static CompletableFuture<class_1011> downloadAsync(class_276 renderTarget) {
        CompletableFuture<class_1011> future = new CompletableFuture<class_1011>();
        int width = renderTarget.field_1482;
        int height = renderTarget.field_1481;
        GpuTexture gpuTexture = renderTarget.method_30277();
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Download buffer", 9, (long)(width * height * gpuTexture.getFormat().pixelSize()));
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gpuTexture, gpuBuffer, 0L, () -> {
            try (GpuBuffer.MappedView view = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                class_1011 nativeImage = new class_1011(width, height, false);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int abgr = view.data().getInt((x + y * width) * gpuTexture.getFormat().pixelSize());
                        nativeImage.method_4305(x, y, abgr);
                    }
                }
                future.complete(nativeImage);
            }
            gpuBuffer.close();
        }, 0);
        return future;
    }

    public static void copyDepth(class_276 from, class_276 to) {
        to.method_29329(from);
    }

    public static void clear(class_276 renderTarget, int colour) {
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        GpuTexture colourTexture = renderTarget.method_30277();
        GpuTexture depthTexture = renderTarget.method_30278();
        if (colourTexture != null && !colourTexture.isClosed() && depthTexture != null && !depthTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(colourTexture, colour, depthTexture, 1.0);
        } else if (colourTexture != null && !colourTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearColorTexture(colourTexture, colour);
        } else if (depthTexture != null && !depthTexture.isClosed()) {
            RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(depthTexture, 1.0);
        }
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }

    public static class_276 resizeOrCreateFramebuffer(class_276 renderTarget, int width, int height) {
        if (renderTarget == null) {
            renderTarget = new class_6367(null, width, height, true);
        } else if (renderTarget.field_1482 != width || renderTarget.field_1481 != height) {
            renderTarget.method_1234(width, height);
        }
        return renderTarget;
    }

    public static void blitToMainBlend(class_276 renderTarget, int width, int height) {
        FramebufferUtils.blitToMainBlend(renderTarget.method_71639(), width, height);
    }

    public static void blitToMainBlend(class_276 renderTarget, int width, int height, AxiomBlending blending) {
        FramebufferUtils.blitToMainBlend(renderTarget.method_71639(), width, height, blending);
    }

    public static void blitToMainBlend(GpuTextureView textureId, int width, int height) {
        FramebufferUtils.blitToMainBlend(textureId, width, height, AxiomBlending.DEFAULT);
    }

    public static void blitToMainBlend(GpuTextureView textureId, int width, int height, AxiomBlending blending) {
        FramebufferUtils.blitTo(textureId, null, width, height, 0.0f, 0.0f, 1.0f, 1.0f, blending);
    }

    public static void blitTo(GpuTextureView from, class_276 to, int width, int height, float x1, float y1, float x2, float y2, AxiomBlending blending) {
        AxiomRenderPipeline pipeline;
        RenderHelper.pushModelViewMatrix(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        ProjectionMatrixBackup backup = ProjectionMatrixBackup.create();
        RenderHelper.setOrthoProjectionMatrix(width, height);
        AxiomRenderer.setMainTexture(from);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 builder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1585);
        builder.method_22912((float)width * x1, (float)height * y2, 0.0f).method_22913(0.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y2, 0.0f).method_22913(1.0f, 0.0f);
        builder.method_22912((float)width * x2, (float)height * y1, 0.0f).method_22913(1.0f, 1.0f);
        builder.method_22912((float)width * x1, (float)height * y1, 0.0f).method_22913(0.0f, 1.0f);
        if (blending == null) {
            pipeline = AxiomRenderPipelines.BLIT_NO_BLEND;
        } else {
            pipeline = switch (blending) {
                case AxiomBlending.ONE_ONE_MINUS_SRC_ALPHA -> AxiomRenderPipelines.BLIT_ONE_ONE_MINUS_SRC_ALPHA;
                default -> AxiomRenderPipelines.BLIT;
            };
        }
        pipeline.render(to, provider.build());
        backup.restore();
        RenderHelper.popModelViewStack();
    }

    public static void blitToScreenPartial(class_276 renderTarget, int width, int height, float x1, float y1, float x2, float y2) {
        GlStateManager._viewport((int)0, (int)0, (int)width, (int)height);
        int oldReadFbo = GL11.glGetInteger((int)36010);
        int oldDrawFbo = GL11.glGetInteger((int)36006);
        tempRenderTarget = FramebufferUtils.resizeOrCreateFramebuffer(tempRenderTarget, width, height);
        FramebufferUtils.clear(tempRenderTarget, 0);
        FramebufferUtils.blitTo(renderTarget.method_71639(), tempRenderTarget, width, height, x1, y1, x2, y2, null);
        tempRenderTarget.method_1237();
        GlStateManager._glBindFramebuffer((int)36008, (int)oldReadFbo);
        GlStateManager._glBindFramebuffer((int)36009, (int)oldDrawFbo);
    }
}

