/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.shape;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.GenericRadiusAdjustment;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.rasterization.ConeRasterization;
import com.moulberry.axiom.rasterization.CuboidRasterization;
import com.moulberry.axiom.rasterization.CylinderRasterization;
import com.moulberry.axiom.rasterization.DiskRasterization;
import com.moulberry.axiom.rasterization.DodecahedronRasterization;
import com.moulberry.axiom.rasterization.IcosahedronRasterization;
import com.moulberry.axiom.rasterization.OctahedronRasterization;
import com.moulberry.axiom.rasterization.PlaneRasterization;
import com.moulberry.axiom.rasterization.PyramidRasterization;
import com.moulberry.axiom.rasterization.RegularPolygonRasterization;
import com.moulberry.axiom.rasterization.SphereRasterization;
import com.moulberry.axiom.rasterization.SpiralRasterization;
import com.moulberry.axiom.rasterization.SuperellipseRasterization;
import com.moulberry.axiom.rasterization.SupersphereRasterization;
import com.moulberry.axiom.rasterization.TorusRasterization;
import com.moulberry.axiom.rasterization.TubeRasterization;
import com.moulberry.axiom.render.ChunkRenderOverrider;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.world_modification.HistoryEntry;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.EnumSet;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class ShapeTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private Gizmo gizmo = null;
    private boolean cutout = false;
    private boolean recalculate = false;
    private class_2680 lastActiveBlock = null;
    private boolean maskWindowOpen = false;
    private boolean reorientPoint = false;
    private boolean usingRealCoordinates = false;
    private boolean decimalSizes = false;
    private boolean centerEvenDiameters = true;
    private static final int SHAPE_CATEGORY_SOLID = 0;
    private static final int SHAPE_CATEGORY_PLANE = 1;
    private final int[] shapeCategory = new int[]{0};
    private static final int SHAPE_SOLID_SPHERE = 0;
    private static final int SHAPE_SOLID_CUBOID = 1;
    private static final int SHAPE_SOLID_OCTAHEDRON = 2;
    private static final int SHAPE_SOLID_SUPERSPHERE = 3;
    private static final int SHAPE_SOLID_CYLINDER = 4;
    private static final int SHAPE_SOLID_TUBE = 5;
    private static final int SHAPE_SOLID_CONE = 6;
    private static final int SHAPE_SOLID_PYRAMID = 7;
    private static final int SHAPE_SOLID_TORUS = 8;
    private static final int SHAPE_SOLID_DODECAHEDRON = 9;
    private static final int SHAPE_SOLID_ICOSAHEDRON = 10;
    private final int[] shapeSolid = new int[]{0};
    private static final int SHAPE_PLANE_DISK = 0;
    private static final int SHAPE_PLANE_PLANE = 1;
    private static final int SHAPE_PLANE_REGULAR_POLYGON = 2;
    private static final int SHAPE_PLANE_SUPERELLIPSE = 3;
    private static final int SHAPE_PLANE_ARCHIMEDEAN_SPIRAL = 4;
    private final int[] shapePlane = new int[]{0};
    private boolean separateXYZ = false;
    private final float[] sizeXYZ = new float[]{5.0f};
    private final float[] sizeX = new float[]{5.0f};
    private final float[] sizeY = new float[]{5.0f};
    private final float[] sizeZ = new float[]{5.0f};
    private final GenericRadiusAdjustment radiusAdjustment = new GenericRadiusAdjustment(64);
    private final float[] rotationX = new float[]{0.0f};
    private final float[] rotationY = new float[]{0.0f};
    private final float[] rotationZ = new float[]{0.0f};
    private final Quaternionf rotationQuaternion = new Quaternionf();
    private boolean hollow = false;
    private boolean metaball = false;
    private final int[] metaballRange = new int[]{8};
    private boolean cutoff = false;
    private final int[] cutoffAmount = new int[]{50};
    private final int[] polygonSides = new int[]{3};
    private final float[] thickness = new float[]{1.0f};
    private boolean separateHV = false;
    private final float[] ringH = new float[]{2.0f};
    private final float[] ringV = new float[]{2.0f};
    private final float[] exponent = new float[]{2.0f};
    private final float[] loops = new float[]{5.0f};
    private final float[] coneRounding = new float[]{0.0f};
    private boolean offsetWhenPlacing = true;
    private static final int GIZMO_SPACE_GLOBAL = 0;
    private static final int GIZMO_SPACE_LOCAL = 1;
    private final int[] gizmoSpace = new int[]{0};
    private static final int PIVOT_CENTER = 0;
    private static final int PIVOT_BASE = 1;
    private final int[] pivot = new int[]{0};
    private static final int PLACE_ROTATION_KEEP = 0;
    private static final int PLACE_ROTATION_AUTO = 1;
    private static final int PLACE_ROTATION_RESET = 2;
    private final int[] placeRotation = new int[]{0};
    private boolean instantPlace = false;
    private boolean keepExisting = false;
    private boolean extendToGround = false;

    @Override
    public void reset() {
        this.gizmo = null;
        this.chunkedBlockRegion.clear();
        this.recalculate = true;
        if (this.cutout) {
            ChunkRenderOverrider.release("Shape Tool");
            this.cutout = false;
        }
    }

    public void markDirty() {
        this.recalculate = true;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case ENTER: {
                if (!this.chunkedBlockRegion.isEmpty() && this.gizmo != null) {
                    this.pasteShape(false);
                    this.reset();
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids());
                if (result != null) {
                    int placeRotationMode = this.getPlaceRotation();
                    if (placeRotationMode == 2) {
                        this.rotationZ[0] = 0.0f;
                        this.rotationY[0] = 0.0f;
                        this.rotationX[0] = 0.0f;
                        this.rotationQuaternion.identity();
                    } else if (placeRotationMode == 1) {
                        this.setRotationAuto(result.blockPos());
                    }
                    class_2338 blockPos = result.blockPos();
                    if (this.offsetWhenPlacing) {
                        blockPos = blockPos.method_10093(result.direction());
                    }
                    if (this.gizmo != null) {
                        this.gizmo.moveTo(blockPos);
                        this.gizmo.enableAxes = true;
                    } else {
                        this.gizmo = new Gizmo(blockPos);
                    }
                    this.reorientPoint = true;
                    this.recalculate = true;
                    if (this.instantPlace) {
                        this.pasteShape(false);
                        this.reset();
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (this.gizmo == null || !this.gizmo.leftClick() || this.instantPlace) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (this.gizmo == null || !this.gizmo.enableAxes || this.instantPlace) break;
                this.gizmo.enableAxes = false;
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
            case SCROLL: {
                UserAction.ScrollAmount scrollAmount = (UserAction.ScrollAmount)object;
                if (!this.handleScroll(scrollAmount.scrollX(), scrollAmount.scrollY())) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (this.gizmo == null || this.instantPlace) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        if (this.gizmo != null) {
            class_243 look = Tool.getLookDirection();
            this.gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), look);
            return true;
        }
        return false;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        boolean maskWindowOpen;
        RayCaster.RaycastResult result;
        boolean showGizmo;
        Selection.render(camera, time, matrices, projection, 4);
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown(0);
        boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
        boolean renderGizmos = showGizmo = !EditorUI.isActive() || !isCtrlDown;
        if (Tool.isMouseDown(1) && this.gizmo != null && this.gizmo.enableAxes && this.reorientPoint) {
            RayCaster.RaycastResult result2 = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids());
            if (result2 != null) {
                class_2338 blockPos = result2.blockPos();
                if (this.offsetWhenPlacing) {
                    blockPos = blockPos.method_10093(result2.direction());
                }
                if (!this.gizmo.getTargetPosition().equals((Object)blockPos)) {
                    int placeRotationMode = this.getPlaceRotation();
                    if (placeRotationMode == 2) {
                        this.rotationZ[0] = 0.0f;
                        this.rotationY[0] = 0.0f;
                        this.rotationX[0] = 0.0f;
                        this.rotationQuaternion.identity();
                    } else if (placeRotationMode == 1) {
                        this.setRotationAuto(result2.blockPos());
                    }
                    this.gizmo.moveTo(blockPos);
                    this.gizmo.enableAxes = true;
                    this.recalculate = true;
                }
            }
        } else {
            this.reorientPoint = false;
        }
        boolean hasGrabbedGizmo = false;
        if (this.instantPlace) {
            result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids());
            if (result != null) {
                class_2338 blockPos = result.blockPos();
                if (this.offsetWhenPlacing) {
                    blockPos = blockPos.method_10093(result.direction());
                }
                if (this.gizmo != null) {
                    if (!this.gizmo.getTargetPosition().equals((Object)blockPos)) {
                        this.gizmo.moveToInstantly(blockPos);
                        this.recalculate |= this.usingRealCoordinates;
                    }
                } else {
                    this.gizmo = new Gizmo(blockPos);
                    this.recalculate = true;
                }
                this.gizmo.localRotation = null;
            } else {
                this.reset();
            }
        }
        if (this.gizmo != null && !this.instantPlace) {
            Gizmo.GizmoRotation rotation;
            this.gizmo.enableRotation = true;
            this.gizmo.rotationSnapRadians = (float)Math.PI / 180;
            this.gizmo.localRotation = this.getGizmoSpace() == 1 ? new Quaternionf((Quaternionfc)this.rotationQuaternion).invert() : null;
            class_2338 before = this.gizmo.getTargetPosition();
            this.gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
            if (this.getGizmoSpace() == 0) {
                this.gizmo.setAxisDirections(camera.method_71156().field_1352 > (double)this.gizmo.getTargetPosition().method_10263(), camera.method_71156().field_1351 > (double)this.gizmo.getTargetPosition().method_10264(), camera.method_71156().field_1350 > (double)this.gizmo.getTargetPosition().method_10260());
            } else {
                this.gizmo.setAxisDirections(true, true, true);
            }
            if (this.gizmo.isGrabbed()) {
                renderGizmos = true;
                hasGrabbedGizmo = true;
            }
            if ((rotation = this.gizmo.popRotation()) != null) {
                this.performRotation(rotation.axis(), rotation.radians());
                this.recalculate = true;
            }
            if (this.usingRealCoordinates && !this.gizmo.getTargetPosition().equals((Object)before)) {
                this.recalculate = true;
            }
        }
        if (!hasGrabbedGizmo && this.gizmo == null && (result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids())) != null) {
            class_2338 blockPos = result.blockPos();
            if (this.offsetWhenPlacing) {
                blockPos = blockPos.method_10093(result.direction());
            }
            Tool.renderRaycastOverlay(blockPos, matrices, camera);
        }
        if (Tool.getActiveBlock() != this.lastActiveBlock) {
            this.lastActiveBlock = Tool.getActiveBlock();
            this.recalculate = true;
        }
        if (this.maskWindowOpen != (maskWindowOpen = EditorWindowType.TOOL_MASKS.isOpen())) {
            this.maskWindowOpen = maskWindowOpen;
            this.recalculate = true;
        }
        if (this.recalculate) {
            this.recalculate();
        }
        if (this.gizmo == null) {
            return;
        }
        float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
        if (this.usingRealCoordinates) {
            this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        } else if (this.gizmoSpace[0] == 1) {
            Quaternionf rotation;
            Gizmo.GizmoRotation gizmoRotation = this.gizmo.peekGizmoRotation();
            if (gizmoRotation != null) {
                rotation = new Quaternionf((Quaternionfc)this.rotationQuaternion).invert();
                switch (gizmoRotation.axis()) {
                    case field_11048: {
                        rotation.rotateX(gizmoRotation.radians());
                        break;
                    }
                    case field_11052: {
                        rotation.rotateY(gizmoRotation.radians());
                        break;
                    }
                    case field_11051: {
                        rotation.rotateZ(gizmoRotation.radians());
                    }
                }
                rotation.mul((Quaternionfc)this.rotationQuaternion);
            } else {
                rotation = null;
            }
            Vector3f offset = new Vector3f(-0.5f, -0.5f, -0.5f);
            if (rotation != null) {
                rotation.transform(offset);
            }
            this.chunkedBlockRegion.render(camera, this.gizmo.getInterpPosition().method_1031((double)offset.x, (double)offset.y, (double)offset.z), rotation, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        } else {
            Quaternionf rotation = this.gizmo.peekRotation();
            Vector3f offset = new Vector3f(-0.5f, -0.5f, -0.5f);
            if (rotation != null) {
                rotation.transform(offset);
            }
            this.chunkedBlockRegion.render(camera, this.gizmo.getInterpPosition().method_1031((double)offset.x, (double)offset.y, (double)offset.z), rotation, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            this.renderShapeBounds(matrices, camera);
        }
        if (renderGizmos && this.gizmo != null && !this.instantPlace) {
            this.gizmo.render(matrices, camera, isCtrlDown);
        }
    }

    private void renderShapeBounds(class_4587 matrices, class_4184 camera) {
        switch (this.shapeCategory[0]) {
            case 0: {
                Quaternionf rotation;
                float diameterX = this.sizeX[0];
                float diameterY = this.sizeY[0];
                float diameterZ = this.sizeZ[0];
                if (!this.separateXYZ) {
                    diameterY = diameterZ = this.sizeXYZ[0];
                    diameterX = diameterZ;
                }
                if (this.gizmoSpace[0] == 0) {
                    rotation = this.gizmo.peekRotation();
                } else if (this.gizmoSpace[0] == 1) {
                    Gizmo.GizmoRotation gizmoRotation = this.gizmo.peekGizmoRotation();
                    if (gizmoRotation != null) {
                        rotation = new Quaternionf((Quaternionfc)this.rotationQuaternion).invert();
                        switch (gizmoRotation.axis()) {
                            case field_11048: {
                                rotation.rotateX(gizmoRotation.radians());
                                break;
                            }
                            case field_11052: {
                                rotation.rotateY(gizmoRotation.radians());
                                break;
                            }
                            case field_11051: {
                                rotation.rotateZ(gizmoRotation.radians());
                            }
                        }
                        rotation.mul((Quaternionfc)this.rotationQuaternion);
                    } else {
                        rotation = null;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                class_243 center = this.gizmo.getInterpPosition();
                matrices.method_22903();
                matrices.method_22904(-camera.method_71156().field_1352 + center.field_1352 - 0.5, -camera.method_71156().field_1351 + center.field_1351 - 0.5, -camera.method_71156().field_1350 + center.field_1350 - 0.5);
                if (rotation != null) {
                    matrices.method_22907((Quaternionfc)rotation);
                }
                matrices.method_22907((Quaternionfc)new Quaternionf((Quaternionfc)this.rotationQuaternion).invert());
                switch (this.shapeSolid[0]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        class_2338 pivot = this.calculateRawPivot(diameterY);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, diameterY, diameterZ);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        class_2338 pivot = this.calculateRawPivot(this.sizeY[0]);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, this.sizeY[0], diameterZ);
                        break;
                    }
                    case 8: {
                        class_2338 pivot = this.calculateRawPivot(this.ringV[0]);
                        matrices.method_46416((float)pivot.method_10263(), (float)pivot.method_10264(), (float)pivot.method_10260());
                        this.renderBoundingBox(matrices, diameterX, this.ringV[0], diameterZ);
                        break;
                    }
                    default: {
                        throw new FaultyImplementationError();
                    }
                }
                matrices.method_22909();
            }
        }
    }

    private void renderBoundingBox(class_4587 matrices, float sizeX, float sizeY, float sizeZ) {
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        float offsetX = 1.0f - sizeX / 2.0f % 1.0f;
        float offsetY = 1.0f - sizeY / 2.0f % 1.0f;
        float offsetZ = 1.0f - sizeZ / 2.0f % 1.0f;
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        AxiomRenderer.setLineWidthLegacy(RenderHelper.baseLineWidth);
        Shapes.lineBox(matrices, (class_4588)bufferBuilder, -sizeX / 2.0f + offsetX, -sizeY / 2.0f + offsetY, -sizeZ / 2.0f + offsetZ, sizeX / 2.0f + offsetX, sizeY / 2.0f + offsetY, sizeZ / 2.0f + offsetZ, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, RenderHelper.baseLineWidth);
        class_9801 meshData = provider.build();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 0.4f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 0.1f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void performRotation(class_2350.class_2351 axis, float radians2) {
        Quaternionf rotation = new Quaternionf();
        rotation.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        if (this.getGizmoSpace() == 1) {
            switch (axis) {
                case field_11048: {
                    rotation.rotateLocalX(-radians2);
                    break;
                }
                case field_11052: {
                    rotation.rotateLocalY(-radians2);
                    break;
                }
                case field_11051: {
                    rotation.rotateLocalZ(-radians2);
                }
            }
        } else {
            switch (axis) {
                case field_11048: {
                    rotation.rotateX(-radians2);
                    break;
                }
                case field_11052: {
                    rotation.rotateY(-radians2);
                    break;
                }
                case field_11051: {
                    rotation.rotateZ(-radians2);
                }
            }
        }
        Vector3f euler = rotation.getEulerAnglesYXZ(new Vector3f());
        this.rotationX[0] = Math.round(Math.toDegrees(euler.x));
        this.rotationY[0] = Math.round(Math.toDegrees(euler.y));
        this.rotationZ[0] = Math.round(Math.toDegrees(euler.z));
        this.rotationQuaternion.identity();
        this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
    }

    public void pasteShape(boolean select2) {
        this.recalculate();
        if (this.chunkedBlockRegion.isEmpty() || this.gizmo == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (this.extendToGround && level != null) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            Position2ObjectMap<class_2680> newBlocks = new Position2ObjectMap<class_2680>(k -> new class_2680[4096]);
            class_2338 offset = this.usingRealCoordinates ? class_2338.field_10980 : this.gizmo.getTargetPosition();
            this.chunkedBlockRegion.forEachEntry((arg_0, arg_1, arg_2, arg_3) -> this.lambda$pasteShape$1((class_1937)level, mutableBlockPos, offset, newBlocks, arg_0, arg_1, arg_2, arg_3));
            newBlocks.forEachEntry(this.chunkedBlockRegion::addBlock);
        }
        String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.placed", countString);
        int modifiers = this.keepExisting ? HistoryEntry.MODIFIER_KEEP_EXISTING : 0;
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        MaskElement maskElement = MaskManager.getDestMask();
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (constantMaskElement.getConstant()) {
                if (this.usingRealCoordinates) {
                    if (select2) {
                        PositionSet selection = new PositionSet();
                        this.chunkedBlockRegion.forEachEntry((x, y, z, blockState) -> {
                            if (blockState.method_26215()) {
                                return;
                            }
                            selection.add(x, y, z);
                        });
                        Selection.clearSelection();
                        Selection.addSet(selection);
                    }
                    RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription, modifiers);
                } else {
                    class_2338 offset = this.gizmo.getTargetPosition();
                    if (select2) {
                        PositionSet selection = new PositionSet();
                        this.chunkedBlockRegion.forEachEntry((x, y, z, blockState) -> {
                            if (blockState.method_26215()) {
                                return;
                            }
                            selection.add(x + offset.method_10263(), y + offset.method_10264(), z + offset.method_10260());
                        });
                        Selection.clearSelection();
                        Selection.addSet(selection);
                    }
                    RegionHelper.pushBlockRegionChangeOffset(this.chunkedBlockRegion, offset, historyDescription, modifiers);
                }
            }
        } else {
            PositionSet selection;
            ChunkedBlockRegion newChunkedBlockRegion = new ChunkedBlockRegion();
            PositionSet positionSet = selection = select2 ? new PositionSet() : null;
            if (this.usingRealCoordinates) {
                this.chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
                    if (maskElement.test(maskContext.reset(), x, y, z)) {
                        newChunkedBlockRegion.addBlockWithoutDirty(x, y, z, (class_2680)block);
                        if (selection != null && !block.method_26215()) {
                            selection.add(x, y, z);
                        }
                    }
                });
            } else {
                class_2338 target = this.gizmo.getTargetPosition();
                int offsetX = target.method_10263();
                int offsetY = target.method_10264();
                int offsetZ = target.method_10260();
                this.chunkedBlockRegion.forEachEntry((x, y, z, block) -> {
                    if (maskElement.test(maskContext.reset(), x + offsetX, y + offsetY, z + offsetZ)) {
                        newChunkedBlockRegion.addBlockWithoutDirty(x + offsetX, y + offsetY, z + offsetZ, (class_2680)block);
                        if (selection != null && !block.method_26215()) {
                            selection.add(offsetX, y + offsetY, z + offsetZ);
                        }
                    }
                });
            }
            if (selection != null) {
                Selection.clearSelection();
                Selection.addSet(selection);
            }
            RegionHelper.pushBlockRegionChange(newChunkedBlockRegion, historyDescription, modifiers);
        }
    }

    private void recalculate() {
        this.recalculate = false;
        this.chunkedBlockRegion.clear();
        if (this.gizmo == null) {
            if (this.cutout) {
                ChunkRenderOverrider.release("Shape Tool");
                this.cutout = false;
            }
            return;
        }
        class_2680 block = Tool.getActiveBlock();
        boolean centerEvenDiameters = this.centerEvenDiameters && !this.decimalSizes;
        block0 : switch (this.shapeCategory[0]) {
            case 0: {
                class_2338 center = this.gizmo.getTargetPosition();
                float diameterX = this.sizeX[0];
                float diameterY = this.sizeY[0];
                float diameterZ = this.sizeZ[0];
                if (!this.separateXYZ) {
                    diameterY = diameterZ = this.sizeXYZ[0];
                    diameterX = diameterZ;
                }
                float cutoffY = this.metaball || !this.cutoff || this.cutoffAmount[0] <= 0 ? Float.NEGATIVE_INFINITY : diameterY * ((float)this.cutoffAmount[0] / 100.0f - 0.5f);
                switch (this.shapeSolid[0]) {
                    case 0: {
                        if (this.metaball) {
                            SphereRasterization.sphereMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        SphereRasterization.sphere(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, cutoffY, this.rotationQuaternion);
                        break block0;
                    }
                    case 1: {
                        if (this.metaball) {
                            CuboidRasterization.cuboidMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        CuboidRasterization.cuboid(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                        break block0;
                    }
                    case 2: {
                        if (this.metaball) {
                            OctahedronRasterization.octahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        OctahedronRasterization.octahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, cutoffY, this.rotationQuaternion);
                        break block0;
                    }
                    case 3: {
                        if (this.metaball) {
                            SupersphereRasterization.supersphereMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.exponent[0], this.rotationQuaternion);
                            break block0;
                        }
                        SupersphereRasterization.supersphere(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, cutoffY, this.exponent[0], this.rotationQuaternion);
                        break block0;
                    }
                    case 4: {
                        if (this.metaball) {
                            CylinderRasterization.cylinderMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        CylinderRasterization.cylinder(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                        break block0;
                    }
                    case 5: {
                        if (this.metaball) {
                            TubeRasterization.tubeMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.thickness[0], this.rotationQuaternion);
                            break block0;
                        }
                        TubeRasterization.tube(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.thickness[0], this.rotationQuaternion);
                        break block0;
                    }
                    case 6: {
                        if (this.metaball) {
                            ConeRasterization.coneMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.coneRounding[0], this.rotationQuaternion);
                            break block0;
                        }
                        ConeRasterization.cone(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.coneRounding[0], this.rotationQuaternion);
                        break block0;
                    }
                    case 7: {
                        if (this.metaball) {
                            PyramidRasterization.pyramidMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.sizeY[0])), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        PyramidRasterization.pyramid(this.chunkedBlockRegion, block, this.calculatePivot(this.sizeY[0]), diameterX, this.sizeY[0], diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                        break block0;
                    }
                    case 8: {
                        if (this.metaball) {
                            TorusRasterization.torusMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(this.ringV[0])), diameterX, diameterZ, this.hollow, centerEvenDiameters, this.ringH[0], this.ringV[0], this.rotationQuaternion);
                            break block0;
                        }
                        float torusCutoffY = !this.cutoff || this.cutoffAmount[0] <= 0 ? Float.NEGATIVE_INFINITY : this.ringV[0] * ((float)this.cutoffAmount[0] / 100.0f - 0.5f);
                        TorusRasterization.torus(this.chunkedBlockRegion, block, this.calculatePivot(this.ringV[0]), diameterX, diameterZ, this.hollow, centerEvenDiameters, torusCutoffY, this.ringH[0], this.ringV[0], this.rotationQuaternion);
                        break block0;
                    }
                    case 9: {
                        if (this.metaball) {
                            DodecahedronRasterization.dodhecahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        DodecahedronRasterization.dodhecahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, cutoffY, this.rotationQuaternion);
                        break block0;
                    }
                    case 10: {
                        if (this.metaball) {
                            IcosahedronRasterization.icosahedronMetaball(this.chunkedBlockRegion, this.metaballRange[0] * 2, block, center.method_10081((class_2382)this.calculatePivot(diameterY)), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, this.rotationQuaternion);
                            break block0;
                        }
                        IcosahedronRasterization.icosahedron(this.chunkedBlockRegion, block, this.calculatePivot(diameterY), diameterX, diameterY, diameterZ, this.hollow, centerEvenDiameters, cutoffY, this.rotationQuaternion);
                        break block0;
                    }
                }
                throw new FaultyImplementationError();
            }
            case 1: {
                float sizeX = this.sizeX[0];
                float sizeZ = this.sizeZ[0];
                if (!this.separateXYZ) {
                    sizeX = sizeZ = this.sizeXYZ[0];
                }
                switch (this.shapePlane[0]) {
                    case 0: {
                        DiskRasterization.disk(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, centerEvenDiameters, this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                        break block0;
                    }
                    case 1: {
                        PlaneRasterization.plane(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, centerEvenDiameters, this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                        break block0;
                    }
                    case 2: {
                        RegularPolygonRasterization.regularPolygon(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, centerEvenDiameters, this.polygonSides[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                        break block0;
                    }
                    case 3: {
                        SuperellipseRasterization.superellipse(new Vector3i(0, 0, 0), sizeX, sizeZ, this.hollow, centerEvenDiameters, this.exponent[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                        break block0;
                    }
                    case 4: {
                        SpiralRasterization.archimedean(new Vector3i(0, 0, 0), sizeX, sizeZ, centerEvenDiameters, this.loops[0], this.rotationQuaternion, (x, y, z) -> this.chunkedBlockRegion.addBlock(x, y, z, block));
                    }
                }
            }
        }
    }

    @Override
    public void displayImguiOptions() {
        this.usingRealCoordinates = true;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape"));
        boolean changed = ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.shape_category"), this.shapeCategory, new String[]{AxiomI18n.get("axiom.tool.shape.shape_category.solid"), AxiomI18n.get("axiom.tool.shape.shape_category.flat")});
        String sizeFormatting = this.decimalSizes ? "%.2f" : "%.0f";
        block0 : switch (this.shapeCategory[0]) {
            case 0: {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.shapeSolid, new String[]{AxiomI18n.get("axiom.tool.shape.sphere"), AxiomI18n.get("axiom.tool.shape.cuboid"), AxiomI18n.get("axiom.tool.shape.octahedron"), AxiomI18n.get("axiom.tool.shape.supersphere"), AxiomI18n.get("axiom.tool.shape.cylinder"), AxiomI18n.get("axiom.tool.shape.tube"), AxiomI18n.get("axiom.tool.shape.cone"), AxiomI18n.get("axiom.tool.shape.pyramid"), AxiomI18n.get("axiom.tool.shape.torus"), AxiomI18n.get("axiom.tool.shape.dodecahedron"), AxiomI18n.get("axiom.tool.shape.icosahedron")});
                switch (this.shapeSolid[0]) {
                    case 0: 
                    case 9: 
                    case 10: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayGenericShape(true, true, true);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.width"), sizeFormatting);
                        changed |= this.displayGenericShape(true, true, this.shapeSolid[0] == 2);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 3: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.supersphere"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.supersphere.exponent"), this.exponent, 0.5f, 20.0f, "%.2f", 32);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXYZ(AxiomI18n.get("axiom.tool.shape.width"), sizeFormatting);
                        changed |= this.displayGenericShape(true, true, true);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 4: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayHeight(sizeFormatting);
                        changed |= this.displayGenericShape(true, true, false);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 6: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.cone"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.cone.rounding"), this.coneRounding, 0.0f, 1.0f);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayHeight(sizeFormatting);
                        changed |= this.displayGenericShape(true, true, false);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 5: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.tube"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.tube.thickness"), this.thickness, 1.0f, 64.0f, sizeFormatting);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayHeight(sizeFormatting);
                        changed |= this.displayGenericShape(true, true, false);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 7: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"), sizeFormatting);
                        changed |= this.displayHeight(sizeFormatting);
                        changed |= this.displayGenericShape(true, true, false);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                    case 8: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.torus.outer"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.torus.ring"));
                        changed |= this.displayRingHV(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayGenericShape(true, true, true);
                        this.usingRealCoordinates = this.metaball;
                        break block0;
                    }
                }
                throw new FaultyImplementationError();
            }
            case 1: {
                changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape"), this.shapePlane, new String[]{AxiomI18n.get("axiom.tool.shape.disk"), AxiomI18n.get("axiom.tool.shape.plane"), AxiomI18n.get("axiom.tool.shape.regular_polygon"), AxiomI18n.get("axiom.tool.shape.superellipse"), AxiomI18n.get("axiom.tool.shape.archimedean_spiral")});
                switch (this.shapePlane[0]) {
                    case 0: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayGenericShape(true, false, false);
                        break;
                    }
                    case 1: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"), sizeFormatting);
                        changed |= this.displayGenericShape(true, false, false);
                        break;
                    }
                    case 2: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.regular_polygon"));
                        changed |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.regular_polygon.sides"), this.polygonSides, 3, 9);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.width"), sizeFormatting);
                        changed |= this.displayGenericShape(true, false, false);
                        break;
                    }
                    case 3: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.superellipse"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.supersphere.exponent"), this.exponent, 0.5f, 20.0f, "%.2f", 32);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayGenericShape(true, false, false);
                        break;
                    }
                    case 4: {
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.archimedean_spiral"));
                        changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.archimedean_spiral.loops"), this.loops, 0.1f, 20.0f);
                        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                        changed |= this.displayDiameterXZ(AxiomI18n.get("axiom.tool.shape.diameter"), sizeFormatting);
                        changed |= this.displayGenericShape(false, false, false);
                    }
                }
                this.usingRealCoordinates = false;
                break;
            }
            default: {
                throw new FaultyImplementationError();
            }
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.placement_options"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.offset_when_placing"), this.offsetWhenPlacing)) {
            this.offsetWhenPlacing = !this.offsetWhenPlacing;
            changed = true;
        }
        if (!this.instantPlace) {
            changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.gizmo_space"), this.gizmoSpace, new String[]{AxiomI18n.get("axiom.tool.shape.gizmo_space.global"), AxiomI18n.get("axiom.tool.shape.gizmo_space.local")});
        }
        if (this.shapeCategory[0] != 1) {
            changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.pivot"), this.pivot, new String[]{AxiomI18n.get("axiom.tool.shape.pivot.center"), AxiomI18n.get("axiom.tool.shape.pivot.base")});
        }
        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.shape.rotation"), this.placeRotation, new String[]{AxiomI18n.get("axiom.tool.shape.rotation.keep"), AxiomI18n.get("axiom.tool.shape.rotation.auto"), AxiomI18n.get("axiom.tool.shape.rotation.reset")});
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.paste_options"));
        if (ImGui.checkbox("Instant Place", this.instantPlace)) {
            boolean bl = this.instantPlace = !this.instantPlace;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), this.keepExisting)) {
            this.keepExisting = !this.keepExisting;
            changed = true;
        }
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.path.extend_to_ground"), this.extendToGround)) {
            boolean bl = this.extendToGround = !this.extendToGround;
        }
        if (ImGui.button("Paste Copy")) {
            this.pasteShape(false);
        }
        if (ImGui.button("Paste and Select")) {
            this.pasteShape(true);
            this.reset();
        }
        if (changed) {
            this.recalculate = true;
        }
    }

    private boolean displayDiameterXYZ(String diameterTerm, String sizeFormatting) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.create_shape.separate_xyz") + "##SeparateXYZ", this.separateXYZ)) {
            boolean bl = this.separateXYZ = !this.separateXYZ;
            if (this.separateXYZ) {
                this.sizeX[0] = this.sizeXYZ[0];
                this.sizeY[0] = this.sizeXYZ[0];
                this.sizeZ[0] = this.sizeXYZ[0];
            } else {
                this.sizeXYZ[0] = Math.round(this.sizeX[0] / 3.0f + this.sizeY[0] / 3.0f + this.sizeZ[0] / 3.0f);
            }
            settingsChanged = true;
        }
        if (this.separateXYZ) {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " X##SizeX", this.sizeX, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " Y##SizeY", this.sizeY, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " Z##SizeZ", this.sizeZ, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeXYZ[0] = Math.round(this.sizeX[0] / 3.0f + this.sizeY[0] / 3.0f + this.sizeZ[0] / 3.0f);
        } else {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + "##Size", this.sizeXYZ, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeX[0] = this.sizeXYZ[0];
            this.sizeY[0] = this.sizeXYZ[0];
            this.sizeZ[0] = this.sizeXYZ[0];
        }
        return settingsChanged;
    }

    private boolean displayDiameterXZ(String diameterTerm, String sizeFormatting) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.separate_xz"), this.separateXYZ)) {
            boolean bl = this.separateXYZ = !this.separateXYZ;
            if (this.separateXYZ) {
                this.sizeX[0] = this.sizeXYZ[0];
                this.sizeZ[0] = this.sizeXYZ[0];
            } else {
                this.sizeXYZ[0] = Math.round(this.sizeX[0] / 2.0f + this.sizeZ[0] / 2.0f);
            }
            settingsChanged = true;
        }
        if (this.separateXYZ) {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " X##SizeX", this.sizeX, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " Z##SizeZ", this.sizeZ, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeXYZ[0] = Math.round(this.sizeX[0] / 2.0f + this.sizeZ[0] / 2.0f);
        } else {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + "##Size", this.sizeXYZ, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.sizeX[0] = this.sizeXYZ[0];
            this.sizeZ[0] = this.sizeXYZ[0];
        }
        return settingsChanged;
    }

    private boolean displayRingHV(String diameterTerm, String sizeFormatting) {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.separate_hv"), this.separateHV)) {
            this.separateHV = !this.separateHV;
            settingsChanged = true;
        }
        if (this.separateHV) {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " H##RingH", this.ringH, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            settingsChanged |= ImGui.sliderFloat(diameterTerm + " V##RingV", this.ringV, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        } else {
            settingsChanged |= ImGui.sliderFloat(diameterTerm + "##RingHV", this.ringH, 1.0f, 64.0f, sizeFormatting);
            ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
            this.ringV[0] = this.ringH[0];
        }
        return settingsChanged;
    }

    private boolean displayHeight(String sizeFormatting) {
        boolean settingsChanged = ImGui.sliderFloat(AxiomI18n.get("axiom.tool.shape.height") + "##SizeY", this.sizeY, 1.0f, 64.0f, sizeFormatting);
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        return settingsChanged;
    }

    private boolean displayGenericShape(boolean hollow, boolean metaball, boolean cutoff) {
        boolean settingsChanged = this.displayAdvancedRotation();
        if (hollow || metaball) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.shape.modifiers"));
            if (hollow) {
                settingsChanged |= this.displayHollow();
            }
            if (metaball) {
                settingsChanged |= this.displayMetaball();
            }
            if (cutoff) {
                settingsChanged |= this.displayCutoff();
            }
        }
        return settingsChanged;
    }

    private boolean displayHollow() {
        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.create_shape.hollow") + "##Hollow", this.hollow)) {
            this.hollow = !this.hollow;
            return true;
        }
        return false;
    }

    private boolean displayMetaball() {
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.metaball") + "##Metaball", this.metaball)) {
            this.metaball = !this.metaball;
            settingsChanged = true;
        }
        if (this.metaball) {
            settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.metaball_range"), this.metaballRange, 2, 16);
        }
        return settingsChanged;
    }

    private boolean displayCutoff() {
        if (this.metaball) {
            return false;
        }
        boolean settingsChanged = false;
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.shape.cutoff"), this.cutoff)) {
            this.cutoff = !this.cutoff;
            settingsChanged = true;
        }
        if (this.cutoff) {
            settingsChanged |= ImGui.sliderInt(AxiomI18n.get("axiom.tool.shape.cutoff_amount"), this.cutoffAmount, 0, 100, "%d%%");
        }
        return settingsChanged;
    }

    private boolean displayAdvancedRotation() {
        boolean settingsChanged = false;
        if (ImGui.collapsingHeader(class_1074.method_4662((String)"axiom.editorui.window.create_shape.advanced", (Object[])new Object[0]) + "###Advanced")) {
            ImGui.indent(8.0f * EditorUI.getUiScale());
            if (ImGui.checkbox("Decimal Sizes", this.decimalSizes)) {
                this.decimalSizes = !this.decimalSizes;
                settingsChanged = true;
            }
            ImGuiHelper.tooltip("Allows using decimal numbers (eg. 10.5) in various size sliders");
            if (this.decimalSizes) {
                ImGui.beginDisabled();
            }
            if (ImGui.checkbox("Center Even Diameters", this.centerEvenDiameters && !this.decimalSizes)) {
                this.centerEvenDiameters = !this.centerEvenDiameters;
                settingsChanged = true;
            }
            ImGuiHelper.tooltip("Adjusts even diameters (eg. 10) to be centered at the lower corner");
            if (this.decimalSizes) {
                ImGui.endDisabled();
            }
            if (ImGui.button(AxiomI18n.get("axiom.tool.shape.reset_rotation"), ImGui.calcItemWidth(), 0.0f)) {
                this.rotationX[0] = 0.0f;
                this.rotationY[0] = 0.0f;
                this.rotationZ[0] = 0.0f;
                settingsChanged = true;
            }
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.yaw") + "##Yaw", this.rotationY, -180.0f, 180.0f, "%.2f\u00b0");
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.pitch") + "##Pitch", this.rotationX, -180.0f, 180.0f, "%.2f\u00b0");
            settingsChanged |= ImGui.sliderFloat(AxiomI18n.get("axiom.editorui.window.create_shape.roll") + "##Roll", this.rotationZ, -180.0f, 180.0f, "%.2f\u00b0");
            ImGui.unindent(8.0f * EditorUI.getUiScale());
        }
        if (settingsChanged) {
            this.rotationQuaternion.identity();
            this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        }
        return settingsChanged;
    }

    private int getGizmoSpace() {
        if (this.instantPlace) {
            return 0;
        }
        return this.gizmoSpace[0];
    }

    private int getPivot() {
        if (this.shapeCategory[0] != 0) {
            return 0;
        }
        return this.pivot[0];
    }

    private class_2338 calculateRawPivot(float height) {
        int pivot = this.getPivot();
        if (pivot == 0) {
            return class_2338.field_10980;
        }
        if (pivot == 1) {
            return new class_2338(0, (int)Math.floor((height - 1.0f) / 2.0f), 0);
        }
        throw new FaultyImplementationError();
    }

    private class_2338 calculatePivot(float height) {
        int pivot = this.getPivot();
        if (pivot == 0) {
            return class_2338.field_10980;
        }
        if (pivot == 1) {
            Vector3d vector = new Vector3d(0.0, Math.floor((height - 1.0f) / 2.0f), 0.0);
            this.rotationQuaternion.transformInverse(vector);
            return class_2338.method_49637((double)(vector.x + 0.5), (double)(vector.y + 0.5), (double)(vector.z + 0.5));
        }
        throw new FaultyImplementationError();
    }

    private int getPlaceRotation() {
        return this.placeRotation[0];
    }

    private void setRotationAuto(class_2338 at) {
        this.rotationZ[0] = 0.0f;
        this.rotationY[0] = 0.0f;
        this.rotationX[0] = 0.0f;
        this.rotationQuaternion.identity();
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        int checkRadiusSq = 12;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int x = at.method_10263();
        int y = at.method_10264();
        int z = at.method_10260();
        for (int xo = -3; xo <= 3; ++xo) {
            for (int yo = -3; yo <= 3; ++yo) {
                for (int zo = -3; zo <= 3; ++zo) {
                    class_2680 block;
                    int distSq = xo * xo + yo * yo + zo * zo;
                    if (distSq > checkRadiusSq || !(block = world.method_8320((class_2338)mutableBlockPos.method_10103(x + xo, y + yo, z + zo))).method_51366()) continue;
                    float factor = 1.0f / (float)Math.max(1.0, Math.sqrt(distSq));
                    offsetX -= (float)xo * factor;
                    offsetY -= (float)yo * factor;
                    offsetZ -= (float)zo * factor;
                }
            }
        }
        float lengthSq = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if (lengthSq > 0.01f) {
            float invNormalLength = 1.0f / (float)Math.sqrt(lengthSq);
            float normalX = offsetX * invNormalLength;
            float normalY = offsetY * invNormalLength;
            float normalZ = offsetZ * invNormalLength;
            if ((double)Math.abs(normalX) < 1.0E-4) {
                normalX = 0.0f;
            }
            if ((double)Math.abs(normalY) < 1.0E-4) {
                normalY = 0.0f;
            }
            if ((double)Math.abs(normalZ) < 1.0E-4) {
                normalZ = 0.0f;
            }
            double horizontal = Math.sqrt(normalX * normalX + normalZ * normalZ);
            float pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)normalY, (double)horizontal) * 57.2957763671875)) + 90.0f));
            float yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)normalZ, (double)normalX) * 57.2957763671875) + 90.0f));
            this.rotationQuaternion.rotateXYZ((float)Math.toRadians(pitch), (float)Math.toRadians(yaw), 0.0f);
            Vector3f euler = this.rotationQuaternion.getEulerAnglesYXZ(new Vector3f());
            this.rotationX[0] = Math.round(Math.toDegrees(euler.x));
            this.rotationY[0] = Math.round(Math.toDegrees(euler.y));
            this.rotationZ[0] = Math.round(Math.toDegrees(euler.z));
            this.rotationQuaternion.identity();
            this.rotationQuaternion.rotateYXZ((float)Math.toRadians(this.rotationY[0]), (float)Math.toRadians(this.rotationX[0]), (float)Math.toRadians(this.rotationZ[0]));
        }
    }

    @Override
    public String listenForEsc() {
        if (this.instantPlace) {
            return null;
        }
        if (this.gizmo != null && this.gizmo.enableAxes) {
            return "Deselect Point";
        }
        if (this.gizmo != null) {
            return AxiomI18n.get("axiom.widget.cancel");
        }
        return null;
    }

    @Override
    public boolean initiateAdjustment() {
        boolean allowAdjustment = false;
        if (this.gizmo == null) {
            return false;
        }
        if (this.shapeCategory[0] == 1) {
            allowAdjustment = true;
        } else if (this.shapeCategory[0] == 0) {
            boolean bl = allowAdjustment = this.shapeSolid[0] != 8;
        }
        if (allowAdjustment) {
            int height;
            int radius;
            if (this.separateXYZ) {
                radius = Math.round(this.sizeX[0] / 2.0f + this.sizeZ[0] / 2.0f);
                height = Math.round(this.sizeY[0]);
            } else {
                radius = Math.round(this.sizeXYZ[0]);
                height = -1;
            }
            float distance = (float)this.gizmo.getInterpPosition().method_1022(class_310.method_1551().field_1724.method_33571());
            this.radiusAdjustment.initiateAdjustment(radius, height, distance);
            return true;
        }
        return false;
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        GenericRadiusAdjustment.Result result = this.radiusAdjustment.renderAdjustment(mouseX, mouseY, mouseDelta);
        if (result.changed()) {
            if (this.separateXYZ) {
                this.sizeX[0] = result.radius();
                if (result.height() >= 0) {
                    this.sizeY[0] = result.height();
                }
                this.sizeZ[0] = result.radius();
            } else {
                this.sizeXYZ[0] = result.radius();
            }
            this.recalculate = true;
        }
        return result.mouseDelta();
    }

    @Override
    public String listenForEnter() {
        if (!this.chunkedBlockRegion.isEmpty()) {
            return AxiomI18n.get("axiom.widget.confirm");
        }
        return null;
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.shape");
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.recalculate = true;
    }

    @Override
    public char iconChar() {
        return '\ue91c';
    }

    @Override
    public String keybindId() {
        return "shape";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_SHAPE, AxiomPermission.BUILD_SECTION);
    }

    private /* synthetic */ void lambda$pasteShape$1(class_1937 level, class_2338.class_2339 mutableBlockPos, class_2338 offset, Position2ObjectMap newBlocks, int x, int y, int z, class_2680 block) {
        class_2680 below;
        if (block.method_26215()) {
            return;
        }
        for (int yo = 1; yo < 256 && this.chunkedBlockRegion.getBlockStateOrAir(x, y - yo, z).method_26215() && (below = level.method_8320((class_2338)mutableBlockPos.method_10103(x + offset.method_10263(), y - yo + offset.method_10264(), z + offset.method_10260()))).method_26204() != class_2246.field_10243 && below.method_45474(); ++yo) {
            newBlocks.put(x, y - yo, z, block);
        }
    }
}

