/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.ruler;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.modelling.GizmoList;
import com.moulberry.axiom.tools.ruler.RulerCircle;
import com.moulberry.axiom.utils.ProjectedText;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class RulerTool
implements Tool {
    private static final int[] shapeMode = new int[]{0};
    private static final int[] displayMode = new int[]{0};
    private static int lastGizmoList = -1;
    private static final List<GizmoList> lines = new ArrayList<GizmoList>();
    private static final List<RulerCircle> circles = new ArrayList<RulerCircle>();
    private class_2338 circleOrigin = null;
    private class_2350.class_2351 circleAxis = null;
    private static final int[] splitSegments = new int[]{2};
    private class_2338 minimum = null;
    private class_2338 maximum = null;
    private float totalLengthEuclidean = 0.0f;
    private int totalLengthManhattan = 0;
    private static int RULER_SHAPE_LINE = 0;
    private static int RULER_SHAPE_CIRCLE = 1;

    @Override
    public void reset() {
        this.circleOrigin = null;
        this.circleAxis = null;
        this.recalculate();
    }

    private void clear() {
        lines.clear();
        circles.clear();
        this.reset();
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    if (shapeMode[0] == RULER_SHAPE_LINE) {
                        for (GizmoList line : lines) {
                            if (!line.hasActiveGizmo()) continue;
                            for (GizmoList other : lines) {
                                if (line == other) continue;
                                other.deselectActiveGizmo();
                            }
                            line.addGizmo(class_243.method_24953((class_2382)result.blockPos()));
                            this.recalculate();
                            return UserAction.ActionResult.USED_STOP;
                        }
                        GizmoList gizmoList = new GizmoList();
                        gizmoList.addGizmo(class_243.method_24953((class_2382)result.blockPos()));
                        lines.add(gizmoList);
                        this.recalculate();
                    } else if (shapeMode[0] == RULER_SHAPE_CIRCLE) {
                        if (this.circleOrigin == null) {
                            this.circleOrigin = result.blockPos();
                            this.circleAxis = result.direction().method_10166();
                        } else {
                            class_2338 targetPos;
                            for (RulerCircle circle2 : circles) {
                                circle2.center().enableAxes = false;
                            }
                            switch (this.circleAxis) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case field_11048: {
                                    class_2338 class_23382 = new class_2338(this.circleOrigin.method_10263(), result.blockPos().method_10264(), result.blockPos().method_10260());
                                    break;
                                }
                                case field_11052: {
                                    class_2338 class_23382 = new class_2338(result.blockPos().method_10263(), this.circleOrigin.method_10264(), result.blockPos().method_10260());
                                    break;
                                }
                                case field_11051: {
                                    class_2338 class_23382 = targetPos = new class_2338(result.blockPos().method_10263(), result.blockPos().method_10264(), this.circleOrigin.method_10260());
                                }
                            }
                            if (!this.circleOrigin.equals((Object)targetPos)) {
                                circles.add(new RulerCircle(this.circleOrigin, targetPos, this.circleAxis));
                            }
                            this.circleOrigin = null;
                            this.circleAxis = null;
                        }
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case LEFT_MOUSE: {
                if (shapeMode[0] == RULER_SHAPE_LINE) {
                    for (GizmoList line : lines) {
                        if (!line.hasActiveGizmo()) continue;
                        if (!line.leftClick()) break;
                        return UserAction.ActionResult.USED_STOP;
                    }
                    for (GizmoList line : lines) {
                        if (!line.leftClick()) continue;
                        return UserAction.ActionResult.USED_STOP;
                    }
                } else if (shapeMode[0] == RULER_SHAPE_CIRCLE) {
                    Gizmo gizmo;
                    for (RulerCircle circle3 : circles) {
                        gizmo = circle3.center();
                        if (gizmo.enableAxes && gizmo.leftClick()) {
                            return UserAction.ActionResult.USED_STOP;
                        }
                        gizmo.enableAxes = false;
                    }
                    for (RulerCircle circle3 : circles) {
                        gizmo = circle3.center();
                        if (gizmo.leftClick()) {
                            for (RulerCircle other : circles) {
                                if (circle3 == other) continue;
                                other.center().enableAxes = false;
                            }
                            return UserAction.ActionResult.USED_STOP;
                        }
                        gizmo.enableAxes = false;
                    }
                }
                return UserAction.ActionResult.NOT_HANDLED;
            }
            case ESCAPE: 
            case ENTER: {
                boolean deselected = false;
                for (GizmoList line : lines) {
                    deselected |= line.hasActiveGizmo();
                    line.deselectActiveGizmo();
                }
                for (RulerCircle circle4 : circles) {
                    deselected |= circle4.center().enableAxes;
                    circle4.center().enableAxes = false;
                }
                if (!deselected) break;
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                if (shapeMode[0] == RULER_SHAPE_LINE) {
                    for (GizmoList line : lines) {
                        if (!line.hasActiveGizmo()) continue;
                        line.delete();
                        this.recalculate();
                        return UserAction.ActionResult.USED_STOP;
                    }
                } else if (shapeMode[0] == RULER_SHAPE_CIRCLE && circles.removeIf(circle -> circle.center().enableAxes)) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.clear();
                break;
            }
            case REDO: {
                if (shapeMode[0] == RULER_SHAPE_LINE) {
                    Object line;
                    if (lastGizmoList >= 0 && lastGizmoList < lines.size() && ((GizmoList)(line = lines.get(lastGizmoList))).redo()) {
                        this.recalculate();
                        return UserAction.ActionResult.USED_STOP;
                    }
                    for (GizmoList line2 : lines) {
                        if (!line2.redo()) continue;
                        this.recalculate();
                        return UserAction.ActionResult.USED_STOP;
                    }
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case UNDO: {
                if (shapeMode[0] == RULER_SHAPE_LINE) {
                    GizmoList line;
                    if (lastGizmoList >= 0 && lastGizmoList < lines.size() && (line = lines.get(lastGizmoList)).undo()) {
                        this.recalculate();
                        return UserAction.ActionResult.USED_STOP;
                    }
                    for (GizmoList line3 : lines) {
                        if (!line3.undo()) continue;
                        this.recalculate();
                        return UserAction.ActionResult.USED_STOP;
                    }
                } else if (shapeMode[0] == RULER_SHAPE_CIRCLE && circles.removeIf(circle -> circle.center().enableAxes)) {
                    return UserAction.ActionResult.USED_STOP;
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        int i;
        GizmoList line2;
        Selection.render(camera, time, matrices, projection, 4);
        boolean showRaycastOverlay = true;
        if (shapeMode[0] == RULER_SHAPE_LINE) {
            for (GizmoList line2 : lines) {
                if (!line2.hasGrabbedGizmo()) continue;
                showRaycastOverlay = false;
                break;
            }
        }
        for (i = 0; i < lines.size(); ++i) {
            line2 = lines.get(i);
            if (!line2.isEmpty() || lastGizmoList == i) continue;
            lines.remove(i);
            break;
        }
        if (shapeMode[0] == RULER_SHAPE_LINE) {
            for (i = 0; i < lines.size(); ++i) {
                RayCaster.RaycastResult result;
                line2 = lines.get(i);
                if (line2.updateGizmos(camera, time)) {
                    this.recalculate();
                }
                line2.renderGizmos(matrices, camera);
                if (!line2.hasActiveGizmo()) continue;
                lastGizmoList = i;
                Gizmo last = line2.getGizmos().get(line2.getGizmos().size() - 1);
                if (!last.enableAxes || last.isGrabbed() || (result = Tool.raycastBlock(false, true, true)) == null) continue;
                class_2338 target = result.blockPos();
                matrices.method_22903();
                matrices.method_22904((double)target.method_10263() - camera.method_71156().field_1352, (double)target.method_10264() - camera.method_71156().field_1351, (double)target.method_10260() - camera.method_71156().field_1350);
                AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                VertexConsumerProvider provider = VertexConsumerProvider.shared();
                class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
                class_4587.class_4665 pose = matrices.method_23760();
                class_2338 offsetTarget = last.getTargetPosition().method_10059((class_2382)target);
                class_243 fromVec = class_243.method_24953((class_2382)offsetTarget);
                class_243 toVec = new class_243(0.5, 0.5, 0.5);
                Shapes.line(bufferBuilder, pose, 1.0f, 1.0f, 1.0f, fromVec, toVec);
                class_9801 meshData = provider.build();
                AxiomRenderer.setShaderColour(0.961f, 0.796f, 0.259f, 1.0f);
                AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
                AxiomRenderer.setShaderColour(0.961f, 0.796f, 0.259f, 0.35f);
                AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
                AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                boolean displayDistance = displayMode[0] == 1;
                ProjectedText.setupProjectedText();
                RulerTool.drawDistanceTextForLine(matrices, projection, displayDistance, offsetTarget, class_2338.field_10980, class_243.field_1353);
                ProjectedText.finishProjectedText();
                matrices.method_22909();
            }
        } else if (shapeMode[0] == RULER_SHAPE_CIRCLE) {
            if (!circles.isEmpty()) {
                boolean showGizmo;
                class_243 lookDirection = Tool.getLookDirection();
                boolean isLeftDown = Tool.isMouseDown(0);
                boolean isCtrlDown = EditorUI.isCtrlOrCmdDown();
                boolean renderGizmos = showGizmo = !EditorUI.isActive() || !isCtrlDown;
                boolean positionChanged = false;
                for (RulerCircle circle : circles) {
                    class_243 after;
                    Gizmo gizmo = circle.center();
                    class_243 before = gizmo.getTargetVec();
                    gizmo.update(time, lookDirection, isLeftDown, isCtrlDown, showGizmo);
                    gizmo.setAxisDirections(camera.method_71156().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_71156().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_71156().field_1350 > (double)gizmo.getTargetPosition().method_10260());
                    if (gizmo.isGrabbed()) {
                        renderGizmos = true;
                        showRaycastOverlay = false;
                    }
                    if (before.equals((Object)(after = gizmo.getTargetVec()))) continue;
                    positionChanged = true;
                }
                if (renderGizmos) {
                    for (RulerCircle circle : circles) {
                        circle.center().render(matrices, camera, isCtrlDown);
                    }
                }
                if (positionChanged) {
                    this.recalculate();
                }
            }
            if (this.circleOrigin != null) {
                showRaycastOverlay = false;
                RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
                if (result != null) {
                    class_2338 targetPos = switch (this.circleAxis) {
                        default -> throw new IncompatibleClassChangeError();
                        case class_2350.class_2351.field_11048 -> new class_2338(this.circleOrigin.method_10263(), result.blockPos().method_10264(), result.blockPos().method_10260());
                        case class_2350.class_2351.field_11052 -> new class_2338(result.blockPos().method_10263(), this.circleOrigin.method_10264(), result.blockPos().method_10260());
                        case class_2350.class_2351.field_11051 -> new class_2338(result.blockPos().method_10263(), result.blockPos().method_10264(), this.circleOrigin.method_10260());
                    };
                    RulerCircle rulerCircle = new RulerCircle(this.circleOrigin, targetPos, this.circleAxis);
                    class_243 origin = result.getLocation();
                    matrices.method_22903();
                    matrices.method_22904(origin.field_1352 - camera.method_71156().field_1352, origin.field_1351 - camera.method_71156().field_1351, origin.field_1350 - camera.method_71156().field_1350);
                    VertexConsumerProvider provider = VertexConsumerProvider.shared();
                    class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
                    class_4587.class_4665 pose = matrices.method_23760();
                    rulerCircle.drawLineFromCenterToEdge(bufferBuilder, pose, origin);
                    class_9801 meshData = provider.build();
                    AxiomRenderer.setShaderColour(0.961f, 0.796f, 0.259f, 1.0f);
                    AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
                    AxiomRenderer.setShaderColour(0.961f, 0.796f, 0.259f, 0.35f);
                    AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
                    AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                    boolean displayDistance = displayMode[0] == 1;
                    ProjectedText.setupProjectedText();
                    RulerTool.drawDistanceTextForCircle(matrices, projection, rulerCircle, displayDistance, origin);
                    ProjectedText.finishProjectedText();
                    bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
                    rulerCircle.drawCircle(camera, matrices, class_310.method_1551().field_1687, bufferBuilder, -668862, origin);
                    meshData = provider.build();
                    AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, true);
                    matrices.method_22909();
                }
            }
        }
        if (showRaycastOverlay) {
            RayCaster.RaycastResult result = Tool.raycastBlock(false, true, true);
            Tool.renderRaycastOverlay(result, matrices, camera);
        }
    }

    public static void renderPoints(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (lines.isEmpty() && circles.isEmpty()) {
            return;
        }
        class_243 origin = camera.method_71156();
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        RulerTool.buildLines(bufferBuilder, matrices, origin);
        class_9801 meshData = provider.build();
        AxiomRenderer.setShaderColour(1.0f, 0.1f, 0.1f, 1.0f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
        AxiomRenderer.setShaderColour(1.0f, 0.1f, 0.1f, 0.35f);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_IGNORE_DEPTH, null, meshData, true);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        RulerTool.drawDistanceText(matrices, projection, origin);
        RulerTool.drawBlockOutlines(camera, matrices, origin);
    }

    private static void drawDistanceText(class_4587 matrix, Matrix4f projection, class_243 origin) {
        ProjectedText.setupProjectedText();
        boolean displayDistance = displayMode[0] == 1;
        for (GizmoList line : lines) {
            RulerTool.drawDistanceTextForLines(matrix, projection, line, displayDistance, origin);
        }
        for (RulerCircle circle : circles) {
            RulerTool.drawDistanceTextForCircle(matrix, projection, circle, displayDistance, origin);
        }
        ProjectedText.finishProjectedText();
    }

    private static void drawDistanceTextForLines(class_4587 matrix, Matrix4f projection, GizmoList line, boolean displayDistance, class_243 origin) {
        List<Gizmo> gizmos = line.getGizmos();
        for (int i = 0; i < gizmos.size() - 1; ++i) {
            class_2338 from = gizmos.get(i).getTargetPosition();
            class_2338 to = gizmos.get(i + 1).getTargetPosition();
            RulerTool.drawDistanceTextForLine(matrix, projection, displayDistance, to, from, origin);
        }
    }

    private static void drawDistanceTextForLine(class_4587 matrix, Matrix4f projection, boolean displayDistance, class_2338 to, class_2338 from, class_243 origin) {
        float dx = to.method_10263() - from.method_10263();
        float dy = to.method_10264() - from.method_10264();
        float dz = to.method_10260() - from.method_10260();
        if (displayDistance) {
            float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distance > 1.0f) {
                ProjectedText.renderProjectedText(String.format("+%.1f", Float.valueOf(distance)), matrix, projection, (float)((double)from.method_10263() - origin.field_1352) + dx * 0.5f + 0.5f, (float)((double)from.method_10264() - origin.field_1351) + dy * 0.5f + 0.5f, (float)((double)from.method_10260() - origin.field_1350) + dz * 0.5f + 0.5f);
            }
        } else {
            int bz;
            int by;
            int bx = Math.abs(to.method_10263() - from.method_10263()) + 1;
            int distance = Math.max(bx, Math.max(by = Math.abs(to.method_10264() - from.method_10264()) + 1, bz = Math.abs(to.method_10260() - from.method_10260()) + 1));
            if (distance > 1) {
                ProjectedText.renderProjectedText(String.format("%d", distance), matrix, projection, (float)((double)from.method_10263() - origin.field_1352) + dx * 0.5f + 0.5f, (float)((double)from.method_10264() - origin.field_1351) + dy * 0.5f + 0.5f, (float)((double)from.method_10260() - origin.field_1350) + dz * 0.5f + 0.5f);
            }
        }
    }

    private static void drawDistanceTextForCircle(class_4587 matrix, Matrix4f projection, RulerCircle circle, boolean displayDistance, class_243 origin) {
        class_2338 from = circle.center().getTargetPosition();
        class_2338 to = from.method_10081(circle.offset());
        float dx = to.method_10263() - from.method_10263();
        float dy = to.method_10264() - from.method_10264();
        float dz = to.method_10260() - from.method_10260();
        if (displayDistance) {
            float distance = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (distance > 1.0f) {
                ProjectedText.renderProjectedText(String.format("r=%.1f", Float.valueOf(distance)), matrix, projection, (float)((double)from.method_10263() - origin.field_1352) + dx * 0.5f + 0.5f, (float)((double)from.method_10264() - origin.field_1351) + dy * 0.5f + 0.5f, (float)((double)from.method_10260() - origin.field_1350) + dz * 0.5f + 0.5f);
            }
            int radius = circle.radius();
            float circumference = (float)((double)(radius * 2) * Math.PI);
            ProjectedText.renderProjectedText(String.format("c=%.1f", Float.valueOf(circumference)), matrix, projection, (float)((double)to.method_10263() - origin.field_1352), (float)((double)to.method_10264() - origin.field_1351), (float)((double)to.method_10260() - origin.field_1350));
        } else {
            int bz;
            int by;
            int bx = Math.abs(to.method_10263() - from.method_10263()) + 1;
            int distance = Math.max(bx, Math.max(by = Math.abs(to.method_10264() - from.method_10264()) + 1, bz = Math.abs(to.method_10260() - from.method_10260()) + 1));
            if (distance > 1) {
                ProjectedText.renderProjectedText(String.format("r=%d", distance), matrix, projection, (float)((double)from.method_10263() - origin.field_1352) + dx * 0.5f + 0.5f, (float)((double)from.method_10264() - origin.field_1351) + dy * 0.5f + 0.5f, (float)((double)from.method_10260() - origin.field_1350) + dz * 0.5f + 0.5f);
            }
            int blockCountCircumference = circle.blockCount();
            ProjectedText.renderProjectedText(String.format("c=%d", blockCountCircumference), matrix, projection, (float)((double)to.method_10263() - origin.field_1352), (float)((double)to.method_10264() - origin.field_1351), (float)((double)to.method_10260() - origin.field_1350));
        }
    }

    private static void drawBlockOutlines(class_4184 camera, class_4587 matrices, class_243 origin) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        for (GizmoList line : lines) {
            for (Gizmo gizmo : line.getGizmos()) {
                class_2338 point = gizmo.getTargetPosition();
                class_2680 blockState = level.method_8320(point);
                class_265 voxelShape = blockState.method_26172((class_1922)level, point, class_3726.method_16195((class_1297)camera.method_19331()));
                matrices.method_22903();
                matrices.method_22904((double)point.method_10263() - origin.field_1352, (double)point.method_10264() - origin.field_1351, (double)point.method_10260() - origin.field_1350);
                Shapes.blockOutline(bufferBuilder, matrices.method_23760(), voxelShape, -16399395);
                matrices.method_22909();
            }
        }
        for (RulerCircle circle : circles) {
            circle.drawCircle(camera, matrices, level, bufferBuilder, -16399395, origin);
        }
        AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH.render(bufferBuilder.method_60794());
    }

    private static void buildLines(class_287 bufferBuilder, class_4587 matrices, class_243 origin) {
        class_4587.class_4665 pose = matrices.method_23760();
        for (GizmoList line : lines) {
            List<Gizmo> gizmos = line.getGizmos();
            for (int i = 0; i < gizmos.size() - 1; ++i) {
                class_243 from = gizmos.get(i).getTargetVec();
                class_243 to = gizmos.get(i + 1).getTargetVec();
                Shapes.line(bufferBuilder, pose, 1.0f, 1.0f, 1.0f, from.method_1020(origin), to.method_1020(origin));
            }
        }
        for (RulerCircle circle : circles) {
            circle.drawLineFromCenterToEdge(bufferBuilder, pose, origin);
        }
    }

    @Override
    public void displayImguiOptions() {
        boolean canSelectedCenter;
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler"));
        ImGuiHelper.combo("Mode", shapeMode, new String[]{"Lines", "Circle"});
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.ruler.display"), displayMode, new String[]{AxiomI18n.get("axiom.tool.ruler.display.block_count"), AxiomI18n.get("axiom.tool.ruler.display.distance")});
        ImGuiHelper.separatorWithText("Actions");
        boolean bl = canSelectedCenter = this.minimum != null && this.maximum != null;
        if (!canSelectedCenter) {
            ImGui.beginDisabled();
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.ruler.select_center")) && canSelectedCenter) {
            Selection.clearSelection();
            int minX = Math.floorDiv(this.minimum.method_10263() + this.maximum.method_10263(), 2);
            int minY = Math.floorDiv(this.minimum.method_10264() + this.maximum.method_10264(), 2);
            int minZ = Math.floorDiv(this.minimum.method_10260() + this.maximum.method_10260(), 2);
            int maxX = (this.maximum.method_10263() - this.minimum.method_10263() & 1) == 0 ? minX : minX + 1;
            int maxY = (this.maximum.method_10264() - this.minimum.method_10264() & 1) == 0 ? minY : minY + 1;
            int maxZ = (this.maximum.method_10260() - this.minimum.method_10260() & 1) == 0 ? minZ : minZ + 1;
            Selection.addAABBWithHistory(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ), true);
            ToolManager.setToolSelected(false);
        }
        if (ImGui.button(AxiomI18n.get("axiom.tool.ruler.split")) && canSelectedCenter) {
            ImGui.openPopup("##SplitPopup");
        }
        if (!canSelectedCenter) {
            ImGui.endDisabled();
        }
        if (ImGuiHelper.beginPopup("##SplitPopup")) {
            int index;
            if (splitSegments[0] < 2) {
                RulerTool.splitSegments[0] = 2;
            }
            ImGui.setNextItemWidth(100.0f);
            ImGui.sliderInt("Segments", splitSegments, 2, 16);
            boolean canSplit = false;
            for (GizmoList line : lines) {
                index = line.getActiveGizmoIndex();
                if (index <= 0) continue;
                canSplit = true;
                break;
            }
            if (!canSplit) {
                ImGui.beginDisabled();
            }
            if (ImGui.button("Split") && canSplit) {
                for (GizmoList line : lines) {
                    index = line.getActiveGizmoIndex();
                    if (index <= 0) continue;
                    Gizmo previousGizmo = line.getGizmos().get(index - 1);
                    Gizmo selectedGizmo = line.getGizmos().get(index);
                    class_243 from = previousGizmo.getTargetVec();
                    class_243 to = selectedGizmo.getTargetVec();
                    class_243 delta = to.method_1020(from);
                    line.setActiveGizmo(index - 1);
                    int segments = Math.max(2, splitSegments[0]);
                    for (int i = 1; i < segments; ++i) {
                        float partial = (float)i / (float)segments;
                        class_243 mid = from.method_1019(delta.method_1021((double)partial));
                        line.addGizmo(mid);
                    }
                }
            }
            if (!canSplit) {
                ImGui.endDisabled();
            }
            ImGui.sameLine();
            if (ImGui.button("Cancel")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler.information"));
        NumberFormat format = NumberFormat.getInstance();
        if (this.minimum == null || this.maximum == null) {
            ImGui.beginDisabled();
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.no_information"));
            ImGui.endDisabled();
        } else {
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.total_length_euclidean", String.format("%.2f", Float.valueOf(this.totalLengthEuclidean))));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.total_length_manhattan", format.format(this.totalLengthManhattan)));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.minimum", format.format(this.minimum.method_10263()), format.format(this.minimum.method_10264()), format.format(this.minimum.method_10260())));
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.maximum", format.format(this.maximum.method_10263()), format.format(this.maximum.method_10264()), format.format(this.maximum.method_10260())));
            int boundingX = this.maximum.method_10263() - this.minimum.method_10263() + 1;
            int boundingY = this.maximum.method_10264() - this.minimum.method_10264() + 1;
            int boundingZ = this.maximum.method_10260() - this.minimum.method_10260() + 1;
            ImGui.text(AxiomI18n.get("axiom.tool.ruler.bounding_size", format.format(boundingX), format.format(boundingY), format.format(boundingZ)));
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.ruler.points"));
        if (ImGui.button("Clear (Delete)")) {
            this.clear();
        }
    }

    private void recalculate() {
        this.totalLengthEuclidean = 0.0f;
        this.totalLengthManhattan = 0;
        this.minimum = null;
        this.maximum = null;
        for (GizmoList line : lines) {
            List<Gizmo> gizmos = line.getGizmos();
            if (gizmos.isEmpty()) continue;
            for (int i = 0; i < gizmos.size() - 1; ++i) {
                class_2338 one = gizmos.get(i).getTargetPosition();
                class_2338 two = gizmos.get(i + 1).getTargetPosition();
                this.totalLengthEuclidean = (float)((double)this.totalLengthEuclidean + Math.sqrt(one.method_10262((class_2382)two)));
                this.totalLengthManhattan += one.method_19455((class_2382)two);
            }
            if (this.minimum == null) {
                this.minimum = gizmos.get(0).getTargetPosition();
            }
            if (this.maximum == null) {
                this.maximum = gizmos.get(0).getTargetPosition();
            }
            for (Gizmo gizmo : gizmos) {
                class_2338 point = gizmo.getTargetPosition();
                this.minimum = new class_2338(Math.min(this.minimum.method_10263(), point.method_10263()), Math.min(this.minimum.method_10264(), point.method_10264()), Math.min(this.minimum.method_10260(), point.method_10260()));
                this.maximum = new class_2338(Math.max(this.maximum.method_10263(), point.method_10263()), Math.max(this.maximum.method_10264(), point.method_10264()), Math.max(this.maximum.method_10260(), point.method_10260()));
            }
        }
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.ruler");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        tag.method_10569("DisplayMode", displayMode[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        RulerTool.displayMode[0] = tag.method_68083("DisplayMode", 0);
    }

    @Override
    public char iconChar() {
        return '\ue909';
    }

    @Override
    public String keybindId() {
        return "ruler";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_RULER);
    }
}

