/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.path;

import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.BlockHelper;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;

public interface PathRasterizer {
    public static int[] createOffsetArray(int radius) {
        IntArrayList offsetList = new IntArrayList();
        int radiusSq = radius * radius + radius;
        for (int xo = -radius; xo <= radius; ++xo) {
            for (int yo = -radius; yo <= radius; ++yo) {
                for (int zo = -radius; zo <= radius; ++zo) {
                    if (xo == 0 && yo == 0 && zo == 0 || xo * xo + yo * yo + zo * zo > radiusSq) continue;
                    offsetList.add(xo);
                    offsetList.add(yo);
                    offsetList.add(zo);
                }
            }
        }
        return offsetList.toIntArray();
    }

    public void rasterize(ChunkedBlockRegion var1, MaskElement var2, MaskContext var3, Vector3d var4, Vector3d var5, int var6, float var7, float var8);

    default public void finish(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext) {
    }

    public record FlatDynamicRadiusDynamicBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, float[] radii, int depth, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Vector3d leftBuffer = new Vector3d();
            Vector3d rightBuffer = new Vector3d();
            float divisions = (float)Math.ceil(from.distance((Vector3dc)to)) * 32.0f;
            class_2680 fromState = this.blocks[Math.min(this.blocks.length - 1, index)];
            class_2680 toState = this.blocks[Math.min(this.blocks.length - 1, index + 1)];
            for (int i = 0; i <= (int)divisions; ++i) {
                float newPartial;
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = this.easings[index].apply(minPartial + partialLength * f);
                float realRadius = this.radii[index] * (1.0f - partial) + this.radii[index + 1] * partial;
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    newPartial = partial * 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    newPartial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * newPartial + 1.5707964f;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                float sideX = (float)Math.sin(realAngle) * realRadius;
                float sideZ = (float)Math.cos(realAngle) * realRadius;
                leftBuffer.set(targetX - (double)sideX, targetY, targetZ - (double)sideZ);
                rightBuffer.set(targetX + (double)sideX, targetY, targetZ + (double)sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        double dz;
                        double dy;
                        double dx;
                        double realDistanceSq;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1) || !this.closestMap.min(x1, y1 - d, z1, (float)(realDistanceSq = (dx = (double)x1 + 0.5 - targetX) * dx + (dy = (double)(y1 - d) + 0.5 - targetY) * dy + (dz = (double)z1 + 0.5 - targetZ) * dz))) continue;
                        if (this.whiteNoise.evaluate(x1, y1 - d, z1) > partial) {
                            chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, fromState);
                            continue;
                        }
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, toState);
                    }
                });
            }
        }
    }

    public record FlatConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, float distance, int depth, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Vector3d leftBuffer = new Vector3d();
            Vector3d rightBuffer = new Vector3d();
            float divisions = (float)Math.ceil(from.distance((Vector3dc)to)) * 32.0f;
            class_2680 fromState = this.blocks[Math.min(this.blocks.length - 1, index)];
            class_2680 toState = this.blocks[Math.min(this.blocks.length - 1, index + 1)];
            for (int i = 0; i <= (int)divisions; ++i) {
                float newPartial;
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = this.easings[index].apply(minPartial + partialLength * f);
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    newPartial = partial * 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    newPartial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * newPartial + 1.5707964f;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                float sideX = (float)Math.sin(realAngle) * this.distance;
                float sideZ = (float)Math.cos(realAngle) * this.distance;
                leftBuffer.set(targetX - (double)sideX, targetY, targetZ - (double)sideZ);
                rightBuffer.set(targetX + (double)sideX, targetY, targetZ + (double)sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        double dz;
                        double dy;
                        double dx;
                        double realDistanceSq;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1) || !this.closestMap.min(x1, y1 - d, z1, (float)(realDistanceSq = (dx = (double)x1 + 0.5 - targetX) * dx + (dy = (double)(y1 - d) + 0.5 - targetY) * dy + (dz = (double)z1 + 0.5 - targetZ) * dz))) continue;
                        if (this.whiteNoise.evaluate(x1, y1 - d, z1) > partial) {
                            chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, fromState);
                            continue;
                        }
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, toState);
                    }
                });
            }
        }
    }

    public record FlatDynamicRadiusConstantBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, float[] radii, int depth, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Vector3d leftBuffer = new Vector3d();
            Vector3d rightBuffer = new Vector3d();
            float divisions = (float)Math.ceil(from.distance((Vector3dc)to)) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                float realRadius = this.radii[index] * (1.0f - partial) + this.radii[index + 1] * partial;
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * partial + 1.5707964f;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                float sideX = (float)Math.sin(realAngle) * realRadius;
                float sideZ = (float)Math.cos(realAngle) * realRadius;
                leftBuffer.set(targetX - (double)sideX, targetY, targetZ - (double)sideZ);
                rightBuffer.set(targetX + (double)sideX, targetY, targetZ + (double)sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, this.constantBlock);
                    }
                });
            }
        }
    }

    public record FlatConstantRadiusConstantBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, float distance, int depth, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Vector3d leftBuffer = new Vector3d();
            Vector3d rightBuffer = new Vector3d();
            float divisions = (float)Math.ceil(from.distance((Vector3dc)to)) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                if ((double)(partial = this.easings[index].apply(partial)) < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * partial + 1.5707964f;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                float sideX = (float)Math.sin(realAngle) * this.distance;
                float sideZ = (float)Math.cos(realAngle) * this.distance;
                leftBuffer.set(targetX - (double)sideX, targetY, targetZ - (double)sideZ);
                rightBuffer.set(targetX + (double)sideX, targetY, targetZ + (double)sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, this.constantBlock);
                    }
                });
            }
        }
    }

    public static final class Spike
    implements PathRasterizer {
        private final FloatUnaryOperator[] easings;
        private final float startRadius;
        private final float endRadius;
        private final class_2680[] blocks;
        private final WhiteNoise whiteNoise;
        private final Position2FloatMap closestMap;
        private final List<Vector4d> positions = new ArrayList<Vector4d>();
        private Vector4d lastPosition = new Vector4d();

        public Spike(FloatUnaryOperator[] easings, float startRadius, float endRadius, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) {
            this.easings = easings;
            this.startRadius = startRadius;
            this.endRadius = endRadius;
            this.blocks = blocks;
            this.whiteNoise = whiteNoise;
            this.closestMap = closestMap;
        }

        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            this.positions.add(new Vector4d(from.x, from.y, from.z, (double)((float)index + minPartial)));
            this.lastPosition.set(to.x, to.y, to.z, (double)((float)index + minPartial + partialLength));
        }

        @Override
        public void finish(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext) {
            this.positions.add(this.lastPosition);
            this.lastPosition = null;
            Vector3d from = new Vector3d();
            Vector3d to = new Vector3d();
            double totalDistance = 0.0;
            Vector4d last = null;
            for (Vector4d position : this.positions) {
                if (last == null) {
                    last = position;
                    continue;
                }
                from.set(last.x, last.y, last.z);
                to.set(position.x, position.y, position.z);
                totalDistance += from.distance((Vector3dc)to);
                last = position;
            }
            double currentDistance = 0.0;
            last = null;
            for (Vector4d position : this.positions) {
                if (last == null) {
                    last = position;
                    continue;
                }
                from.set(last.x, last.y, last.z);
                to.set(position.x, position.y, position.z);
                if (from.equals((Object)to)) {
                    last = position;
                    continue;
                }
                int index = (int)Math.floor(last.w);
                double minPartial = last.w - (double)index;
                double partialLength = last.w - position.w;
                float fromRadius = this.startRadius + (this.endRadius - this.startRadius) * (float)(currentDistance / totalDistance);
                float toRadius = this.startRadius + (this.endRadius - this.startRadius) * (float)((currentDistance += from.distance((Vector3dc)to)) / totalDistance);
                Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                    float partial = (float)(minPartial + partialLength * (double)f);
                    partial = this.easings[index].apply(partial);
                    class_2680 fromState = this.blocks[Math.min(this.blocks.length - 1, index)];
                    class_2680 toState = this.blocks[Math.min(this.blocks.length - 1, index + 1)];
                    float realRadius = fromRadius + (toRadius - fromRadius) * f;
                    float realRadiusSquared = realRadius * realRadius + realRadius;
                    int bigRadius = (int)realRadius + 1;
                    int bigRadiusSquared = bigRadius * bigRadius + bigRadius;
                    double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                    double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                    double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                    for (int xo = -bigRadius; xo <= bigRadius; ++xo) {
                        for (int yo = -bigRadius; yo <= bigRadius; ++yo) {
                            for (int zo = -bigRadius; zo <= bigRadius; ++zo) {
                                double dz;
                                double dy;
                                double dx;
                                double realDistanceSq;
                                if (xo == 0 && yo == 0 && zo == 0) {
                                    if (!destinationMask.test(maskContext.reset(), x, y, z)) continue;
                                    if (this.whiteNoise.evaluate(x, y, z) > partial) {
                                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fromState);
                                        continue;
                                    }
                                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, toState);
                                    continue;
                                }
                                if (xo * xo + yo * yo + zo * zo > bigRadiusSquared || !((realDistanceSq = (dx = (double)((float)(x + xo) + 0.5f) - targetX) * dx + (dy = (double)((float)(y + yo) + 0.5f) - targetY) * dy + (dz = (double)((float)(z + zo) + 0.5f) - targetZ) * dz) <= (double)realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || !this.closestMap.min(x + xo, y + yo, z + zo, (float)realDistanceSq)) continue;
                                if (this.whiteNoise.evaluate(x + xo, y + yo, z + zo) > partial) {
                                    chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, fromState);
                                    continue;
                                }
                                chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, toState);
                            }
                        }
                    }
                });
                last = position;
            }
        }
    }

    public record Custom(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, double[] accumulatedDistance, Position2FloatMap minDistance, ChunkedBlockRegion sourceRegion) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Vector3d leftBuffer = new Vector3d();
            Vector3d rightBuffer = new Vector3d();
            double distance = from.distance((Vector3dc)to);
            float divisions = (float)Math.ceil(distance) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                if ((double)(partial = this.easings[index].apply(partial)) < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                double delta = angleRight - angleLeft;
                delta %= Math.PI * 2;
                if (delta < -Math.PI) {
                    delta += Math.PI * 2;
                }
                if (delta > Math.PI) {
                    delta -= Math.PI * 2;
                }
                double realAngle = (double)angleLeft + delta * (double)partial + 1.5707963267948966;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                class_2338 min2 = this.sourceRegion.min();
                class_2338 max2 = this.sourceRegion.max();
                int sizeX = max2.method_10263() - min2.method_10263() + 1;
                int sizeY = max2.method_10264() - min2.method_10264() + 1;
                int sizeZ = max2.method_10260() - min2.method_10260() + 1;
                int currentDistance = (int)Math.round(this.accumulatedDistance[0] + distance * (double)f);
                int blockZ = min2.method_10260() + currentDistance % sizeZ;
                int halfX = (sizeX - 1) / 2;
                int halfXUp = (sizeX - 1) % 2 == 1 ? halfX + 1 : halfX;
                double sideXLeft = Math.sin(realAngle) * (double)halfX;
                double sideZLeft = Math.cos(realAngle) * (double)halfX;
                double sideXRight = Math.sin(realAngle) * (double)halfXUp;
                double sideZRight = Math.cos(realAngle) * (double)halfXUp;
                class_2470 blockStateRotation = BlockHelper.rotationFromRadians(1.5707963267948966 - realAngle);
                leftBuffer.set(targetX - sideXLeft, targetY, targetZ - sideZLeft);
                rightBuffer.set(targetX + sideXRight, targetY, targetZ + sideZRight);
                Rasterization3D.ddaPartial(leftBuffer, rightBuffer, (x1, y1, z1, amount) -> {
                    Vector3d actualPosition = leftBuffer.lerp((Vector3dc)rightBuffer, (double)amount, new Vector3d());
                    double errorDistanceSq = actualPosition.distanceSquared((double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
                    for (int y = 0; y < sizeY; ++y) {
                        int blockY;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 + y, z1) || !this.minDistance.min(x1, y1 + y, z1, (float)errorDistanceSq)) continue;
                        int blockX = min2.method_10263() + Math.round((float)(sizeX - 1) * amount);
                        class_2680 blockState = this.sourceRegion.getBlockStateOrNull(blockX, blockY = min2.method_10264() + y, blockZ);
                        if (blockState == null) {
                            chunkedBlockRegion.unsafeRemoveBlockWithoutDirty(x1, y1 + y, z1);
                            continue;
                        }
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 + y, z1, BlockHelper.rotateY(blockState, blockStateRotation));
                    }
                });
            }
            this.accumulatedDistance[0] = this.accumulatedDistance[0] + distance;
        }
    }

    public record DynamicRadiusDynamicBlock(FloatUnaryOperator[] easings, float[] radii, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                class_2680 fromState = this.blocks[Math.min(this.blocks.length - 1, index)];
                class_2680 toState = this.blocks[Math.min(this.blocks.length - 1, index + 1)];
                float realRadius = this.radii[index] * (1.0f - partial) + this.radii[index + 1] * partial;
                float realRadiusSquared = realRadius * realRadius + realRadius;
                int bigRadius = (int)realRadius + 1;
                int bigRadiusSquared = bigRadius * bigRadius + bigRadius;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                for (int xo = -bigRadius; xo <= bigRadius; ++xo) {
                    for (int yo = -bigRadius; yo <= bigRadius; ++yo) {
                        for (int zo = -bigRadius; zo <= bigRadius; ++zo) {
                            double dz;
                            double dy;
                            double dx;
                            double realDistanceSq;
                            if (xo == 0 && yo == 0 && zo == 0) {
                                if (!destinationMask.test(maskContext.reset(), x, y, z)) continue;
                                if (this.whiteNoise.evaluate(x, y, z) > partial) {
                                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fromState);
                                    continue;
                                }
                                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, toState);
                                continue;
                            }
                            if (xo * xo + yo * yo + zo * zo > bigRadiusSquared || !((realDistanceSq = (dx = (double)(x + xo) + 0.5 - targetX) * dx + (dy = (double)(y + yo) + 0.5 - targetY) * dy + (dz = (double)(z + zo) + 0.5 - targetZ) * dz) <= (double)realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || !this.closestMap.min(x + xo, y + yo, z + zo, (float)realDistanceSq)) continue;
                            if (this.whiteNoise.evaluate(x + xo, y + yo, z + zo) > partial) {
                                chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, fromState);
                                continue;
                            }
                            chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, toState);
                        }
                    }
                }
            });
        }
    }

    public record DynamicRadiusConstantBlock(FloatUnaryOperator[] easings, float[] radii, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                float realRadius = this.radii[index] * (1.0f - partial) + this.radii[index + 1] * partial;
                float realRadiusSquared = realRadius * realRadius + realRadius;
                int bigRadius = (int)realRadius + 1;
                int bigRadiusSquared = bigRadius * bigRadius + bigRadius;
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                for (int xo = -bigRadius; xo <= bigRadius; ++xo) {
                    for (int yo = -bigRadius; yo <= bigRadius; ++yo) {
                        for (int zo = -bigRadius; zo <= bigRadius; ++zo) {
                            double dz;
                            double dy;
                            double dx;
                            double realDistanceSq;
                            if (xo == 0 && yo == 0 && zo == 0) {
                                if (!destinationMask.test(maskContext.reset(), x, y, z)) continue;
                                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
                                continue;
                            }
                            if (xo * xo + yo * yo + zo * zo > bigRadiusSquared || !((realDistanceSq = (dx = (double)(x + xo) + 0.5 - targetX) * dx + (dy = (double)(y + yo) + 0.5 - targetY) * dy + (dz = (double)(z + zo) + 0.5 - targetZ) * dz) <= (double)realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo)) continue;
                            chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, this.constantBlock);
                        }
                    }
                }
            });
        }
    }

    public record ConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, int[] offsetArray, float realRadiusSquared, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        public ConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, float radius, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) {
            this(easings, PathRasterizer.createOffsetArray((int)Math.ceil(radius) + 1), radius * radius + radius, blocks, whiteNoise, closestMap);
        }

        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                class_2680 fromState = this.blocks[Math.min(this.blocks.length - 1, index)];
                class_2680 toState = this.blocks[Math.min(this.blocks.length - 1, index + 1)];
                if (destinationMask.test(maskContext.reset(), x, y, z)) {
                    if (this.whiteNoise.evaluate(x, y, z) > partial) {
                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fromState);
                    } else {
                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, toState);
                    }
                }
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                for (int i1 = 0; i1 < this.offsetArray.length; i1 += 3) {
                    int xo = this.offsetArray[i1];
                    double dx = (double)(x + xo) + 0.5 - targetX;
                    int yo = this.offsetArray[i1 + 1];
                    double dy = (double)(y + yo) + 0.5 - targetY;
                    int zo = this.offsetArray[i1 + 2];
                    double dz = (double)(z + zo) + 0.5 - targetZ;
                    double realDistanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(realDistanceSq <= (double)this.realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || !this.closestMap.min(x + xo, y + yo, z + zo, (float)realDistanceSq)) continue;
                    if (this.whiteNoise.evaluate(x + xo, y + yo, z + zo) > partial) {
                        chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, fromState);
                        continue;
                    }
                    chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, toState);
                }
            });
        }
    }

    public record ConstantRadiusConstantBlock(int[] offsetArray, float realRadiusSquared, class_2680 constantBlock) implements PathRasterizer
    {
        public ConstantRadiusConstantBlock(float radius, class_2680 constantBlock) {
            this(PathRasterizer.createOffsetArray((int)Math.ceil(radius) + 1), radius * radius + radius, constantBlock);
        }

        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                double targetX = from.x * (double)(1.0f - f) + to.x * (double)f;
                double targetY = from.y * (double)(1.0f - f) + to.y * (double)f;
                double targetZ = from.z * (double)(1.0f - f) + to.z * (double)f;
                if (destinationMask.test(maskContext.reset(), x, y, z)) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
                }
                for (int i1 = 0; i1 < this.offsetArray.length; i1 += 3) {
                    int xo = this.offsetArray[i1];
                    double dx = (double)(x + xo) + 0.5 - targetX;
                    int yo = this.offsetArray[i1 + 1];
                    double dy = (double)(y + yo) + 0.5 - targetY;
                    int zo = this.offsetArray[i1 + 2];
                    double dz = (double)(z + zo) + 0.5 - targetZ;
                    double realDistanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(realDistanceSq <= (double)this.realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo)) continue;
                    chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, this.constantBlock);
                }
            });
        }
    }

    public record ZeroRadiusDynamicBlock(FloatUnaryOperator[] easings, class_2680[] blocks, WhiteNoise whiteNoise) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                if (!destinationMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                if (this.whiteNoise.evaluate(x, y, z) > partial) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.blocks[Math.min(this.blocks.length - 1, index)]);
                } else {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.blocks[Math.min(this.blocks.length - 1, index + 1)]);
                }
            });
        }
    }

    public record ZeroRadiusConstantBlock(class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3d from, Vector3d to, int index, float minPartial, float partialLength) {
            Rasterization3D.dda(from, to, (x, y, z) -> {
                if (!destinationMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
            });
        }
    }
}

