/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modify;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.funcinterfaces.TriIntPredicate;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.scaling.RotSprite;
import com.moulberry.axiom.scaling.Scale3x;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.modify.ModifyRevolve;
import com.moulberry.axiom.tools.modify.ModifyTwist;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.utils.ProjectedText;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.utils.RenderHelper;
import imgui.ImGui;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ModifyTool
implements Tool {
    private final int[] mode = new int[]{0};
    private final int[] revolveAngle = new int[]{360};
    private final int[] axis = new int[]{1};
    private final int[] count = new int[]{1};
    private final int[] translationType = new int[]{0};
    private final int[] translationX = new int[]{1};
    private final int[] translationY = new int[]{0};
    private final int[] translationZ = new int[]{0};
    private final int[] rotationCount = new int[]{7};
    private final int[] rotationType = new int[]{0};
    private final int[] rotationX = new int[]{0};
    private final int[] rotationY = new int[]{45};
    private final int[] rotationZ = new int[]{0};
    private boolean arrayRotateAddTranslation = false;
    private final int[] arrayRotateTranslationX = new int[]{0};
    private final int[] arrayRotateTranslationY = new int[]{7};
    private final int[] arrayRotateTranslationZ = new int[]{0};
    private final int[] twistDegrees = new int[]{45};
    private final float[] twistAxis = new float[]{0.0f, 1.0f, 0.0f};

    @Override
    public void reset() {
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                int mode = this.mode[0];
                if (mode == 0) {
                    this.rightClickRevolve();
                } else if (mode == 1) {
                    this.rightClickArrayTranslate();
                } else if (mode == 2) {
                    this.rightClickArrayRotate();
                } else if (mode == 3) {
                    this.rightClickTwist();
                }
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Nullable
    private static TriIntPredicate createMaskPredicate() {
        MaskElement maskElement = MaskManager.getDestMaskWithoutDefaultSelection();
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (constantMaskElement.getConstant()) {
                return (x, y, z) -> true;
            }
            return null;
        }
        MaskContext maskContext = new MaskContext((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687));
        return (x, y, z) -> {
            maskContext.reset();
            return maskElement.test(maskContext, x, y, z);
        };
    }

    public void rightClickRevolve() {
        TriIntPredicate mask;
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer.isEmpty()) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_2338 translation = class_2338.field_10980;
        if (this.arrayRotateAddTranslation) {
            translation = new class_2338(this.arrayRotateTranslationX[0], this.arrayRotateTranslationY[0], this.arrayRotateTranslationZ[0]);
        }
        if ((mask = ModifyTool.createMaskPredicate()) == null) {
            return;
        }
        double angle = Math.toRadians(this.revolveAngle[0]);
        int axis = this.axis[0];
        ChunkedBlockRegion chunkedBlockRegion = ModifyRevolve.revolve((class_1937)level, selectionBuffer, result.blockPos(), angle, axis, translation, mask);
        if (chunkedBlockRegion.isEmpty()) {
            return;
        }
        SelectionHistoryElement historyElement = Selection.getSelectionBuffer().createHistoryElement();
        Selection.clearSelection();
        String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.modified", countString);
        RegionHelper.pushBlockRegionChange(chunkedBlockRegion, null, historyDescription, 0, historyElement);
    }

    public void rightClickArrayTranslate() {
        int deltaZ;
        int deltaY;
        int deltaX;
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        TriIntPredicate mask = ModifyTool.createMaskPredicate();
        if (mask == null) {
            return;
        }
        ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
        int count = this.count[0];
        if (this.translationType[0] == 0) {
            deltaX = this.translationX[0] * (max2.method_10263() - min2.method_10263() + 1);
            deltaY = this.translationY[0] * (max2.method_10264() - min2.method_10264() + 1);
            deltaZ = this.translationZ[0] * (max2.method_10260() - min2.method_10260() + 1);
        } else {
            deltaX = this.translationX[0];
            deltaY = this.translationY[0];
            deltaZ = this.translationZ[0];
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            int minX = aabb.min().method_10263();
            int minY = aabb.min().method_10264();
            int minZ = aabb.min().method_10260();
            int maxX = aabb.max().method_10263();
            int maxY = aabb.max().method_10264();
            int maxZ = aabb.max().method_10260();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2, z2));
                        for (int i = 1; i < count + 1; ++i) {
                            if (!mask.test(x2 + deltaX * i, y2 + deltaY * i, z2 + deltaZ * i)) continue;
                            chunkedBlockRegion.addBlockWithoutDirty(x2 + deltaX * i, y2 + deltaY * i, z2 + deltaZ * i, blockState);
                        }
                    }
                }
            }
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            set.forEach((x, y, z) -> {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                for (int i = 1; i < count + 1; ++i) {
                    if (!mask.test(x + deltaX * i, y + deltaY * i, z + deltaZ * i)) continue;
                    chunkedBlockRegion.addBlockWithoutDirty(x + deltaX * i, y + deltaY * i, z + deltaZ * i, blockState);
                }
            });
        }
        SelectionHistoryElement historyElement = Selection.getSelectionBuffer().createHistoryElement();
        Selection.move(deltaX * count, deltaY * count, deltaZ * count, false);
        String countString = NumberFormat.getInstance().format(chunkedBlockRegion.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.modified", countString);
        RegionHelper.pushBlockRegionChange(chunkedBlockRegion, null, historyDescription, 0, historyElement);
    }

    public void rightClickArrayRotate() {
        float rotationZ;
        float rotationY;
        float rotationX;
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        int offsetX = Math.floorDiv(max2.method_10263() + min2.method_10263(), 2);
        int offsetY = Math.floorDiv(max2.method_10264() + min2.method_10264(), 2);
        int offsetZ = Math.floorDiv(max2.method_10260() + min2.method_10260(), 2);
        ChunkedBlockRegion in = new ChunkedBlockRegion();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            int minX = aabb.min().method_10263();
            int minY = aabb.min().method_10264();
            int minZ = aabb.min().method_10260();
            int maxX = aabb.max().method_10263();
            int maxY = aabb.max().method_10264();
            int maxZ = aabb.max().method_10260();
            for (int x2 = minX; x2 <= maxX; ++x2) {
                for (int y2 = minY; y2 <= maxY; ++y2) {
                    for (int z2 = minZ; z2 <= maxZ; ++z2) {
                        class_2680 blockState2 = level.method_8320((class_2338)mutableBlockPos.method_10103(x2, y2, z2));
                        if (blockState2.method_26215()) continue;
                        in.addBlockWithoutDirty(x2 - offsetX, y2 - offsetY, z2 - offsetZ, blockState2);
                    }
                }
            }
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            set.forEach((x, y, z) -> {
                class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (!blockState.method_26215()) {
                    in.addBlockWithoutDirty(x - offsetX, y - offsetY, z - offsetZ, blockState);
                }
            });
        }
        ChunkedBlockRegion scaled = Scale3x.scale3x(in, false);
        int deltaX = result.blockPos().method_10263() - offsetX;
        int deltaY = result.blockPos().method_10264() - offsetY;
        int deltaZ = result.blockPos().method_10260() - offsetZ;
        ChunkedBlockRegion out = new ChunkedBlockRegion();
        int rotationCount = this.rotationCount[0];
        if (this.rotationType[0] == 0) {
            rotationX = 0.0f;
            rotationY = (float)Math.PI * 2 / (float)(rotationCount + 1);
            rotationZ = 0.0f;
        } else {
            rotationX = (float)Math.toRadians(this.rotationX[0]);
            rotationY = (float)Math.toRadians(this.rotationY[0]);
            rotationZ = (float)Math.toRadians(this.rotationZ[0]);
        }
        for (int i = 1; i <= rotationCount; ++i) {
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateYXZ(rotationY * (float)i, rotationX * (float)i, rotationZ * (float)i);
            Vector4f offset = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f);
            matrix4f.transform(offset);
            class_2338 position = new class_2338(result.blockPos().method_10263() - Math.round(offset.x), result.blockPos().method_10264() - Math.round(offset.y), result.blockPos().method_10260() - Math.round(offset.z));
            if (this.arrayRotateAddTranslation) {
                position = position.method_10069(Math.round((float)(this.arrayRotateTranslationX[0] * i) / (float)rotationCount), Math.round((float)(this.arrayRotateTranslationY[0] * i) / (float)rotationCount), Math.round((float)(this.arrayRotateTranslationZ[0] * i) / (float)rotationCount));
            }
            RotSprite.rotateCachedWithOutput(scaled, matrix4f, out, position.method_10263(), position.method_10264(), position.method_10260());
        }
        MaskElement maskElement = MaskManager.getDestMaskWithoutDefaultSelection();
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (!constantMaskElement.getConstant()) {
                return;
            }
        } else {
            MaskContext maskContext = new MaskContext((class_1937)Objects.requireNonNull(class_310.method_1551().field_1687));
            ChunkedBlockRegion checkMaskIn = out;
            ChunkedBlockRegion checkMaskOut = new ChunkedBlockRegion();
            checkMaskIn.forEachEntry((x, y, z, blockState) -> {
                if (maskElement.test(maskContext.reset(), x, y, z)) {
                    checkMaskOut.addBlockWithoutDirty(x, y, z, (class_2680)blockState);
                }
            });
            out = checkMaskOut;
        }
        SelectionHistoryElement historyElement = Selection.getSelectionBuffer().createHistoryElement();
        Selection.clearSelection();
        String countString = NumberFormat.getInstance().format(out.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.modified", countString);
        RegionHelper.pushBlockRegionChange(out, null, historyDescription, 0, historyElement);
    }

    public void rightClickTwist() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        float angleDegrees = this.twistDegrees[0];
        float axisX = this.twistAxis[0];
        float axisY = this.twistAxis[1];
        float axisZ = this.twistAxis[2];
        float invLength = 1.0f / (float)Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (!Float.isFinite(invLength)) {
            return;
        }
        axisX *= invLength;
        axisY *= invLength;
        axisZ *= invLength;
        TriIntPredicate mask = ModifyTool.createMaskPredicate();
        if (mask == null) {
            return;
        }
        ChunkedBlockRegion out = ModifyTwist.twist(angleDegrees, axisX, axisY, axisZ, mask);
        if (out == null) {
            return;
        }
        SelectionHistoryElement historyElement = Selection.getSelectionBuffer().createHistoryElement();
        Selection.clearSelection();
        String countString = NumberFormat.getInstance().format(out.count());
        String historyDescription = AxiomI18n.get("axiom.history_description.modified", countString);
        RegionHelper.pushBlockRegionChange(out, null, historyDescription, 0, historyElement);
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        Selection.render(camera, time, matrices, projection, 7);
        int mode = this.mode[0];
        if (mode == 0) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                return;
            }
            ModifyTool.renderRevolveOverlay(camera, matrices, projection, result, this.axis[0]);
        } else if (mode == 1) {
            this.renderArrayTranslateOverlay(camera, matrices, projection);
        } else if (mode == 2) {
            RayCaster.RaycastResult result = Tool.raycastBlock();
            if (result == null) {
                return;
            }
            int axis = this.rotationType[0] == 0 ? 1 : (this.rotationX[0] != 0 && this.rotationY[0] == 0 && this.rotationZ[0] == 0 ? 0 : (this.rotationX[0] == 0 && this.rotationY[0] != 0 && this.rotationZ[0] == 0 ? 1 : (this.rotationX[0] == 0 && this.rotationY[0] == 0 && this.rotationZ[0] != 0 ? 2 : -1)));
            if (axis >= 0) {
                ModifyTool.renderRevolveOverlay(camera, matrices, projection, result, axis);
            }
            this.renderArrayRotateOverlay(camera, matrices, projection, result);
        } else if (mode == 3) {
            this.renderTwistOverlay(camera, matrices, projection);
        }
    }

    private static void renderRevolveOverlay(class_4184 camera, class_4587 matrices, Matrix4f projection, RayCaster.RaycastResult result, int axis) {
        class_2338 offsetTarget = result.blockPos().method_10093(result.direction());
        class_2338 center = Selection.getSelectionBuffer().center();
        class_2338 min2 = Selection.getSelectionBuffer().min();
        class_2338 max2 = Selection.getSelectionBuffer().max();
        if (center != null && min2 != null && max2 != null) {
            class_2338 target;
            if (axis == 0) {
                int x = Math.max(min2.method_10263(), Math.min(max2.method_10263(), offsetTarget.method_10263()));
                target = new class_2338(x, result.blockPos().method_10264(), result.blockPos().method_10260());
            } else if (axis == 1) {
                int y = Math.max(min2.method_10264(), Math.min(max2.method_10264(), offsetTarget.method_10264()));
                target = new class_2338(result.blockPos().method_10263(), y, result.blockPos().method_10260());
            } else {
                int z = Math.max(min2.method_10260(), Math.min(max2.method_10260(), offsetTarget.method_10260()));
                target = new class_2338(result.blockPos().method_10263(), result.blockPos().method_10264(), z);
            }
            class_2338 furthest = PositionUtils.findFurthestPoint(min2, max2, target);
            class_2338 furthestDelta = furthest.method_10059((class_2382)target);
            class_2338 opposite = target.method_10059((class_2382)furthestDelta);
            if (axis == 0) {
                opposite = new class_2338(target.method_10263(), opposite.method_10264(), opposite.method_10260());
            } else if (axis == 1) {
                opposite = new class_2338(opposite.method_10263(), target.method_10264(), opposite.method_10260());
            } else if (axis == 2) {
                opposite = new class_2338(opposite.method_10263(), opposite.method_10264(), target.method_10260());
            }
            class_2338 closest = PositionUtils.findClosestPoint(min2, max2, target);
            matrices.method_22903();
            matrices.method_22904((double)target.method_10263() - camera.method_71156().field_1352, (double)target.method_10264() - camera.method_71156().field_1351, (double)target.method_10260() - camera.method_71156().field_1350);
            class_243 inner = class_243.method_24954((class_2382)closest.method_10059((class_2382)target));
            float innerLength = (float)inner.method_1033();
            class_243 delta = inner.method_1029();
            inner = inner.method_1031(0.5 - delta.field_1352 * 0.5, 0.5 - delta.field_1351 * 0.5, 0.5 - delta.field_1350 * 0.5);
            class_243 outer = class_243.method_24954((class_2382)opposite.method_10059((class_2382)target));
            float outerLength = (float)outer.method_1033();
            delta = outer.method_1029();
            outer = outer.method_1031(0.5 + delta.field_1352 * 0.5, 0.5 + delta.field_1351 * 0.5, 0.5 + delta.field_1350 * 0.5);
            AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
            class_4587.class_4665 pose = matrices.method_23760();
            ModifyTool.drawLine(bufferBuilder, pose, 0.5f, 0.5f, 0.5f, (float)outer.field_1352, (float)outer.field_1351, (float)outer.field_1350, true);
            ModifyTool.drawLine(bufferBuilder, pose, 0.5f, 0.5f, 0.5f, (float)inner.field_1352, (float)inner.field_1351, (float)inner.field_1350, false);
            float centerX = 0.5f;
            float centerY = 0.5f;
            float centerZ = 0.5f;
            float lastX = 0.0f;
            float lastZ = 1.0f;
            for (int i = 1; i <= 360; ++i) {
                float x = (float)Math.sin(Math.toRadians(i));
                float z = (float)Math.cos(Math.toRadians(i));
                if (axis == 0) {
                    ModifyTool.drawLine(bufferBuilder, pose, centerX, centerY + lastX * outerLength, centerZ + lastZ * outerLength, centerX, centerY + x * outerLength, centerZ + z * outerLength, true);
                    ModifyTool.drawLine(bufferBuilder, pose, centerX, centerY + lastX * innerLength, centerZ + lastZ * innerLength, centerX, centerY + x * innerLength, centerZ + z * innerLength, false);
                } else if (axis == 1) {
                    ModifyTool.drawLine(bufferBuilder, pose, centerX + lastX * outerLength, centerY, centerZ + lastZ * outerLength, centerX + x * outerLength, centerY, centerZ + z * outerLength, true);
                    ModifyTool.drawLine(bufferBuilder, pose, centerX + lastX * innerLength, centerY, centerZ + lastZ * innerLength, centerX + x * innerLength, centerY, centerZ + z * innerLength, false);
                } else if (axis == 2) {
                    ModifyTool.drawLine(bufferBuilder, pose, centerX + lastX * outerLength, centerY + lastZ * outerLength, centerZ, centerX + x * outerLength, centerY + z * outerLength, centerZ, true);
                    ModifyTool.drawLine(bufferBuilder, pose, centerX + lastX * innerLength, centerY + lastZ * innerLength, centerZ, centerX + x * innerLength, centerY + z * innerLength, centerZ, false);
                }
                lastX = x;
                lastZ = z;
            }
            AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
            ProjectedText.setupProjectedText();
            ProjectedText.renderProjectedText(String.format("%.1f", Float.valueOf(outerLength)), matrices, projection, (float)(opposite.method_10263() - target.method_10263()) / 2.0f + 0.5f, (float)(opposite.method_10264() - target.method_10264()) / 2.0f + 0.5f, (float)(opposite.method_10260() - target.method_10260()) / 2.0f + 0.5f);
            if ((double)innerLength >= 0.25) {
                ProjectedText.renderProjectedText(String.format("%.1f", Float.valueOf(innerLength)), matrices, projection, (float)(closest.method_10263() - target.method_10263()) / 2.0f + 0.5f, (float)(closest.method_10264() - target.method_10264()) / 2.0f + 0.5f, (float)(closest.method_10260() - target.method_10260()) / 2.0f + 0.5f);
            }
            ProjectedText.finishProjectedText();
            matrices.method_22909();
            if (axis == 0) {
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(result.blockPos().method_10264() - center.method_10264() + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + (result.blockPos().method_10260() - center.method_10260()))).method_27692(class_124.field_1075)));
            } else if (axis == 1) {
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(result.blockPos().method_10263() - center.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)("" + (result.blockPos().method_10260() - center.method_10260()))).method_27692(class_124.field_1075)));
            } else if (axis == 2) {
                ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Offset: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(result.blockPos().method_10263() - center.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)("" + (result.blockPos().method_10264() - center.method_10264()))).method_27692(class_124.field_1060)));
            }
        }
    }

    private void renderArrayTranslateOverlay(class_4184 camera, class_4587 matrices, Matrix4f projection) {
        int deltaZ;
        int deltaY;
        int deltaX;
        int count = this.count[0];
        if (count > 100) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        if (this.translationType[0] == 0) {
            deltaX = this.translationX[0] * (max2.method_10263() - min2.method_10263() + 1);
            deltaY = this.translationY[0] * (max2.method_10264() - min2.method_10264() + 1);
            deltaZ = this.translationZ[0] * (max2.method_10260() - min2.method_10260() + 1);
        } else {
            deltaX = this.translationX[0];
            deltaY = this.translationY[0];
            deltaZ = this.translationZ[0];
        }
        matrices.method_22903();
        matrices.method_22904((double)min2.method_10263() - camera.method_71156().field_1352, (double)min2.method_10264() - camera.method_71156().field_1351, (double)min2.method_10260() - camera.method_71156().field_1350);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        float sizeX = max2.method_10263() + 1 - min2.method_10263();
        float sizeY = max2.method_10264() + 1 - min2.method_10264();
        float sizeZ = max2.method_10260() + 1 - min2.method_10260();
        for (int i = 1; i < count + 1; ++i) {
            float red = 0.33333334f;
            float green = 1.0f;
            float blue = 1.0f;
            Shapes.lineBox(matrices, (class_4588)bufferBuilder, deltaX * i, deltaY * i, deltaZ * i, sizeX + (float)(deltaX * i), sizeY + (float)(deltaY * i), sizeZ + (float)(deltaZ * i), red, green, blue, 1.0f, red, green, blue, RenderHelper.baseLineWidth);
        }
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
        matrices.method_22909();
    }

    private void renderArrayRotateOverlay(class_4184 camera, class_4587 matrices, Matrix4f projection, RayCaster.RaycastResult result) {
        float rotationZ;
        float rotationY;
        float rotationX;
        int count = this.rotationCount[0];
        if (count > 100) {
            return;
        }
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        int offsetX = Math.floorDiv(max2.method_10263() + min2.method_10263(), 2);
        int offsetY = Math.floorDiv(max2.method_10264() + min2.method_10264(), 2);
        int offsetZ = Math.floorDiv(max2.method_10260() + min2.method_10260(), 2);
        int deltaX = result.blockPos().method_10263() - offsetX;
        int deltaY = result.blockPos().method_10264() - offsetY;
        int deltaZ = result.blockPos().method_10260() - offsetZ;
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        if (this.rotationType[0] == 0) {
            rotationX = 0.0f;
            rotationY = (float)Math.PI * 2 / (float)(count + 1);
            rotationZ = 0.0f;
        } else {
            rotationX = (float)Math.toRadians(this.rotationX[0]);
            rotationY = (float)Math.toRadians(this.rotationY[0]);
            rotationZ = (float)Math.toRadians(this.rotationZ[0]);
        }
        for (int i = 1; i <= count; ++i) {
            float red = 0.33333334f;
            float green = 1.0f;
            float blue = 1.0f;
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.rotateYXZ(rotationY * (float)i, rotationX * (float)i, rotationZ * (float)i);
            Vector4f offset = new Vector4f((float)deltaX, (float)deltaY, (float)deltaZ, 1.0f);
            matrix4f.transform(offset);
            matrices.method_22903();
            matrices.method_22904((double)(result.blockPos().method_10263() - Math.round(offset.x)) + 0.5 - camera.method_71156().field_1352, (double)(result.blockPos().method_10264() - Math.round(offset.y)) + 0.5 - camera.method_71156().field_1351, (double)(result.blockPos().method_10260() - Math.round(offset.z)) + 0.5 - camera.method_71156().field_1350);
            if (this.arrayRotateAddTranslation) {
                matrices.method_46416((float)Math.round((float)(this.arrayRotateTranslationX[0] * i) / (float)count), (float)Math.round((float)(this.arrayRotateTranslationY[0] * i) / (float)count), (float)Math.round((float)(this.arrayRotateTranslationZ[0] * i) / (float)count));
            }
            class_4587.class_4665 pose = matrices.method_23760();
            pose.method_23761().rotateYXZ(rotationY * (float)i, rotationX * (float)i, rotationZ * (float)i);
            pose.method_23762().rotateYXZ(rotationY * (float)i, rotationX * (float)i, rotationZ * (float)i);
            Shapes.lineBox(matrices, (class_4588)bufferBuilder, (float)min2.method_10263() - 0.5f - (float)offsetX, (float)min2.method_10264() - 0.5f - (float)offsetY, (float)min2.method_10260() - 0.5f - (float)offsetZ, (float)max2.method_10263() + 0.5f - (float)offsetX, (float)max2.method_10264() + 0.5f - (float)offsetY, (float)max2.method_10260() + 0.5f - (float)offsetZ, red, green, blue, 1.0f, red, green, blue, RenderHelper.baseLineWidth);
            matrices.method_22909();
        }
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
    }

    private void renderTwistOverlay(class_4184 camera, class_4587 matrices, Matrix4f projection) {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        class_2338 max2 = selectionBuffer.max();
        class_2338 min2 = selectionBuffer.min();
        if (selectionBuffer.isEmpty() || max2 == null || min2 == null) {
            return;
        }
        float angleDegrees = this.twistDegrees[0];
        float axisX = this.twistAxis[0];
        float axisY = this.twistAxis[1];
        float axisZ = this.twistAxis[2];
        float invLength = 1.0f / (float)Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        if (!Float.isFinite(invLength)) {
            return;
        }
        axisX *= invLength;
        axisY *= invLength;
        axisZ *= invLength;
        int offsetX = Math.floorDiv(max2.method_10263() + min2.method_10263(), 2);
        int offsetY = Math.floorDiv(max2.method_10264() + min2.method_10264(), 2);
        int offsetZ = Math.floorDiv(max2.method_10260() + min2.method_10260(), 2);
        float minDot = Float.MAX_VALUE;
        float maxDot = Float.MIN_VALUE;
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        int x = minX;
        while (x <= maxX + 1) {
            int y = minY;
            while (y <= maxY + 1) {
                int z = minZ;
                while (z <= maxZ + 1) {
                    float dot = (float)(x - offsetX) * axisX + (float)(y - offsetY) * axisY + (float)(z - offsetZ) * axisZ;
                    minDot = Math.min(minDot, dot);
                    maxDot = Math.max(maxDot, dot);
                    if (z == maxZ + 1) break;
                    z = maxZ + 1;
                }
                if (y == maxY + 1) break;
                y = maxY + 1;
            }
            if (x == maxX + 1) break;
            x = maxX + 1;
        }
        if ((double)(maxDot - minDot) < 1.0E-4) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904((double)offsetX - camera.method_71156().field_1352, (double)offsetY - camera.method_71156().field_1351, (double)offsetZ - camera.method_71156().field_1350);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        float red = 0.33333334f;
        float green = 1.0f;
        float blue = 1.0f;
        Matrix4f matrix = new Matrix4f();
        Vector4f vector4f = new Vector4f();
        class_4587.class_4665 pose = matrices.method_23760();
        Object[] last = new Vector3f[4];
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            Arrays.fill(last, null);
            for (int v = min2.method_30558(axis); v <= max2.method_30558(axis) + 1; ++v) {
                for (int i = 0; i < 4; ++i) {
                    int y;
                    int x2;
                    int z = switch (axis) {
                        case class_2350.class_2351.field_11048 -> {
                            x2 = v;
                            y = (i & 1) != 0 ? max2.method_10264() + 1 : min2.method_10264();
                            yield (i & 2) != 0 ? max2.method_10260() + 1 : min2.method_10260();
                        }
                        case class_2350.class_2351.field_11052 -> {
                            x2 = (i & 1) != 0 ? max2.method_10263() + 1 : min2.method_10263();
                            y = v;
                            yield (i & 2) != 0 ? max2.method_10260() + 1 : min2.method_10260();
                        }
                        case class_2350.class_2351.field_11051 -> {
                            x2 = (i & 1) != 0 ? max2.method_10263() + 1 : min2.method_10263();
                            y = (i & 2) != 0 ? max2.method_10264() + 1 : min2.method_10264();
                            yield v;
                        }
                        default -> throw new FaultyImplementationError();
                    };
                    float dot = (float)(x2 - offsetX) * axisX + (float)(y - offsetY) * axisY + (float)(z - offsetZ) * axisZ;
                    float angle = (float)Math.toRadians(angleDegrees) * (dot - minDot) / (maxDot - minDot);
                    matrix.rotation(angle, axisX, axisY, axisZ);
                    vector4f.set((double)(x2 - offsetX) - 0.5, (double)(y - offsetY) - 0.5, (double)(z - offsetZ) - 0.5, 1.0);
                    matrix.transform(vector4f);
                    float currX = vector4f.x + 0.5f;
                    float currY = vector4f.y + 0.5f;
                    float currZ = vector4f.z + 0.5f;
                    if (last[i] == null) {
                        last[i] = new Vector3f(currX, currY, currZ);
                        continue;
                    }
                    Shapes.line(bufferBuilder, pose, red, green, blue, currX, currY, currZ, ((Vector3f)last[i]).x, ((Vector3f)last[i]).y, ((Vector3f)last[i]).z);
                    last[i].set(currX, currY, currZ);
                }
            }
        }
        AxiomRenderPipelines.LINES_IGNORE_DEPTH.render(provider.build());
        matrices.method_22909();
    }

    private static void drawLine(class_287 bufferBuilder, class_4587.class_4665 pose, float fromX, float fromY, float fromZ, float toX, float toY, float toZ, boolean green) {
        Shapes.line(bufferBuilder, pose, green ? 0.1f : 1.0f, green ? 1.0f : 0.1f, 0.1f, fromX, fromY, fromZ, toX, toY, toZ);
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.combo("Mode", this.mode, new String[]{"Revolve", "Translate Copies", "Rotate Copies", "Twist"});
        String action = Keybinds.USE_TOOL.longKeyIdentifier();
        int mode = this.mode[0];
        if (mode == 0) {
            ImGui.sliderInt("Angle", this.revolveAngle, 0, 360);
            ImGuiHelper.combo("Axis", this.axis, new String[]{"X", "Y", "Z"});
            if (ImGui.checkbox("Add Translation", this.arrayRotateAddTranslation)) {
                boolean bl = this.arrayRotateAddTranslation = !this.arrayRotateAddTranslation;
            }
            if (this.arrayRotateAddTranslation) {
                ImGuiHelper.inputInt("Total X", this.arrayRotateTranslationX);
                ImGuiHelper.inputInt("Total Y", this.arrayRotateTranslationY);
                ImGuiHelper.inputInt("Total Z", this.arrayRotateTranslationZ);
            }
            if (Selection.getSelectionBuffer().isEmpty()) {
                ImGui.text("\u26a0 Missing selection");
            } else {
                ImGui.text(action + " to revolve around point");
            }
        } else if (mode == 1) {
            ImGui.sliderInt("Count", this.count, 1, 100);
            ImGuiHelper.combo("Type", this.translationType, new String[]{"Relative", "Absolute"});
            ImGuiHelper.tooltip("Relative - Offsets blocks by multiples of the selection size\nAbsolute - Offsets blocks by exact coordinates");
            String text = this.translationType[0] == 0 ? "Factor" : "Offset";
            ImGuiHelper.inputInt(text + " X", this.translationX);
            ImGuiHelper.inputInt(text + " Y", this.translationY);
            ImGuiHelper.inputInt(text + " Z", this.translationZ);
            if (Selection.getSelectionBuffer().isEmpty()) {
                ImGui.text("\u26a0 Missing selection");
            } else {
                ImGui.text(action + " to translate");
            }
        } else if (mode == 2) {
            ImGui.sliderInt("Count", this.rotationCount, 1, 100);
            ImGuiHelper.combo("Type", this.rotationType, new String[]{"Equidistant", "Custom Angle"});
            if (this.rotationType[0] == 1) {
                ImGuiHelper.inputInt("Degrees X", this.rotationX);
                ImGuiHelper.inputInt("Degrees Y", this.rotationY);
                ImGuiHelper.inputInt("Degrees Z", this.rotationZ);
            }
            if (ImGui.checkbox("Add Translation", this.arrayRotateAddTranslation)) {
                boolean bl = this.arrayRotateAddTranslation = !this.arrayRotateAddTranslation;
            }
            if (this.arrayRotateAddTranslation) {
                ImGuiHelper.inputInt("Total X", this.arrayRotateTranslationX);
                ImGuiHelper.inputInt("Total Y", this.arrayRotateTranslationY);
                ImGuiHelper.inputInt("Total Z", this.arrayRotateTranslationZ);
            }
            if (Selection.getSelectionBuffer().isEmpty()) {
                ImGui.text("\u26a0 Missing selection");
            } else {
                ImGui.text(action + " to array rotate around point");
            }
        } else if (mode == 3) {
            ImGuiHelper.inputInt("Degrees", this.twistDegrees);
            ImGuiHelper.inputFloat("Axis", this.twistAxis);
            if (Selection.getSelectionBuffer().isEmpty()) {
                ImGui.text("\u26a0 Missing selection");
            } else {
                ImGui.text(action + " to twist selection");
            }
        }
    }

    @Override
    public String name() {
        return "Modify";
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
    }

    @Override
    public char iconChar() {
        return '\ue91e';
    }

    @Override
    public String keybindId() {
        return "modify";
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_MODIFY, AxiomPermission.BUILD_SECTION);
    }
}

