/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.lasso_select;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.mask.elements.ConstantMaskElement;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.joml.Intersectiond;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4f;

public record PendingLassoSelect(byte[] data, int width, int height, int depth, boolean includeNonSolid, int mode) {
    public void handle(float[] depth, Matrix4f projection) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null) {
            return;
        }
        class_243 start = entity.method_33571();
        PositionSet blockPositions = new PositionSet();
        float[] offsetDistances = new float[this.width * this.height];
        class_2338[] raycasts = new class_2338[this.width * this.height];
        Matrix4f inverseProjection = new Matrix4f((Matrix4fc)projection);
        inverseProjection.invert();
        class_1937 level = entity.method_73183();
        MaskElement maskElement = MaskManager.getSelectionMask();
        MaskContext maskContext = new MaskContext(level);
        TriIntConsumer consumer = (x, y, z) -> {
            if (maskElement.test(maskContext.reset(), x, y, z)) {
                blockPositions.add(x, y, z);
            }
        };
        if (maskElement instanceof ConstantMaskElement) {
            ConstantMaskElement constantMaskElement = (ConstantMaskElement)maskElement;
            if (constantMaskElement.getConstant()) {
                consumer = blockPositions::add;
            } else {
                return;
            }
        }
        for (int y2 = 0; y2 < this.height; ++y2) {
            boolean inside = false;
            int countUp = 0;
            int countDown = 0;
            for (int x2 = 0; x2 < this.width; ++x2) {
                float offsetDistance;
                Vector3d raycastStart;
                RayCaster.RaycastResult raycastResult;
                float normY;
                float normX;
                class_243 forwards;
                class_243 lookDirection;
                byte value = this.data[x2 + y2 * this.width];
                if (value != -1 && (countUp += value >> 4 & 0xF) > 0 && (countDown += value & 0xF) > 0) {
                    int min2 = Math.min(countUp, countDown);
                    if ((min2 & 1) != 0) {
                        inside = !inside;
                    }
                    countUp -= min2;
                    countDown -= min2;
                }
                if (!inside && value == 0 || (lookDirection = EditorUI.getMouseLookVectorFromForwards(forwards = EditorUI.getForwardsVectorRaw(normX = (float)x2 / (float)(this.width - 1) * 2.0f - 1.0f, normY = (float)y2 / (float)(this.height - 1) * 2.0f - 1.0f))) == null) continue;
                float pixelDepth = depth[x2 + (this.height - y2 - 1) * this.width];
                Vector4f depthForwards = new Vector4f(normX, normY, pixelDepth * 2.0f - 1.0f, 1.0f);
                depthForwards.mul((Matrix4fc)inverseProjection);
                float a = depthForwards.x / depthForwards.w;
                float b = depthForwards.y / depthForwards.w;
                float c = depthForwards.z / depthForwards.w;
                float depthDistance = (float)Math.sqrt(a * a + b * b + c * c);
                float depthFar = class_310.method_1551().field_1773.method_32796();
                if (depthDistance > depthFar / 2.0f || (raycastResult = RayCaster.raycast(level, raycastStart = new Vector3d(start.field_1352 + lookDirection.field_1352 * (double)(offsetDistance = Math.max(0.0f, depthDistance - 3.0f)), start.field_1351 + lookDirection.field_1351 * (double)offsetDistance, start.field_1350 + lookDirection.field_1350 * (double)offsetDistance), new Vector3d(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350), false, Tool.defaultIncludeFluids(), this.includeNonSolid)) == null) continue;
                class_2338 blockPos = raycastResult.blockPos();
                this.handleHit(entity.method_73183(), lookDirection, raycastResult, consumer);
                offsetDistances[x2 + y2 * this.width] = offsetDistance;
                raycasts[x2 + y2 * this.width] = blockPos;
                if (y2 > 0) {
                    float upOffsetDistance = offsetDistances[x2 + (y2 - 1) * this.width];
                    float normYUp = (float)(y2 - 1) / (float)(this.height - 1) * 2.0f - 1.0f;
                    this.subdivide(entity.method_73183(), consumer, start, blockPos, raycasts[x2 + (y2 - 1) * this.width], normX, normY, normX, normYUp, Math.min(offsetDistance, upOffsetDistance));
                }
                if (x2 <= 0) continue;
                float leftOffsetDistance = offsetDistances[x2 - 1 + y2 * this.width];
                float normXLeft = (float)(x2 - 1) / (float)(this.width - 1) * 2.0f - 1.0f;
                this.subdivide(entity.method_73183(), consumer, start, blockPos, raycasts[x2 - 1 + y2 * this.width], normX, normY, normXLeft, normY, Math.min(offsetDistance, leftOffsetDistance));
            }
        }
        switch (this.mode) {
            default: {
                throw new FaultyImplementationError();
            }
            case 0: {
                Selection.clearSelection();
                Selection.addSet(blockPositions);
                break;
            }
            case 1: {
                Selection.addSet(blockPositions);
                break;
            }
            case 2: {
                Selection.subtractSet(blockPositions);
                break;
            }
            case 3: {
                Selection.intersectSet(blockPositions);
            }
        }
    }

    private void handleHit(class_1937 level, class_243 lookDirection, RayCaster.RaycastResult raycastResult, TriIntConsumer consumer) {
        if (this.depth == 1) {
            class_2338 pos = raycastResult.getBlockPos();
            consumer.accept(pos.method_10263(), pos.method_10264(), pos.method_10260());
        } else {
            double z;
            double y;
            double x;
            Vector2d result;
            Vector3d max2;
            class_243 worldPos = raycastResult.worldPos();
            Vector3d from = new Vector3d(worldPos.field_1352 - lookDirection.field_1352, worldPos.field_1351 - lookDirection.field_1351, worldPos.field_1350 - lookDirection.field_1350);
            Vector3d to = new Vector3d(worldPos.field_1352 + lookDirection.field_1352, worldPos.field_1351 + lookDirection.field_1351, worldPos.field_1350 + lookDirection.field_1350);
            class_2338 blockPos = raycastResult.blockPos();
            Vector3d min2 = new Vector3d((double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
            if (Intersectiond.intersectLineSegmentAab((Vector3dc)from, (Vector3dc)to, (Vector3dc)min2, (Vector3dc)(max2 = new Vector3d((double)blockPos.method_10263() + 1.0, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 1.0)), (Vector2d)(result = new Vector2d())) != -1) {
                x = from.x + result.x * (to.x - from.x);
                y = from.y + result.x * (to.y - from.y);
                z = from.z + result.x * (to.z - from.z);
            } else {
                x = worldPos.field_1352;
                y = worldPos.field_1351;
                z = worldPos.field_1350;
            }
            if (this.depth > 0) {
                Vector3d fromVec = new Vector3d(x + lookDirection.field_1352 * 0.01, y + lookDirection.field_1351 * 0.01, z + lookDirection.field_1350 * 0.01);
                Vector3d toVec = new Vector3d(x + lookDirection.field_1352 * (double)this.depth, y + lookDirection.field_1351 * (double)this.depth, z + lookDirection.field_1350 * (double)this.depth);
                if (this.includeNonSolid) {
                    Rasterization3D.dda(fromVec, toVec, consumer);
                } else {
                    RayCaster.ddaSkip(fromVec, toVec, level, true, consumer);
                }
            } else if (this.depth < 0) {
                Vector3d fromVec = new Vector3d(x - lookDirection.field_1352 * 0.01, y - lookDirection.field_1351 * 0.01, z - lookDirection.field_1350 * 0.01);
                Vector3d toVec = new Vector3d(x + lookDirection.field_1352 * (double)this.depth, y + lookDirection.field_1351 * (double)this.depth, z + lookDirection.field_1350 * (double)this.depth);
                RayCaster.ddaSkip(fromVec, toVec, level, false, consumer);
            }
        }
    }

    private void subdivide(class_1937 level, TriIntConsumer consumer, class_243 start, class_2338 aPos, class_2338 bPos, float aX, float aY, float bX, float bY, float offsetDistance) {
        if (aPos == null || bPos == null || aPos.equals((Object)bPos)) {
            return;
        }
        if (aX == bX && aY == bY) {
            return;
        }
        float newX = (aX + bX) / 2.0f;
        float newY = (aY + bY) / 2.0f;
        if (newX == aX && newY == aY || newX == bX && newY == bY) {
            return;
        }
        class_243 forwards = EditorUI.getForwardsVectorRaw(newX, newY);
        class_243 lookDirection = EditorUI.getMouseLookVectorFromForwards(forwards);
        if (lookDirection == null) {
            return;
        }
        Vector3d raycastStart = new Vector3d(start.field_1352 + lookDirection.field_1352 * (double)offsetDistance, start.field_1351 + lookDirection.field_1351 * (double)offsetDistance, start.field_1350 + lookDirection.field_1350 * (double)offsetDistance);
        RayCaster.RaycastResult raycastResult = RayCaster.raycast(level, raycastStart, new Vector3d(lookDirection.field_1352, lookDirection.field_1351, lookDirection.field_1350), false, Tool.defaultIncludeFluids(), this.includeNonSolid);
        if (raycastResult == null) {
            return;
        }
        class_2338 blockPos = raycastResult.blockPos();
        this.handleHit(level, lookDirection, raycastResult, consumer);
        if (blockPos.equals((Object)aPos) || blockPos.equals((Object)bPos)) {
            return;
        }
        this.subdivide(level, consumer, start, aPos, blockPos, aX, aY, newX, newY, offsetDistance);
        this.subdivide(level, consumer, start, blockPos, bPos, newX, newY, bX, bY, offsetDistance);
    }
}

