/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.annotations;

import com.moulberry.axiom.annotations.AnnotationHistoryElement;
import com.moulberry.axiom.annotations.AnnotationUpdateAction;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.annotations.data.TextAnnotationData;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.render.annotations.Annotations;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TextAnnotation
implements Annotation {
    private final TextAnnotationData data;
    private final String[] splitText;
    private final Gizmo gizmo;
    private final Quaternionf additionalRotation = new Quaternionf();

    public TextAnnotation(TextAnnotationData data) {
        this.data = data;
        this.splitText = data.text().split("\n");
        this.gizmo = new Gizmo(new class_243((Vector3fc)data.position()));
        this.gizmo.translationSnapping = 16;
        this.gizmo.enableRotation = true;
        this.gizmo.rotationSnapRadians = (float)Math.PI / 180;
    }

    @Override
    public AnnotationData getData() {
        return this.data;
    }

    @Override
    public class_4076 getMinSectionY() {
        return class_4076.method_18680((class_2374)new class_243((Vector3fc)this.data.position()));
    }

    @Override
    public class_4076 getMaxSection() {
        return class_4076.method_18680((class_2374)new class_243((Vector3fc)this.data.position()));
    }

    @Override
    @Nullable
    public Gizmo getGizmo() {
        return this.gizmo;
    }

    @Override
    public void render(UUID uuid, class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection, class_276 renderTarget) {
        float directionXRot;
        float directionYRot = switch (this.data.direction()) {
            case class_2350.field_11036 -> {
                directionXRot = -90.0f;
                yield this.data.fallbackYaw() - 180.0f;
            }
            case class_2350.field_11033 -> {
                directionXRot = 90.0f;
                yield this.data.fallbackYaw() - 180.0f;
            }
            default -> {
                directionXRot = 0.0f;
                yield this.data.direction().method_10144();
            }
        };
        Quaternionf quaternionf = new Quaternionf();
        switch (this.data.billboardMode()) {
            case 0: {
                quaternionf.rotateYXZ((float)(-Math.PI) / 180 * directionYRot, (float)Math.PI / 180 * directionXRot, 0.0f);
                break;
            }
            case 1: {
                quaternionf.rotateYXZ((float)(-Math.PI) / 180 * directionYRot, (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
                break;
            }
            case 2: {
                quaternionf.rotateYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * directionXRot, 0.0f);
                break;
            }
            default: {
                quaternionf.rotateYXZ((float)(-Math.PI) / 180 * (camera.method_19330() - 180.0f), (float)Math.PI / 180 * -camera.method_19329(), 0.0f);
            }
        }
        Gizmo.GizmoRotation gizmoRotation = this.gizmo.popRotation();
        if (gizmoRotation != null && gizmoRotation.radians() != 0.0f) {
            Quaternionf inverse = new Quaternionf((Quaternionfc)quaternionf).invert();
            quaternionf.premul((Quaternionfc)this.additionalRotation);
            quaternionf.premul((Quaternionfc)gizmoRotation.toQuaternion());
            Quaternionf previousRotation = new Quaternionf((Quaternionfc)this.additionalRotation);
            quaternionf.mul((Quaternionfc)inverse, this.additionalRotation);
            if (!Objects.equals(previousRotation, this.additionalRotation)) {
                Annotations.push(new AnnotationHistoryElement(new AnnotationUpdateAction.RotateAnnotation(uuid, previousRotation), new AnnotationUpdateAction.RotateAnnotation(uuid, new Quaternionf((Quaternionfc)this.additionalRotation))));
            }
        } else {
            quaternionf.premul((Quaternionfc)this.additionalRotation);
            Gizmo.GizmoRotation peeked = this.gizmo.peekGizmoRotation();
            if (peeked != null) {
                quaternionf.premul((Quaternionfc)peeked.toQuaternion());
            }
        }
        if (!this.gizmo.isGrabbed()) {
            this.gizmo.moveToVecInstantly(new class_243((Vector3fc)this.data.position()));
            this.additionalRotation.set((Quaternionfc)this.data.rotation());
        }
        matrices.method_22903();
        Vector3f position = this.gizmo.getInterpPosition().method_46409();
        matrices.method_22904((double)position.x - camera.method_71156().field_1352, (double)position.y - camera.method_71156().field_1351, (double)position.z - camera.method_71156().field_1350);
        matrices.method_22907((Quaternionfc)quaternionf);
        matrices.method_22905(this.data.scale() / 16.0f, -this.data.scale() / 16.0f, this.data.scale() / 16.0f);
        class_327 font = class_310.method_1551().field_1772;
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < this.splitText.length; ++i) {
            String line = this.splitText[i];
            int width = font.method_1727(line);
            Objects.requireNonNull(font);
            float f = i * 9;
            int n = this.splitText.length;
            Objects.requireNonNull(font);
            float y = f - (float)(n * 9) / 2.0f;
            font.method_27521(line, (float)(-width) / 2.0f, y, this.data.colour(), this.data.shadow(), matrices.method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33995, 0, 0xF000F0);
        }
        matrices.method_22909();
    }

    @Override
    public void sectionChanged() {
    }

    @Override
    public void close() {
    }
}

