/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.annotations;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.annotations.data.LinesOutlineAnnotationData;
import com.moulberry.axiom.annotations.data.OutlineAnnotationData;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.ShaderManager;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.utils.BooleanWrapper;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class OutlineAnnotation
implements Annotation {
    private final OutlineAnnotationData data;
    private AxiomDrawBuffer vertexBuffer = null;
    private final class_4076 minSectionPos;
    private final class_4076 maxSectionPos;
    private final class_2338 center;
    private boolean empty = false;
    private boolean fullyBuilt = false;
    private static final int SHADE_X = 178;
    private static final int SHADE_PLUS_Y = 255;
    private static final int SHADE_MINUS_Y = 153;
    private static final int SHADE_Z = 222;
    private static final int DIRECTION_MINUS_X = 1 << class_2350.field_11039.method_10146();
    private static final int DIRECTION_PLUS_X = 1 << class_2350.field_11034.method_10146();
    private static final int DIRECTION_MINUS_Y = 1 << class_2350.field_11033.method_10146();
    private static final int DIRECTION_PLUS_Y = 1 << class_2350.field_11036.method_10146();
    private static final int DIRECTION_MINUS_Z = 1 << class_2350.field_11043.method_10146();
    private static final int DIRECTION_PLUS_Z = 1 << class_2350.field_11035.method_10146();
    private static final class_2350[] DIRECTIONS = class_2350.values();

    public OutlineAnnotation(OutlineAnnotationData data) {
        this.data = data;
        IntWrapper minSectionX = new IntWrapper(Integer.MAX_VALUE);
        IntWrapper minSectionY = new IntWrapper(Integer.MAX_VALUE);
        IntWrapper minSectionZ = new IntWrapper(Integer.MAX_VALUE);
        IntWrapper maxSectionX = new IntWrapper(Integer.MIN_VALUE);
        IntWrapper maxSectionY = new IntWrapper(Integer.MIN_VALUE);
        IntWrapper maxSectionZ = new IntWrapper(Integer.MIN_VALUE);
        this.data.iteratePositions((x, y, z) -> {
            minSectionX.value = Math.min(minSectionX.value, x >> 4);
            minSectionY.value = Math.min(minSectionY.value, y >> 4);
            minSectionZ.value = Math.min(minSectionZ.value, z >> 4);
            maxSectionX.value = Math.max(maxSectionX.value, x >> 4);
            maxSectionY.value = Math.max(maxSectionY.value, y >> 4);
            maxSectionZ.value = Math.max(maxSectionZ.value, z >> 4);
        });
        this.minSectionPos = class_4076.method_18676((int)minSectionX.value, (int)minSectionY.value, (int)minSectionZ.value);
        this.maxSectionPos = class_4076.method_18676((int)maxSectionX.value, (int)maxSectionY.value, (int)maxSectionZ.value);
        this.center = new class_2338(minSectionX.value * 8 + maxSectionX.value * 8 + 8, minSectionY.value * 8 + maxSectionY.value * 8 + 8, minSectionZ.value * 8 + maxSectionZ.value * 8 + 8);
    }

    @Override
    public AnnotationData getData() {
        return this.data;
    }

    @Override
    public class_4076 getMinSectionY() {
        return this.minSectionPos;
    }

    @Override
    public class_4076 getMaxSection() {
        return this.maxSectionPos;
    }

    @Override
    @Nullable
    public Gizmo getGizmo() {
        return null;
    }

    @Override
    public boolean renderPost() {
        return true;
    }

    @Override
    public void render(UUID uuid, class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection, class_276 renderTarget) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || this.empty) {
            return;
        }
        if (this.vertexBuffer == null) {
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1576);
            this.fullyBuilt = OutlineAnnotation.build(level, bufferBuilder, this.data, this.center.method_35830(-1));
            class_9801 meshData = bufferBuilder.method_60794();
            if (meshData == null) {
                this.empty = true;
                return;
            }
            this.vertexBuffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
            this.vertexBuffer.upload(meshData);
        }
        matrices.method_22903();
        matrices.method_22904((double)this.center.method_10263() - camera.method_71156().field_1352, (double)this.center.method_10264() - camera.method_71156().field_1351, (double)this.center.method_10260() - camera.method_71156().field_1350);
        RenderHelper.pushModelViewMatrix(matrices.method_23760().method_23761());
        int colour = this.data.getColour();
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        AxiomRenderer.setShaderColour(red, green, blue, 1.0f);
        class_276 selectionTarget = ShaderManager.getSelectionOutlineTarget(true);
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.OUTLINE_WITH_DEPTH, selectionTarget, this.vertexBuffer);
        AxiomRenderer.setShaderColour(red, green, blue, 0.25f);
        AxiomRenderPipelines.POSITION_COLOR_POLYGON_OFFSET.render(renderTarget, this.vertexBuffer);
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.popModelViewStack();
        matrices.method_22909();
    }

    public static void drawStatic(class_4184 camera, class_638 level, class_4587 matrices, Matrix4f projection, OutlineAnnotationData data) {
        class_2338 center = camera.method_19328();
        matrices.method_22903();
        matrices.method_22904((double)center.method_10263() - camera.method_71156().field_1352, (double)center.method_10264() - camera.method_71156().field_1351, (double)center.method_10260() - camera.method_71156().field_1350);
        RenderHelper.pushModelViewMatrix(matrices.method_23760().method_23761());
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, class_290.field_1576);
        OutlineAnnotation.build(level, bufferBuilder, data, center.method_35830(-1));
        class_9801 meshData = bufferBuilder.method_60794();
        if (meshData != null) {
            int colour = data.getColour();
            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
            float blue = (float)(colour & 0xFF) / 255.0f;
            AxiomRenderer.setShaderColour(red, green, blue, 1.0f);
            class_276 selectionTarget = ShaderManager.getSelectionOutlineTarget(true);
            AxiomRenderer.renderPipeline(AxiomRenderPipelines.OUTLINE_WITH_DEPTH, selectionTarget, meshData, false);
            AxiomRenderer.setShaderColour(red, green, blue, 0.25f);
            AxiomRenderPipelines.POSITION_COLOR_POLYGON_OFFSET.render(meshData);
            AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
        }
        RenderHelper.popModelViewStack();
        matrices.method_22909();
    }

    private static void buildBox(class_287 bufferBuilder, int allowedDirections, float x1, float y1, float z1, float x2, float y2, float z2) {
        if ((allowedDirections & DIRECTION_MINUS_X) != 0) {
            bufferBuilder.method_22912(x1, y1, z1).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x1, y1, z2).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x1, y2, z2).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x1, y2, z1).method_1336(178, 178, 178, 255);
        }
        if ((allowedDirections & DIRECTION_PLUS_X) != 0) {
            bufferBuilder.method_22912(x2, y2, z1).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x2, y2, z2).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x2, y1, z2).method_1336(178, 178, 178, 255);
            bufferBuilder.method_22912(x2, y1, z1).method_1336(178, 178, 178, 255);
        }
        if ((allowedDirections & DIRECTION_PLUS_Y) != 0) {
            bufferBuilder.method_22912(x1, y2, z1).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(x1, y2, z2).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(x2, y2, z2).method_1336(255, 255, 255, 255);
            bufferBuilder.method_22912(x2, y2, z1).method_1336(255, 255, 255, 255);
        }
        if ((allowedDirections & DIRECTION_MINUS_Y) != 0) {
            bufferBuilder.method_22912(x2, y1, z1).method_1336(153, 153, 153, 255);
            bufferBuilder.method_22912(x2, y1, z2).method_1336(153, 153, 153, 255);
            bufferBuilder.method_22912(x1, y1, z2).method_1336(153, 153, 153, 255);
            bufferBuilder.method_22912(x1, y1, z1).method_1336(153, 153, 153, 255);
        }
        if ((allowedDirections & DIRECTION_PLUS_Z) != 0) {
            bufferBuilder.method_22912(x1, y1, z2).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x2, y1, z2).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x2, y2, z2).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x1, y2, z2).method_1336(222, 222, 222, 255);
        }
        if ((allowedDirections & DIRECTION_MINUS_Z) != 0) {
            bufferBuilder.method_22912(x1, y2, z1).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x2, y2, z1).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x2, y1, z1).method_1336(222, 222, 222, 255);
            bufferBuilder.method_22912(x1, y1, z1).method_1336(222, 222, 222, 255);
        }
    }

    private static boolean build(class_638 level, class_287 bufferBuilder, OutlineAnnotationData data, class_2338 offset) {
        BooleanWrapper fullyBuilt = new BooleanWrapper(true);
        class_2338.class_2339 position = new class_2338.class_2339();
        class_2338.class_2339 neighborPosition = new class_2338.class_2339();
        BoxConsumer boxConsumer = new BoxConsumer();
        boxConsumer.bufferBuilder = bufferBuilder;
        boxConsumer.offsetX = offset.method_10263();
        boxConsumer.offsetY = offset.method_10264();
        boxConsumer.offsetZ = offset.method_10260();
        ArrayList lastPositions = new ArrayList();
        PositionSet visited = new PositionSet();
        boolean allowAir = data instanceof LinesOutlineAnnotationData;
        data.iteratePositions((x, y, z) -> {
            class_265 newVoxelShape;
            class_2680 newBlockState;
            BlockPosWithState newState = new BlockPosWithState(x, y, z, newBlockState, newVoxelShape, (newVoxelShape = (newBlockState = level.method_8320((class_2338)position.method_10103(x, y, z))).method_26218((class_1922)level, (class_2338)position)).method_1110() || newVoxelShape == class_259.method_1073() || newBlockState.method_26217() == class_2464.field_11455);
            if (lastPositions.isEmpty()) {
                lastPositions.add(newState);
            } else if (lastPositions.size() == 1) {
                BlockPosWithState last = (BlockPosWithState)lastPositions.get(0);
                if (last.blockState.method_26204() == class_2246.field_10243) {
                    fullyBuilt.value = false;
                }
                if (visited.add(last.x, last.y, last.z)) {
                    class_2350 nextDirection;
                    if (last.isEmptyVoxelShape) {
                        nextDirection = PositionUtils.directionFromDelta(x - last.x, y - last.y, z - last.z);
                    } else {
                        class_2350 class_23502 = nextDirection = allowAir && newState.isEmptyVoxelShape ? PositionUtils.directionFromDelta(x - last.x, y - last.y, z - last.z) : null;
                    }
                    if (allowAir || !last.blockState.method_26215()) {
                        last.renderBlockFace(level, position, neighborPosition, boxConsumer, null, nextDirection);
                    }
                }
                lastPositions.add(newState);
            } else {
                BlockPosWithState lastLast = (BlockPosWithState)lastPositions.get(0);
                BlockPosWithState last = (BlockPosWithState)lastPositions.get(1);
                lastPositions.remove(0);
                lastPositions.add(newState);
                if (last.blockState.method_26204() == class_2246.field_10243) {
                    fullyBuilt.value = false;
                    return;
                }
                if (visited.add(last.x, last.y, last.z)) {
                    class_2350 nextDirection;
                    class_2350 lastDirection;
                    if (last.isEmptyVoxelShape) {
                        lastDirection = PositionUtils.directionFromDelta(lastLast.x - last.x, lastLast.y - last.y, lastLast.z - last.z);
                        nextDirection = PositionUtils.directionFromDelta(x - last.x, y - last.y, z - last.z);
                    } else {
                        lastDirection = allowAir && lastLast.isEmptyVoxelShape ? PositionUtils.directionFromDelta(lastLast.x - last.x, lastLast.y - last.y, lastLast.z - last.z) : null;
                        class_2350 class_23503 = nextDirection = allowAir && newState.isEmptyVoxelShape ? PositionUtils.directionFromDelta(x - last.x, y - last.y, z - last.z) : null;
                    }
                    if (allowAir || !last.blockState.method_26215()) {
                        last.renderBlockFace(level, position, neighborPosition, boxConsumer, lastDirection, nextDirection);
                    }
                }
            }
        });
        if (lastPositions.size() == 1) {
            BlockPosWithState last = (BlockPosWithState)lastPositions.get(0);
            if (last.blockState.method_26204() == class_2246.field_10243) {
                fullyBuilt.value = false;
            }
            if (visited.add(last.x, last.y, last.z) && (allowAir || !last.blockState.method_26215())) {
                last.renderBlockFace(level, position, neighborPosition, boxConsumer, null, null);
            }
        } else if (lastPositions.size() == 2) {
            BlockPosWithState lastLast = (BlockPosWithState)lastPositions.get(0);
            BlockPosWithState last = (BlockPosWithState)lastPositions.get(1);
            if (last.blockState.method_26204() == class_2246.field_10243) {
                fullyBuilt.value = false;
            }
            if (visited.add(last.x, last.y, last.z)) {
                class_2350 lastDirection;
                if (last.isEmptyVoxelShape) {
                    lastDirection = PositionUtils.directionFromDelta(lastLast.x - last.x, lastLast.y - last.y, lastLast.z - last.z);
                } else {
                    class_2350 class_23502 = lastDirection = allowAir && lastLast.isEmptyVoxelShape ? PositionUtils.directionFromDelta(lastLast.x - last.x, lastLast.y - last.y, lastLast.z - last.z) : null;
                }
                if (allowAir || !last.blockState.method_26215()) {
                    last.renderBlockFace(level, position, neighborPosition, boxConsumer, lastDirection, null);
                }
            }
        }
        return fullyBuilt.value;
    }

    @Override
    public void sectionChanged() {
        if (!this.fullyBuilt) {
            this.empty = false;
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }

    private static class BoxConsumer
    implements class_259.class_260 {
        public class_287 bufferBuilder;
        public int x;
        public int y;
        public int z;
        public int offsetX;
        public int offsetY;
        public int offsetZ;
        public int allowedDirections = 0;

        private BoxConsumer() {
        }

        public void consume(double x1, double y1, double z1, double x2, double y2, double z2) {
            if (x1 != 0.0) {
                this.allowedDirections |= DIRECTION_MINUS_X;
            }
            if (x2 != 1.0) {
                this.allowedDirections |= DIRECTION_PLUS_X;
            }
            if (y1 != 0.0) {
                this.allowedDirections |= DIRECTION_MINUS_Y;
            }
            if (y2 != 1.0) {
                this.allowedDirections |= DIRECTION_PLUS_Y;
            }
            if (z1 != 0.0) {
                this.allowedDirections |= DIRECTION_MINUS_Z;
            }
            if (z2 != 1.0) {
                this.allowedDirections |= DIRECTION_PLUS_Z;
            }
            int x = this.x + this.offsetX;
            int y = this.y + this.offsetY;
            int z = this.z + this.offsetZ;
            OutlineAnnotation.buildBox(this.bufferBuilder, this.allowedDirections, (float)x + (float)x1, (float)y + (float)y1, (float)z + (float)z1, (float)x + (float)x2, (float)y + (float)y2, (float)z + (float)z2);
        }
    }

    private record BlockPosWithState(int x, int y, int z, class_2680 blockState, class_265 shape, boolean isEmptyVoxelShape) {
        private void renderBlockFace(class_638 level, class_2338.class_2339 position, class_2338.class_2339 neighborPosition, BoxConsumer boxConsumer, class_2350 lastDirection, class_2350 nextDirection) {
            if (this.isEmptyVoxelShape) {
                boxConsumer.allowedDirections = 63;
                if (lastDirection != null) {
                    boxConsumer.allowedDirections &= ~(1 << lastDirection.method_10146());
                }
                if (nextDirection != null) {
                    boxConsumer.allowedDirections &= ~(1 << nextDirection.method_10146());
                }
                boxConsumer.x = this.x;
                boxConsumer.y = this.y;
                boxConsumer.z = this.z;
                class_259.method_1077().method_1089((class_259.class_260)boxConsumer);
            } else {
                boxConsumer.allowedDirections = 0;
                position.method_10103(this.x, this.y, this.z);
                for (class_2350 direction : DIRECTIONS) {
                    neighborPosition.method_25505((class_2382)position, direction);
                    if (direction == lastDirection || direction == nextDirection || !VersionUtils.shouldRenderFace(this.blockState, (class_1922)level, (class_2338)position, direction, (class_2338)neighborPosition)) continue;
                    boxConsumer.allowedDirections |= 1 << direction.method_10146();
                }
                if (boxConsumer.allowedDirections != 0) {
                    boxConsumer.x = this.x;
                    boxConsumer.y = this.y;
                    boxConsumer.z = this.z;
                    this.shape.method_1089((class_259.class_260)boxConsumer);
                }
            }
        }
    }
}

