/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.annotations;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.annotations.data.AnnotationData;
import com.moulberry.axiom.annotations.data.LineAnnotationData;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.annotations.Annotation;
import com.moulberry.axiom.tools.annotation.AnnotationByteOffset;
import com.moulberry.axiom.utils.RenderHelper;
import it.unimi.dsi.fastutil.bytes.ByteImmutableList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class LineAnnotation
implements Annotation {
    private static final int SMOOTH_COUNT = 9;
    private final LineAnnotationData data;
    private float lastLineWidth = 0.0f;
    @Nullable
    private AxiomDrawBuffer vertexBuffer = null;
    private final class_4076 minSectionPos;
    private final class_4076 maxSectionPos;
    private boolean empty = false;

    public LineAnnotation(LineAnnotationData data) {
        this.data = data;
        int quantizedX = data.startQuantized().method_10263();
        int quantizedY = data.startQuantized().method_10264();
        int quantizedZ = data.startQuantized().method_10260();
        int minSectionX = quantizedX >> 8;
        int minSectionY = quantizedY >> 8;
        int minSectionZ = quantizedZ >> 8;
        int maxSectionX = quantizedX >> 8;
        int maxSectionY = quantizedY >> 8;
        int maxSectionZ = quantizedZ >> 8;
        for (int i = 0; i < data.offsets().length; ++i) {
            byte offsetId = data.offsets()[i];
            AnnotationByteOffset offset = AnnotationByteOffset.idToOffset(offsetId);
            minSectionX = Math.min(minSectionX, (quantizedX += offset.dx()) >> 8);
            minSectionY = Math.min(minSectionY, (quantizedY += offset.dy()) >> 8);
            minSectionZ = Math.min(minSectionZ, (quantizedZ += offset.dz()) >> 8);
            maxSectionX = Math.max(maxSectionX, quantizedX >> 8);
            maxSectionY = Math.max(maxSectionY, quantizedY >> 8);
            maxSectionZ = Math.max(maxSectionZ, quantizedZ >> 8);
        }
        this.minSectionPos = class_4076.method_18676((int)minSectionX, (int)minSectionY, (int)minSectionZ);
        this.maxSectionPos = class_4076.method_18676((int)maxSectionX, (int)maxSectionY, (int)maxSectionZ);
    }

    @Override
    public AnnotationData getData() {
        return this.data;
    }

    @Override
    public class_4076 getMinSectionY() {
        return this.minSectionPos;
    }

    @Override
    public class_4076 getMaxSection() {
        return this.maxSectionPos;
    }

    @Override
    @Nullable
    public Gizmo getGizmo() {
        return null;
    }

    @Override
    public void render(UUID uuid, class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection, class_276 renderTarget) {
        this.drawPoints(camera, matrices, projection, renderTarget);
    }

    private void drawPoints(class_4184 camera, class_4587 matrices, Matrix4f projection, class_276 renderTarget) {
        if (this.data.startQuantized() == null || this.data.offsets().length == 0 || this.empty) {
            return;
        }
        class_243 start = class_243.method_24954((class_2382)this.data.startQuantized()).method_1021(0.0625);
        float lineWidth = RenderHelper.baseLineWidth * this.data.lineWidth() / 2.0f;
        if (this.vertexBuffer == null || this.lastLineWidth != lineWidth) {
            this.lastLineWidth = lineWidth;
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
            LineAnnotation.build(camera.method_71156().method_1020(start), bufferBuilder, (ByteList)new ByteImmutableList(this.data.offsets()), this.data.colour(), lineWidth);
            class_9801 meshData = bufferBuilder.method_60794();
            if (meshData == null) {
                this.empty = true;
                return;
            }
            this.vertexBuffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
            this.vertexBuffer.upload(meshData);
        }
        matrices.method_22903();
        matrices.method_22904(start.field_1352 - camera.method_71156().field_1352, start.field_1351 - camera.method_71156().field_1351, start.field_1350 - camera.method_71156().field_1350);
        AxiomRenderer.setLineWidthLegacy(lineWidth);
        RenderHelper.pushModelViewMatrix(matrices.method_23760().method_23761());
        AxiomRenderPipelines.LINE_ANNOTATION_PIPELINE.render(renderTarget, this.vertexBuffer);
        RenderHelper.popModelViewStack();
        matrices.method_22909();
    }

    public static void drawStatic(class_243 cameraPosition, class_4587 matrices, Matrix4f projection, class_2382 startQuantized, ByteList offsets, float lineWidth, int colour) {
        if (startQuantized == null || offsets.isEmpty()) {
            return;
        }
        float actualLineWidth = RenderHelper.baseLineWidth * lineWidth / 2.0f;
        class_243 start = class_243.method_24954((class_2382)startQuantized).method_1021(0.0625);
        matrices.method_22903();
        matrices.method_22904(start.field_1352 - cameraPosition.field_1352, start.field_1351 - cameraPosition.field_1351, start.field_1350 - cameraPosition.field_1350);
        VertexConsumerProvider provider = VertexConsumerProvider.shared();
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27377, class_290.field_63455);
        LineAnnotation.build(cameraPosition.method_1020(start), bufferBuilder, offsets, colour, actualLineWidth);
        class_9801 meshData = bufferBuilder.method_60794();
        if (meshData != null) {
            AxiomRenderer.setLineWidthLegacy(actualLineWidth);
            RenderHelper.pushModelViewMatrix(matrices.method_23760().method_23761());
            AxiomRenderPipelines.LINE_ANNOTATION_PIPELINE.render(meshData);
            RenderHelper.popModelViewStack();
        }
        matrices.method_22909();
    }

    private static void build(class_243 cameraPosition, class_287 bufferBuilder, ByteList offsets, int colour, float lineWidth) {
        ArrayList<class_243> rawPositions = new ArrayList<class_243>(9);
        class_2338.class_2339 quantizedPosition = new class_2338.class_2339();
        Vector3f lastPosition = null;
        class_2350.class_2351 axis = null;
        int sumOffsetX = 0;
        int sumOffsetY = 0;
        int sumOffsetZ = 0;
        int sumOffsetLength = 0;
        float levelOfDetail = 1.0f;
        for (int i = 0; i < offsets.size(); ++i) {
            byte offsetId = offsets.getByte(i);
            AnnotationByteOffset offset = AnnotationByteOffset.idToOffset(offsetId);
            int offsetX = offset.dx();
            int offsetY = offset.dy();
            int offsetZ = offset.dz();
            int length = Math.abs(offsetX) + Math.abs(offsetY) + Math.abs(offsetZ);
            sumOffsetX += offsetX;
            sumOffsetY += offsetY;
            sumOffsetZ += offsetZ;
            if ((float)(sumOffsetLength += length) < levelOfDetail && i < offsets.size() - 1) continue;
            offsetX = sumOffsetX;
            offsetY = sumOffsetY;
            offsetZ = sumOffsetZ;
            length = (int)Math.max(1.0, (double)sumOffsetLength / Math.ceil(levelOfDetail));
            sumOffsetX = 0;
            sumOffsetY = 0;
            sumOffsetZ = 0;
            sumOffsetLength = 0;
            if (axis == null || axis != offset.axis()) {
                while (!rawPositions.isEmpty()) {
                    rawPositions.remove(0);
                    if (rawPositions.isEmpty()) continue;
                    lastPosition = LineAnnotation.drawSegment(rawPositions, lastPosition, bufferBuilder, colour, lineWidth, levelOfDetail);
                }
            }
            axis = offset.axis();
            for (int j = 1; j <= length; ++j) {
                float amount = (float)j / (float)length;
                class_243 partialOffset = new class_243((double)((float)quantizedPosition.method_10263() + (float)offsetX * amount), (double)((float)quantizedPosition.method_10264() + (float)offsetY * amount), (double)((float)quantizedPosition.method_10260() + (float)offsetZ * amount));
                if (rawPositions.size() < 9) {
                    rawPositions.add(partialOffset);
                } else {
                    rawPositions.remove(0);
                    rawPositions.add(partialOffset);
                }
                lastPosition = LineAnnotation.drawSegment(rawPositions, lastPosition, bufferBuilder, colour, lineWidth, levelOfDetail);
            }
            int x = quantizedPosition.method_10263() + offsetX;
            int y = quantizedPosition.method_10264() + offsetY;
            int z = quantizedPosition.method_10260() + offsetZ;
            quantizedPosition.method_10103(x, y, z);
            if (lastPosition == null || cameraPosition == null) continue;
            double distanceSq = cameraPosition.method_1028((double)lastPosition.x, (double)lastPosition.y, (double)lastPosition.z);
            double distance = Math.sqrt(distanceSq);
            levelOfDetail = (float)Math.max(1.0, distance) / 32.0f;
        }
        while (!rawPositions.isEmpty()) {
            rawPositions.remove(0);
            if (rawPositions.isEmpty()) continue;
            lastPosition = LineAnnotation.drawSegment(rawPositions, lastPosition, bufferBuilder, colour, lineWidth, levelOfDetail);
        }
    }

    private static Vector3f drawSegment(List<class_243> quantizedPositions, Vector3f lastPosition, class_287 bufferBuilder, int colour, float lineWidth, float levelOfDetail) {
        if (quantizedPositions.isEmpty()) {
            return lastPosition;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int sumCount = 0;
        for (int j = 0; j < quantizedPositions.size(); ++j) {
            class_243 pos = quantizedPositions.get(j);
            sumX += pos.field_1352;
            sumY += pos.field_1351;
            sumZ += pos.field_1350;
            ++sumCount;
        }
        float smoothedX = (float)(sumX / (double)((float)sumCount * 16.0f));
        float smoothedY = (float)(sumY / (double)((float)sumCount * 16.0f));
        float smoothedZ = (float)(sumZ / (double)((float)sumCount * 16.0f));
        if (lastPosition == null) {
            return new Vector3f(smoothedX, smoothedY, smoothedZ);
        }
        float dx = smoothedX - lastPosition.x();
        float dy = smoothedY - lastPosition.y();
        float dz = smoothedZ - lastPosition.z();
        float distanceInv = 1.0f / (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx *= distanceInv;
        dy *= distanceInv;
        dz *= distanceInv;
        if (levelOfDetail > 0.5f) {
            bufferBuilder.method_22912(lastPosition.x() - levelOfDetail * dx / 16.0f, lastPosition.y() - levelOfDetail * dy / 16.0f, lastPosition.z() - levelOfDetail * dz / 16.0f).method_39415(colour).method_22914(dx, dy, dz).method_75298(lineWidth);
            bufferBuilder.method_22912(smoothedX + levelOfDetail * dx / 16.0f, smoothedY + levelOfDetail * dy / 16.0f, smoothedZ + levelOfDetail * dz / 16.0f).method_39415(colour).method_22914(dx, dy, dz).method_75298(lineWidth);
        } else {
            bufferBuilder.method_22912(lastPosition.x(), lastPosition.y(), lastPosition.z()).method_39415(colour).method_22914(dx, dy, dz).method_75298(lineWidth);
            bufferBuilder.method_22912(smoothedX, smoothedY, smoothedZ).method_39415(colour).method_22914(dx, dy, dz).method_75298(lineWidth);
        }
        lastPosition.x = smoothedX;
        lastPosition.y = smoothedY;
        lastPosition.z = smoothedZ;
        return lastPosition;
    }

    @Override
    public void sectionChanged() {
        this.close();
    }

    @Override
    public void close() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

