/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.FramebufferUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11515;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_276;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_776;
import net.minecraft.class_777;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum CollisionMeshOverlayRenderer {
    INSTANCE;

    private final Long2ObjectMap<AxiomDrawBuffer> chunkDataMap = new Long2ObjectOpenHashMap();
    private final LongSet tickDirtyChunkSet = new LongOpenHashSet();
    private final LongSet forgetChunkSet = new LongOpenHashSet();
    private boolean clearChunkData = false;
    private class_276 renderTarget;
    private static final int QUEUE_SIZE = 16;
    private final LongSet buildingChunkList = new LongOpenHashSet();
    private final LongSet ignoreBuiltChunkSet = new LongOpenHashSet();
    private final ArrayBlockingQueue<BuildTask> buildTasks = new ArrayBlockingQueue(16);
    private final ArrayBlockingQueue<BuildResult> buildResults = new ArrayBlockingQueue(16);
    private final AtomicBoolean startedMesherThread = new AtomicBoolean(false);
    private static final Object2BooleanMap<class_2680> SHOULD_RENDER_COLLISION_MESH;

    private void startCollisionMesherIfNeeded() {
        if (this.startedMesherThread.compareAndSet(false, true)) {
            Thread thread = new Thread(() -> {
                try {
                    while (true) {
                        BuildTask task = CollisionMeshOverlayRenderer.INSTANCE.buildTasks.take();
                        VertexConsumerProvider bufferBuilder = VertexConsumerProvider.owned(256);
                        CollisionMeshOverlayRenderer.renderChunk(task.sections, task.chunkX, task.chunkZ, task.minY, bufferBuilder);
                        CollisionMeshOverlayRenderer.INSTANCE.buildResults.put(new BuildResult(bufferBuilder, task.chunkX, task.chunkZ));
                    }
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                    return;
                }
            });
            thread.setName("Axiom Collision Mesher");
            thread.start();
        }
    }

    public void render(class_4587 poseStack, Matrix4f projection, class_4184 camera) {
        class_638 level;
        if (this.clearChunkData) {
            BuildResult buildResult;
            BuildTask buildTask;
            this.clearChunkData = false;
            this.chunkDataMap.values().forEach(AxiomDrawBuffer::close);
            this.chunkDataMap.clear();
            while ((buildTask = this.buildTasks.poll()) != null) {
                this.buildingChunkList.remove(class_1923.method_8331((int)buildTask.chunkX, (int)buildTask.chunkZ));
            }
            while ((buildResult = this.buildResults.poll()) != null) {
                this.buildingChunkList.remove(class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ));
                buildResult.bufferBuilder.close();
            }
            this.ignoreBuiltChunkSet.addAll((LongCollection)this.buildingChunkList);
            this.buildingChunkList.clear();
        }
        if ((level = class_310.method_1551().field_1687) == null) {
            return;
        }
        if (!Axiom.configuration.blockAttributes.showCollisionMesh) {
            return;
        }
        this.uploadDirty();
        float offsetY = level.method_31607();
        int mainWidth = class_310.method_1551().method_1522().field_1482;
        int mainHeight = class_310.method_1551().method_1522().field_1481;
        this.renderTarget = FramebufferUtils.resizeOrCreateFramebuffer(this.renderTarget, mainWidth, mainHeight);
        FramebufferUtils.clear(this.renderTarget, 0);
        FramebufferUtils.copyDepth(class_310.method_1551().method_1522(), this.renderTarget);
        poseStack.method_22903();
        poseStack.method_22904(-camera.method_71156().field_1352, -camera.method_71156().field_1351, -camera.method_71156().field_1350);
        ArrayList<AxiomDraw> axiomDraws = new ArrayList<AxiomDraw>();
        Matrix4f modelViewMatrix = poseStack.method_23760().method_23761();
        for (Long2ObjectMap.Entry entry : this.chunkDataMap.long2ObjectEntrySet()) {
            Matrix4f translated = new Matrix4f((Matrix4fc)modelViewMatrix);
            int offsetX = class_1923.method_8325((long)entry.getLongKey()) * 16;
            int offsetZ = class_1923.method_8332((long)entry.getLongKey()) * 16;
            translated.translate((float)offsetX, offsetY, (float)offsetZ);
            axiomDraws.add(new AxiomDraw((AxiomDrawBuffer)entry.getValue(), translated, null, null));
        }
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.COLLISION_MESH_OVERLAY_PIPELINE, this.renderTarget, axiomDraws);
        poseStack.method_22909();
        FramebufferUtils.blitToMainBlend(this.renderTarget, mainWidth, mainHeight);
    }

    public void uploadDirty() {
        BuildResult buildResult;
        AxiomDrawBuffer vertexBuffer;
        long pos;
        LongIterator longIterator;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (!this.forgetChunkSet.isEmpty()) {
            LongOpenHashSet removeBuilding = new LongOpenHashSet();
            longIterator = this.forgetChunkSet.longIterator();
            while (longIterator.hasNext()) {
                pos = longIterator.nextLong();
                vertexBuffer = (AxiomDrawBuffer)this.chunkDataMap.remove(pos);
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                if (!this.buildingChunkList.remove(pos)) continue;
                removeBuilding.add(pos);
            }
            this.forgetChunkSet.clear();
            this.buildTasks.removeIf(arg_0 -> CollisionMeshOverlayRenderer.lambda$uploadDirty$1((LongSet)removeBuilding, arg_0));
            this.buildResults.removeIf(arg_0 -> CollisionMeshOverlayRenderer.lambda$uploadDirty$2((LongSet)removeBuilding, arg_0));
            this.ignoreBuiltChunkSet.addAll((LongCollection)removeBuilding);
        }
        while ((buildResult = this.buildResults.poll()) != null) {
            long pos2 = class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ);
            if (!this.ignoreBuiltChunkSet.remove(pos2)) {
                class_9801 result = buildResult.bufferBuilder.build();
                if (result != null) {
                    vertexBuffer = (AxiomDrawBuffer)this.chunkDataMap.computeIfAbsent(pos2, k -> new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE));
                    vertexBuffer.upload(result);
                } else {
                    vertexBuffer = (AxiomDrawBuffer)this.chunkDataMap.remove(pos2);
                    if (vertexBuffer != null) {
                        vertexBuffer.close();
                    }
                }
            }
            this.buildingChunkList.remove(pos2);
            buildResult.bufferBuilder.close();
        }
        if (this.tickDirtyChunkSet.isEmpty()) {
            return;
        }
        this.startCollisionMesherIfNeeded();
        longIterator = this.tickDirtyChunkSet.longIterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            pos = longIterator.nextLong();
            if (this.buildTasks.size() == 16) break;
            if (this.buildingChunkList.contains(pos) || this.ignoreBuiltChunkSet.contains(pos)) continue;
            longIterator.remove();
            int chunkX = class_1923.method_8325((long)pos);
            class_2818 chunk = (class_2818)level.method_8402(chunkX, chunkZ = class_1923.method_8332((long)pos), class_2806.field_12803, false);
            if (chunk == null) continue;
            ArrayList<class_2841<class_2680>> sections = new ArrayList<class_2841<class_2680>>();
            int sectionsCount = chunk.method_32890();
            for (int y = 0; y < sectionsCount; ++y) {
                class_2826 section = chunk.method_38259(y);
                if (section.method_38292()) {
                    sections.add(null);
                    continue;
                }
                sections.add((class_2841<class_2680>)section.method_12265().method_39957());
            }
            this.buildTasks.add(new BuildTask(sections, chunkX, chunkZ, level.method_31607()));
        }
    }

    private static void buildBox(class_287 bufferBuilder, float x1, float y1, float z1, float x2, float y2, float z2) {
        float widthX = 1.0f / Math.abs(x2 - x1);
        float widthY = 1.0f / Math.abs(y2 - y1);
        float widthZ = 1.0f / Math.abs(z2 - z1);
        bufferBuilder.method_22912(x1, y1, z1).method_22913(-widthY, -widthZ);
        bufferBuilder.method_22912(x1, y1, z2).method_22913(-widthY, widthZ);
        bufferBuilder.method_22912(x1, y2, z2).method_22913(widthY, widthZ);
        bufferBuilder.method_22912(x1, y2, z1).method_22913(widthY, -widthZ);
        bufferBuilder.method_22912(x2, y2, z1).method_22913(widthY, -widthZ);
        bufferBuilder.method_22912(x2, y2, z2).method_22913(widthY, widthZ);
        bufferBuilder.method_22912(x2, y1, z2).method_22913(-widthY, widthZ);
        bufferBuilder.method_22912(x2, y1, z1).method_22913(-widthY, -widthZ);
        bufferBuilder.method_22912(x1, y2, z1).method_22913(-widthX, -widthZ);
        bufferBuilder.method_22912(x1, y2, z2).method_22913(-widthX, widthZ);
        bufferBuilder.method_22912(x2, y2, z2).method_22913(widthX, widthZ);
        bufferBuilder.method_22912(x2, y2, z1).method_22913(widthX, -widthZ);
        bufferBuilder.method_22912(x2, y1, z1).method_22913(widthX, -widthZ);
        bufferBuilder.method_22912(x2, y1, z2).method_22913(widthX, widthZ);
        bufferBuilder.method_22912(x1, y1, z2).method_22913(-widthX, widthZ);
        bufferBuilder.method_22912(x1, y1, z1).method_22913(-widthX, -widthZ);
        bufferBuilder.method_22912(x1, y1, z2).method_22913(-widthY, -widthX);
        bufferBuilder.method_22912(x2, y1, z2).method_22913(-widthY, widthX);
        bufferBuilder.method_22912(x2, y2, z2).method_22913(widthY, widthX);
        bufferBuilder.method_22912(x1, y2, z2).method_22913(widthY, -widthX);
        bufferBuilder.method_22912(x1, y2, z1).method_22913(widthY, -widthX);
        bufferBuilder.method_22912(x2, y2, z1).method_22913(widthY, widthX);
        bufferBuilder.method_22912(x2, y1, z1).method_22913(-widthY, widthX);
        bufferBuilder.method_22912(x1, y1, z1).method_22913(-widthY, -widthX);
    }

    private static void renderChunk(List<class_2841<class_2680>> sections, int chunkX, int chunkZ, int minY, VertexConsumerProvider provider) {
        BoxConsumer consumer = new BoxConsumer();
        consumer.bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, AxiomVertexFormats.COLLISION_MESH_VERTEX_FORMAT);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_776 renderManager = class_310.method_1551().method_1541();
        class_2350[] directions = class_2350.values();
        for (int x = 0; x < 16; ++x) {
            consumer.x = x;
            for (int z = 0; z < 16; ++z) {
                consumer.z = z;
                for (int sectionIndex = 0; sectionIndex < sections.size(); ++sectionIndex) {
                    class_2841<class_2680> container = sections.get(sectionIndex);
                    if (container == null) continue;
                    for (int y = 0; y < 16; ++y) {
                        boolean shouldRender;
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (blockState.method_26215() || !(shouldRender = SHOULD_RENDER_COLLISION_MESH.computeIfAbsent((Object)blockState, blockState1 -> {
                            class_265 collision = blockState.method_26220((class_1922)class_2682.field_12294, (class_2338)mutableBlockPos);
                            if (collision == class_259.method_1077() && blockState.method_26217() == class_2464.field_11458 && class_4696.method_23679((class_2680)blockState) == class_11515.field_60923) {
                                return false;
                            }
                            if (collision == class_259.method_1073() || collision.method_1110()) {
                                return false;
                            }
                            class_1087 bakedModel = renderManager.method_3349(blockState);
                            Vector3f minModel = new Vector3f(Float.POSITIVE_INFINITY);
                            Vector3f maxModel = new Vector3f(Float.NEGATIVE_INFINITY);
                            Consumer<Vector3fc> positionConsumer = vector3f -> {
                                minModel.min(vector3f);
                                maxModel.max(vector3f);
                            };
                            class_5819 rand = class_5819.method_43049((long)42L);
                            List parts = bakedModel.method_68512(rand);
                            for (class_10889 part : parts) {
                                for (class_2350 direction : directions) {
                                    for (class_777 quad : part.method_68509(direction)) {
                                        for (int i = 0; i < 4; ++i) {
                                            positionConsumer.accept(quad.method_76648(i));
                                        }
                                    }
                                }
                            }
                            class_238 bounds = collision.method_1107();
                            return !class_3532.method_20390((double)bounds.field_1323, (double)minModel.x) || !class_3532.method_20390((double)bounds.field_1322, (double)minModel.y) || !class_3532.method_20390((double)bounds.field_1321, (double)minModel.z) || !class_3532.method_20390((double)bounds.field_1320, (double)maxModel.x) || !class_3532.method_20390((double)bounds.field_1325, (double)maxModel.y) || !class_3532.method_20390((double)bounds.field_1324, (double)maxModel.z);
                        }))) continue;
                        mutableBlockPos.method_10103(chunkX * 16 + x, minY + sectionIndex * 16 + y, chunkZ * 16 + z);
                        class_265 collision = blockState.method_26220((class_1922)class_2682.field_12294, (class_2338)mutableBlockPos);
                        consumer.y = y + sectionIndex * 16;
                        collision.method_1089((class_259.class_260)consumer);
                    }
                }
            }
        }
    }

    public void clear() {
        this.tickDirtyChunkSet.clear();
        this.forgetChunkSet.clear();
        this.clearChunkData = true;
    }

    public void markDirty(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.tickDirtyChunkSet.add(pos);
    }

    public void forgetChunk(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.forgetChunkSet.add(pos);
        this.tickDirtyChunkSet.remove(pos);
    }

    public static void clearBlockStateShouldRenderCache() {
        SHOULD_RENDER_COLLISION_MESH.clear();
    }

    private static /* synthetic */ boolean lambda$uploadDirty$2(LongSet removeBuilding, BuildResult buildResult) {
        if (removeBuilding.remove(class_1923.method_8331((int)buildResult.chunkX, (int)buildResult.chunkZ))) {
            buildResult.bufferBuilder.close();
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$uploadDirty$1(LongSet removeBuilding, BuildTask buildTask) {
        return removeBuilding.remove(class_1923.method_8331((int)buildTask.chunkX, (int)buildTask.chunkZ));
    }

    static {
        SHOULD_RENDER_COLLISION_MESH = new Object2BooleanOpenHashMap();
    }

    private record BuildTask(List<class_2841<class_2680>> sections, int chunkX, int chunkZ, int minY) {
    }

    private record BuildResult(VertexConsumerProvider bufferBuilder, int chunkX, int chunkZ) {
    }

    private static class BoxConsumer
    implements class_259.class_260 {
        public class_287 bufferBuilder;
        public int x;
        public int y;
        public int z;

        private BoxConsumer() {
        }

        public void consume(double x1, double y1, double z1, double x2, double y2, double z2) {
            CollisionMeshOverlayRenderer.buildBox(this.bufferBuilder, (float)this.x + (float)x1, (float)this.y + (float)y1, (float)this.z + (float)z1, (float)this.x + (float)x2, (float)this.y + (float)y2, (float)this.z + (float)z2);
        }
    }
}

