/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.BiomeDataManager;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.tools.biome_painter.BiomePainterTool;
import com.moulberry.axiom.utils.ARGB32;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.FramebufferUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_276;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public enum BiomeOverlayRenderer {
    INSTANCE;

    private final Long2ObjectMap<ChunkData> chunkDataMap = new Long2ObjectOpenHashMap();
    private LongSet tickDirtyChunkSet = new LongOpenHashSet();
    private LongSet forgetChunkSet = new LongOpenHashSet();
    private boolean clearChunkData = false;
    private class_276 renderTarget;

    public void render(class_4587 poseStack, Matrix4f projection, class_4184 camera) {
        boolean setBiomeWindowIsActive;
        Tool tool;
        class_638 level;
        if (this.clearChunkData) {
            this.clearChunkData = false;
            this.chunkDataMap.values().forEach(ChunkData::close);
            this.chunkDataMap.clear();
        }
        if ((level = class_310.method_1551().field_1687) == null) {
            return;
        }
        boolean biomeToolActive = false;
        if (EditorUI.isActive() && ToolManager.isToolActive() && (tool = ToolManager.getCurrentTool()) instanceof BiomePainterTool) {
            BiomePainterTool biomePainterTool = (BiomePainterTool)tool;
            biomeToolActive = biomePainterTool.shouldRenderBiomeOverlay();
        }
        boolean bl = setBiomeWindowIsActive = EditorUI.isActive() && EditorWindowType.SET_BIOME.isOpenAndActive();
        if (!(Axiom.configuration.visuals.showBiomes || setBiomeWindowIsActive || biomeToolActive)) {
            return;
        }
        this.uploadDirty();
        float offsetY = level.method_31607();
        int mainWidth = class_310.method_1551().method_1522().field_1482;
        int mainHeight = class_310.method_1551().method_1522().field_1481;
        poseStack.method_22903();
        poseStack.method_22904(-camera.method_71156().field_1352, -camera.method_71156().field_1351, -camera.method_71156().field_1350);
        this.renderTarget = FramebufferUtils.resizeOrCreateFramebuffer(this.renderTarget, mainWidth, mainHeight);
        FramebufferUtils.clear(this.renderTarget, 0);
        FramebufferUtils.copyDepth(class_310.method_1551().method_1522(), this.renderTarget);
        ArrayList<AxiomDraw> axiomDraws = new ArrayList<AxiomDraw>();
        Matrix4f modelViewMatrix = poseStack.method_23760().method_23761();
        for (ChunkData chunkData : this.chunkDataMap.values()) {
            Matrix4f translated = new Matrix4f((Matrix4fc)modelViewMatrix);
            translated.translate((float)chunkData.offsetX, offsetY, (float)chunkData.offsetZ);
            axiomDraws.add(new AxiomDraw(chunkData.vertexBuffer, translated, null, null));
        }
        AxiomRenderer.renderPipeline(AxiomRenderPipelines.BIOME_OVERLAY_PIPELINE, this.renderTarget, axiomDraws);
        poseStack.method_22909();
        FramebufferUtils.blitToMainBlend(this.renderTarget, mainWidth, mainHeight);
    }

    public void uploadDirty() {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (!this.forgetChunkSet.isEmpty()) {
            LongSet forgetChunkSet = this.forgetChunkSet;
            LongIterator longIterator = forgetChunkSet.longIterator();
            while (longIterator.hasNext()) {
                long pos = longIterator.nextLong();
                ChunkData data = (ChunkData)this.chunkDataMap.remove(pos);
                if (data == null) continue;
                data.close();
            }
            this.forgetChunkSet = new LongOpenHashSet();
        }
        if (this.tickDirtyChunkSet.isEmpty()) {
            return;
        }
        LongSet dirtyChunkSet = this.tickDirtyChunkSet;
        this.tickDirtyChunkSet = new LongOpenHashSet();
        BiomeDataManager biomeDataManager = BiomeDataManager.get();
        LongIterator longIterator = dirtyChunkSet.longIterator();
        while (longIterator.hasNext()) {
            int chunkZ;
            long pos = longIterator.nextLong();
            int chunkX = class_1923.method_8325((long)pos);
            class_2818 chunk = (class_2818)level.method_8402(chunkX, chunkZ = class_1923.method_8332((long)pos), class_2806.field_12803, false);
            if (chunk == null) continue;
            ChunkData chunkData = (ChunkData)this.chunkDataMap.get(pos);
            if (chunkData == null) {
                chunkData = new ChunkData(chunkX * 16, chunkZ * 16);
                this.chunkDataMap.put(pos, (Object)chunkData);
            }
            if (chunkData.vertexBuffer == null) {
                chunkData.vertexBuffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
            }
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            BiomeOverlayRenderer.renderChunk(biomeDataManager, level, chunk, chunkX, chunkZ, provider);
            chunkData.vertexBuffer.upload(provider.build());
        }
    }

    private static void renderChunk(BiomeDataManager biomeDataManager, class_638 level, class_2818 chunk, int chunkX, int chunkZ, VertexConsumerProvider provider) {
        class_287 bufferBuilder = provider.begin(VertexFormat.class_5596.field_27382, AxiomVertexFormats.BORDER_VERTEX_FORMAT);
        int alpha = 160;
        int minSection = chunk.method_32891();
        int maxSection = chunk.method_31597();
        class_2818 northChunk = (class_2818)level.method_8402(chunkX, chunkZ - 1, class_2806.field_12803, false);
        class_2818 westChunk = (class_2818)level.method_8402(chunkX - 1, chunkZ, class_2806.field_12803, false);
        class_7522 aboveSection = chunk.method_38259(0).method_38294();
        for (int sectionY = minSection; sectionY <= maxSection; ++sectionY) {
            class_7522 section = aboveSection;
            aboveSection = sectionY == maxSection ? null : chunk.method_38259(sectionY - minSection + 1).method_38294();
            class_7522 northSection = northChunk == null ? null : northChunk.method_38259(sectionY - minSection).method_38294();
            class_7522 westSection = westChunk == null ? null : westChunk.method_38259(sectionY - minSection).method_38294();
            int offsetY = (sectionY - minSection) * 16;
            for (int x = 0; x < 16; x += 4) {
                for (int y = 0; y < 16; y += 4) {
                    for (int z = 0; z < 16; z += 4) {
                        class_6880.class_6883 westBiome;
                        class_6880.class_6883 northBiome;
                        int bx = x >> 2;
                        int by = y >> 2;
                        int bz = z >> 2;
                        class_6880.class_6883 biome = (class_6880.class_6883)section.method_12321(bx, by, bz);
                        int argb = biomeDataManager.getData((class_5321<class_1959>)biome.method_40237()).colour();
                        int red = ARGB32.red(argb);
                        int green = ARGB32.green(argb);
                        int blue = ARGB32.blue(argb);
                        class_6880.class_6883 aboveBiome = by == 3 ? (aboveSection == null ? null : (class_6880.class_6883)aboveSection.method_12321(bx, 0, bz)) : (class_6880.class_6883)section.method_12321(bx, by + 1, bz);
                        if (biome != aboveBiome) {
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            if (aboveBiome != null) {
                                int invArgb = biomeDataManager.getData((class_5321<class_1959>)aboveBiome.method_40237()).colour();
                                int invRed = ARGB32.red(invArgb);
                                int invGreen = ARGB32.green(invArgb);
                                int invBlue = ARGB32.blue(invArgb);
                                bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                                bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)(z + 4)).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                                bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)(z + 4)).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                                bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                            }
                        }
                        if ((northBiome = bz == 0 ? (northSection == null ? null : (class_6880.class_6883)northSection.method_12321(bx, by, 3)) : (class_6880.class_6883)section.method_12321(bx, by, bz - 1)) != null && biome != northBiome) {
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)z).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y), (float)z).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            int invArgb = biomeDataManager.getData((class_5321<class_1959>)northBiome.method_40237()).colour();
                            int invRed = ARGB32.red(invArgb);
                            int invGreen = ARGB32.green(invArgb);
                            int invBlue = ARGB32.blue(invArgb);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                            bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y + 4), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                        }
                        if ((westBiome = bx == 0 ? (westSection == null ? null : (class_6880.class_6883)westSection.method_12321(3, by, bz)) : (class_6880.class_6883)section.method_12321(bx - 1, by, bz)) != null && biome != westBiome) {
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(0, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(1, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                            int invArgb = biomeDataManager.getData((class_5321<class_1959>)westBiome.method_40237()).colour();
                            int invRed = ARGB32.red(invArgb);
                            int invGreen = ARGB32.green(invArgb);
                            int invBlue = ARGB32.blue(invArgb);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 0);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y + 4), (float)(z + 4)).method_1336(invRed, invGreen, invBlue, alpha).method_22921(1, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)(z + 4)).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 1);
                            bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)z).method_1336(invRed, invGreen, invBlue, alpha).method_22921(0, 0);
                        }
                        if (by != 0 || sectionY != minSection) continue;
                        bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y), (float)z).method_1336(red, green, blue, alpha).method_22921(1, 0);
                        bufferBuilder.method_22912((float)(x + 4), (float)(offsetY + y), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(1, 1);
                        bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)(z + 4)).method_1336(red, green, blue, alpha).method_22921(0, 1);
                        bufferBuilder.method_22912((float)x, (float)(offsetY + y), (float)z).method_1336(red, green, blue, alpha).method_22921(0, 0);
                    }
                }
            }
        }
    }

    public void clear() {
        this.tickDirtyChunkSet.clear();
        this.forgetChunkSet.clear();
        this.clearChunkData = true;
    }

    public void markDirty(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.tickDirtyChunkSet.add(pos);
    }

    public void forgetChunk(int chunkX, int chunkZ) {
        long pos = class_1923.method_8331((int)chunkX, (int)chunkZ);
        this.forgetChunkSet.add(pos);
        this.tickDirtyChunkSet.remove(pos);
    }

    private static class ChunkData {
        private AxiomDrawBuffer vertexBuffer = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
        private final int offsetX;
        private final int offsetZ;

        public ChunkData(int offsetX, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetZ = offsetZ;
        }

        public void close() {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
    }
}

