/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.google.common.math.DoubleMath;
import com.moulberry.axiom.BuildConfig;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.funcinterfaces.IntIntIntFloatConsumer;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import java.math.RoundingMode;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class Rasterization3D {
    public static void triangle(class_2338 one, class_2338 two, class_2338 three, TriIntConsumer consumer) {
        one = one.method_10062();
        two = two.method_10062();
        three = three.method_10062();
        if (one.equals((Object)two)) {
            if (two.equals((Object)three)) {
                consumer.accept(one.method_10263(), one.method_10264(), one.method_10260());
                return;
            }
            Rasterization3D.bresenham((class_2382)one, (class_2382)three, consumer);
            return;
        }
        if (one.equals((Object)three)) {
            Rasterization3D.bresenham((class_2382)one, (class_2382)two, consumer);
            return;
        }
        if (two.equals((Object)three)) {
            Rasterization3D.bresenham((class_2382)one, (class_2382)three, consumer);
            return;
        }
        class_243 normal = class_243.method_24953((class_2382)one).method_1020(class_243.method_24953((class_2382)two)).method_1036(class_243.method_24953((class_2382)one).method_1020(class_243.method_24953((class_2382)three)));
        double normalLength = Math.sqrt(normal.method_1027());
        if (normalLength < 1.0E-5) {
            Rasterization3D.bresenham((class_2382)one, (class_2382)two, consumer);
            Rasterization3D.bresenham((class_2382)two, (class_2382)three, consumer);
            Rasterization3D.bresenham((class_2382)three, (class_2382)one, consumer);
            return;
        }
        double normalX = Math.abs(normal.method_10216());
        double normalY = Math.abs(normal.method_10214());
        double normalZ = Math.abs(normal.method_10215());
        double planarK = -((double)one.method_10263() * normal.field_1352 + (double)one.method_10264() * normal.field_1351 + (double)one.method_10260() * normal.field_1350);
        if (BuildConfig.DEBUG) {
            double planarKTwo = -((double)two.method_10263() * normal.field_1352 + (double)two.method_10264() * normal.field_1351 + (double)two.method_10260() * normal.field_1350);
            if (Math.abs(planarK - planarKTwo) > 1.0E-5) {
                throw new FaultyImplementationError();
            }
            double planarKThree = -((double)three.method_10263() * normal.field_1352 + (double)three.method_10264() * normal.field_1351 + (double)three.method_10260() * normal.field_1350);
            if (Math.abs(planarK - planarKThree) > 1.0E-5) {
                throw new FaultyImplementationError();
            }
        }
        if (normalX > normalY && normalX > normalZ) {
            if (BuildConfig.DEBUG && normal.field_1352 == 0.0) {
                throw new FaultyImplementationError();
            }
            Rasterization2D.triangle(one.method_10264(), one.method_10260(), two.method_10264(), two.method_10260(), three.method_10264(), three.method_10260(), (y, z) -> {
                int x = DoubleMath.roundToInt((double)(-((double)y * normal.field_1351 + (double)z * normal.field_1350 + planarK) / normal.field_1352), (RoundingMode)RoundingMode.HALF_DOWN);
                consumer.accept(x, y, z);
            });
        } else if (normalY > normalZ) {
            if (BuildConfig.DEBUG && normal.field_1351 == 0.0) {
                throw new FaultyImplementationError();
            }
            Rasterization2D.triangle(one.method_10263(), one.method_10260(), two.method_10263(), two.method_10260(), three.method_10263(), three.method_10260(), (x, z) -> {
                int y = DoubleMath.roundToInt((double)(-((double)x * normal.field_1352 + (double)z * normal.field_1350 + planarK) / normal.field_1351), (RoundingMode)RoundingMode.HALF_DOWN);
                consumer.accept(x, y, z);
            });
        } else {
            if (BuildConfig.DEBUG && normal.field_1350 == 0.0) {
                throw new FaultyImplementationError();
            }
            Rasterization2D.triangle(one.method_10263(), one.method_10264(), two.method_10263(), two.method_10264(), three.method_10263(), three.method_10264(), (x, y) -> {
                int z = DoubleMath.roundToInt((double)(-((double)x * normal.field_1352 + (double)y * normal.field_1351 + planarK) / normal.field_1350), (RoundingMode)RoundingMode.HALF_DOWN);
                consumer.accept(x, y, z);
            });
        }
    }

    public static void bresenham(class_2382 from, class_2382 to, TriIntConsumer consumer) {
        consumer.accept(from.method_10263(), from.method_10264(), from.method_10260());
        Rasterization3D.bresenhamSkipFrom(from, to, consumer);
    }

    public static void bresenhamSkipFrom(class_2382 from, class_2382 to, TriIntConsumer consumer) {
        int zs;
        if (to.equals((Object)from)) {
            return;
        }
        from = new class_2382(from.method_10263(), from.method_10264(), from.method_10260());
        to = new class_2382(to.method_10263(), to.method_10264(), to.method_10260());
        int x = from.method_10263();
        int y = from.method_10264();
        int z = from.method_10260();
        int dx = Math.abs(to.method_10263() - x);
        int dy = Math.abs(to.method_10264() - y);
        int dz = Math.abs(to.method_10260() - z);
        int xs = to.method_10263() > x ? 1 : -1;
        int ys = to.method_10264() > y ? 1 : -1;
        int n = zs = to.method_10260() > z ? 1 : -1;
        if (dx >= dy && dx >= dz) {
            int p1 = 2 * dy - dx;
            int p2 = 2 * dz - dx;
            while (x != to.method_10263()) {
                x += xs;
                if (p1 >= 0) {
                    y += ys;
                    p1 -= 2 * dx;
                }
                if (p2 >= 0) {
                    z += zs;
                    p2 -= 2 * dx;
                }
                p1 += 2 * dy;
                p2 += 2 * dz;
                consumer.accept(x, y, z);
            }
        } else if (dy >= dz) {
            int p1 = 2 * dx - dy;
            int p2 = 2 * dz - dy;
            while (y != to.method_10264()) {
                y += ys;
                if (p1 >= 0) {
                    x += xs;
                    p1 -= 2 * dy;
                }
                if (p2 >= 0) {
                    z += zs;
                    p2 -= 2 * dy;
                }
                p1 += 2 * dx;
                p2 += 2 * dz;
                consumer.accept(x, y, z);
            }
        } else {
            int p1 = 2 * dy - dz;
            int p2 = 2 * dx - dz;
            while (z != to.method_10260()) {
                z += zs;
                if (p1 >= 0) {
                    y += ys;
                    p1 -= 2 * dz;
                }
                if (p2 >= 0) {
                    x += xs;
                    p2 -= 2 * dz;
                }
                p1 += 2 * dy;
                p2 += 2 * dx;
                consumer.accept(x, y, z);
            }
        }
    }

    public static void dda(class_2338 from, class_2338 to, TriIntConsumer consumer) {
        consumer.accept(from.method_10263(), from.method_10264(), from.method_10260());
        Rasterization3D.ddaSkipFrom(from, to, consumer);
    }

    public static void ddaSkipFrom(class_2338 from, class_2338 to, TriIntConsumer consumer) {
        if (to.equals((Object)from)) {
            return;
        }
        from = from.method_10062();
        to = to.method_10062();
        class_243 ray = class_243.method_24954((class_2382)to.method_10059((class_2382)from)).method_1029();
        int mapX = from.method_10263();
        int mapY = from.method_10264();
        int mapZ = from.method_10260();
        double deltaDistX = Math.abs(1.0 / ray.method_10216());
        double deltaDistY = Math.abs(1.0 / ray.method_10214());
        double deltaDistZ = Math.abs(1.0 / ray.method_10215());
        int stepX = ray.method_10216() < 0.0 ? -1 : 1;
        int stepY = ray.method_10214() < 0.0 ? -1 : 1;
        int stepZ = ray.method_10215() < 0.0 ? -1 : 1;
        double sideDistX = 0.5 * deltaDistX;
        double sideDistY = 0.5 * deltaDistY;
        double sideDistZ = 0.5 * deltaDistZ;
        int limit = 0;
        do {
            if (BuildConfig.DEBUG && limit++ >= 100000) {
                System.err.println("From: " + String.valueOf(from));
                System.err.println("To: " + String.valueOf(to));
                throw new FaultyImplementationError("100,000 iterations. Infinite loop?");
            }
            if (sideDistZ < sideDistX && sideDistZ < sideDistY) {
                sideDistZ += deltaDistZ;
                mapZ += stepZ;
            } else if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            consumer.accept(mapX, mapY, mapZ);
        } while (mapX != to.method_10263() || mapY != to.method_10264() || mapZ != to.method_10260());
    }

    public static void dda(Vector3d from, Vector3d to, TriIntConsumer consumer) {
        Rasterization3D.dda(new class_243(from.x, from.y, from.z), new class_243(to.x, to.y, to.z), consumer);
    }

    public static void dda(class_243 from, class_243 to, TriIntConsumer consumer) {
        int fromMapX = (int)Math.floor(from.field_1352);
        int fromMapY = (int)Math.floor(from.field_1351);
        int fromMapZ = (int)Math.floor(from.field_1350);
        consumer.accept(fromMapX, fromMapY, fromMapZ);
        Rasterization3D.ddaSkipFrom(from, to, consumer);
    }

    public static void ddaSkipFrom(class_243 from, class_243 to, TriIntConsumer consumer) {
        int fromMapX = (int)Math.floor(from.field_1352);
        int fromMapY = (int)Math.floor(from.field_1351);
        int fromMapZ = (int)Math.floor(from.field_1350);
        int toMapX = (int)Math.floor(to.field_1352);
        int toMapY = (int)Math.floor(to.field_1351);
        int toMapZ = (int)Math.floor(to.field_1350);
        if (toMapX == fromMapX && toMapY == fromMapY && toMapZ == fromMapZ) {
            return;
        }
        class_243 ray = to.method_1020(from).method_1029();
        if (ray.equals((Object)class_243.field_1353)) {
            return;
        }
        int mapX = fromMapX;
        int mapY = fromMapY;
        int mapZ = fromMapZ;
        double deltaDistX = Math.abs(1.0 / ray.field_1352);
        double deltaDistY = Math.abs(1.0 / ray.field_1351);
        double deltaDistZ = Math.abs(1.0 / ray.field_1350);
        int stepX = ray.method_10216() < 0.0 ? -1 : 1;
        int stepY = ray.method_10214() < 0.0 ? -1 : 1;
        int stepZ = ray.method_10215() < 0.0 ? -1 : 1;
        double sideDistX = (ray.field_1352 > 0.0 ? 1.0 - from.field_1352 + (double)mapX : from.field_1352 - (double)mapX) * deltaDistX;
        double sideDistY = (ray.field_1351 > 0.0 ? 1.0 - from.field_1351 + (double)mapY : from.field_1351 - (double)mapY) * deltaDistY;
        double sideDistZ = (ray.field_1350 > 0.0 ? 1.0 - from.field_1350 + (double)mapZ : from.field_1350 - (double)mapZ) * deltaDistZ;
        if (Double.isNaN(sideDistX)) {
            sideDistX = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistY)) {
            sideDistY = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(sideDistZ)) {
            sideDistZ = Double.POSITIVE_INFINITY;
        }
        int limit = 0;
        while (true) {
            if (BuildConfig.DEBUG && limit++ >= 100000) {
                System.err.println("From: " + String.valueOf(from));
                System.err.println("To: " + String.valueOf(to));
                throw new FaultyImplementationError("100,000 iterations. Infinite loop?");
            }
            if (sideDistZ < sideDistX && sideDistZ < sideDistY) {
                sideDistZ += deltaDistZ;
                mapZ += stepZ;
            } else if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            if (mapX * stepX > toMapX * stepX || mapY * stepY > toMapY * stepY || mapZ * stepZ > toMapZ * stepZ) {
                return;
            }
            consumer.accept(mapX, mapY, mapZ);
        }
    }

    public static void ddaPartial(Vector3d from, Vector3d to, IntIntIntFloatConsumer consumer) {
        int fromMapX = (int)Math.floor(from.x);
        int fromMapY = (int)Math.floor(from.y);
        int fromMapZ = (int)Math.floor(from.z);
        int toMapX = (int)Math.floor(to.x);
        int toMapY = (int)Math.floor(to.y);
        int toMapZ = (int)Math.floor(to.z);
        if (to.equals((Object)from)) {
            consumer.accept(fromMapX, fromMapY, fromMapZ, 0.5f);
            return;
        }
        double invDistance = 1.0 / to.distance((Vector3dc)from);
        Vector3d ray = to.sub((Vector3dc)from, new Vector3d()).normalize();
        double delta = ((double)fromMapX + 0.5 - from.x) * ray.x + ((double)fromMapY + 0.5 - from.y) * ray.y + ((double)fromMapZ + 0.5 - from.z) * ray.z;
        if ((delta *= invDistance) < 0.0) {
            delta = 0.0;
        } else if (delta > 1.0) {
            delta = 1.0;
        }
        consumer.accept(fromMapX, fromMapY, fromMapZ, (float)delta);
        if (toMapX == fromMapX && toMapY == fromMapY && toMapZ == fromMapZ) {
            return;
        }
        int mapX = fromMapX;
        int mapY = fromMapY;
        int mapZ = fromMapZ;
        double deltaDistX = Math.abs(1.0 / ray.x);
        double deltaDistY = Math.abs(1.0 / ray.y);
        double deltaDistZ = Math.abs(1.0 / ray.z);
        int stepX = ray.x() < 0.0 ? -1 : 1;
        int stepY = ray.y() < 0.0 ? -1 : 1;
        int stepZ = ray.z() < 0.0 ? -1 : 1;
        double sideDistX = (ray.x > 0.0 ? 1.0 - from.x + (double)mapX : from.x - (double)mapX) * deltaDistX;
        double sideDistY = (ray.y > 0.0 ? 1.0 - from.y + (double)mapY : from.y - (double)mapY) * deltaDistY;
        double sideDistZ = (ray.z > 0.0 ? 1.0 - from.z + (double)mapZ : from.z - (double)mapZ) * deltaDistZ;
        int limit = 0;
        while (true) {
            if (BuildConfig.DEBUG && limit++ >= 100000) {
                System.err.println("From: " + String.valueOf(from));
                System.err.println("To: " + String.valueOf(to));
                throw new FaultyImplementationError("100,000 iterations. Infinite loop?");
            }
            if (sideDistZ < sideDistX && sideDistZ < sideDistY) {
                sideDistZ += deltaDistZ;
                mapZ += stepZ;
            } else if (sideDistX < sideDistY) {
                sideDistX += deltaDistX;
                mapX += stepX;
            } else {
                sideDistY += deltaDistY;
                mapY += stepY;
            }
            if (mapX * stepX > toMapX * stepX || mapY * stepY > toMapY * stepY || mapZ * stepZ > toMapZ * stepZ) {
                return;
            }
            delta = ((double)mapX + 0.5 - from.x) * ray.x + ((double)mapY + 0.5 - from.y) * ray.y + ((double)mapZ + 0.5 - from.z) * ray.z;
            if ((delta *= invDistance) < 0.0) {
                delta = 0.0;
            } else if (delta > 1.0) {
                delta = 1.0;
            }
            consumer.accept(mapX, mapY, mapZ, (float)delta);
        }
    }

    private static float fpart(float f) {
        return f - (float)Math.floor(f);
    }

    private static float rfpart(float f) {
        return 1.0f - Rasterization3D.fpart(f);
    }

    public static void xiaolinWu(Vector3f from, Vector3f to, IntIntIntFloatConsumer consumer) {
        float temp;
        boolean steepZ;
        float x0 = from.x - 0.5f;
        float y0 = from.y - 0.5f;
        float z0 = from.z - 0.5f;
        float x1 = to.x - 0.5f;
        float y1 = to.y - 0.5f;
        float z1 = to.z - 0.5f;
        int bx0 = Math.round(x0);
        int by0 = Math.round(y0);
        int bz0 = Math.round(z0);
        int bx1 = Math.round(x1);
        int by1 = Math.round(y1);
        int bz1 = Math.round(z1);
        if (bx0 == bx1 && by0 == by1 && bz0 == bz1) {
            consumer.accept(bx0, by0, bz0, Math.max(Math.abs(x0 - x1), Math.max(Math.abs(y0 - y1), Math.abs(z0 - z1))));
            return;
        }
        boolean steepY = Math.abs(y0 - y1) > Math.abs(x0 - x1) && Math.abs(y0 - y1) > Math.abs(z0 - z1);
        boolean bl = steepZ = !steepY && Math.abs(z0 - z1) > Math.abs(x0 - x1);
        if (steepY) {
            temp = x0;
            x0 = y0;
            y0 = temp;
            temp = x1;
            x1 = y1;
            y1 = temp;
        } else if (steepZ) {
            temp = x0;
            x0 = z0;
            z0 = temp;
            temp = x1;
            x1 = z1;
            z1 = temp;
        }
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
            temp = y0;
            y0 = y1;
            y1 = temp;
            temp = z0;
            z0 = z1;
            z1 = temp;
        }
        if ((bx0 = Math.round(x0)) == (bx1 = Math.round(x1))) {
            by0 = Math.round(y0);
            bz0 = Math.round(z0);
            if (steepY) {
                consumer.accept(by0, bx0, bz0, Math.abs(x0 - x1));
            } else if (steepZ) {
                consumer.accept(bz0, by0, bx0, Math.abs(x0 - x1));
            } else {
                consumer.accept(bx0, by0, bz0, Math.abs(x0 - x1));
            }
            return;
        }
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        float gradientY = 1.0f;
        float gradientZ = 1.0f;
        if ((double)dx != 0.0) {
            gradientY = dy / dx;
            gradientZ = dz / dx;
        }
        float xgap = Rasterization3D.rfpart(x0 + 0.5f);
        float yend = y0 + gradientY * ((float)bx0 - x0);
        float zend = z0 + gradientZ * ((float)bx0 - x0);
        int ypxl = (int)Math.floor(yend);
        int zpxl = (int)Math.floor(zend);
        float fy = Rasterization3D.fpart(yend);
        float rfy = 1.0f - fy;
        float fz = Rasterization3D.fpart(zend);
        float rfz = 1.0f - fz;
        if (steepY) {
            consumer.accept(ypxl, bx0, zpxl, rfy * rfz * xgap);
            consumer.accept(ypxl + 1, bx0, zpxl, fy * rfz * xgap);
            consumer.accept(ypxl, bx0, zpxl + 1, rfy * fz * xgap);
            consumer.accept(ypxl + 1, bx0, zpxl + 1, fy * fz * xgap);
        } else if (steepZ) {
            consumer.accept(zpxl, ypxl, bx0, rfy * rfz * xgap);
            consumer.accept(zpxl, ypxl + 1, bx0, fy * rfz * xgap);
            consumer.accept(zpxl + 1, ypxl, bx0, rfy * fz * xgap);
            consumer.accept(zpxl + 1, ypxl + 1, bx0, fy * fz * xgap);
        } else {
            consumer.accept(bx0, ypxl, zpxl, rfy * rfz * xgap);
            consumer.accept(bx0, ypxl + 1, zpxl, fy * rfz * xgap);
            consumer.accept(bx0, ypxl, zpxl + 1, rfy * fz * xgap);
            consumer.accept(bx0, ypxl + 1, zpxl + 1, fy * fz * xgap);
        }
        float intery = yend + gradientY;
        float interz = zend + gradientZ;
        xgap = Rasterization3D.fpart(x1 + 0.5f);
        yend = y1 + gradientY * ((float)bx1 - x1);
        zend = z1 + gradientZ * ((float)bx1 - x1);
        ypxl = (int)Math.floor(yend);
        zpxl = (int)Math.floor(zend);
        fy = Rasterization3D.fpart(yend);
        rfy = 1.0f - fy;
        fz = Rasterization3D.fpart(zend);
        rfz = 1.0f - fz;
        if (steepY) {
            consumer.accept(ypxl, bx1, zpxl, rfy * rfz * xgap);
            consumer.accept(ypxl + 1, bx1, zpxl, fy * rfz * xgap);
            consumer.accept(ypxl, bx1, zpxl + 1, rfy * fz * xgap);
            consumer.accept(ypxl + 1, bx1, zpxl + 1, fy * fz * xgap);
        } else if (steepZ) {
            consumer.accept(zpxl, ypxl, bx1, rfy * rfz * xgap);
            consumer.accept(zpxl, ypxl + 1, bx1, fy * rfz * xgap);
            consumer.accept(zpxl + 1, ypxl, bx1, rfy * fz * xgap);
            consumer.accept(zpxl + 1, ypxl + 1, bx1, fy * fz * xgap);
        } else {
            consumer.accept(bx1, ypxl, zpxl, rfy * rfz * xgap);
            consumer.accept(bx1, ypxl + 1, zpxl, fy * rfz * xgap);
            consumer.accept(bx1, ypxl, zpxl + 1, rfy * fz * xgap);
            consumer.accept(bx1, ypxl + 1, zpxl + 1, fy * fz * xgap);
        }
        if (steepY) {
            for (int x = bx0 + 1; x <= bx1 - 1; ++x) {
                fy = Rasterization3D.fpart(intery);
                rfy = 1.0f - fy;
                fz = Rasterization3D.fpart(interz);
                rfz = 1.0f - fz;
                int y = (int)Math.floor(intery);
                int z = (int)Math.floor(interz);
                consumer.accept(y, x, z, rfy * rfz);
                consumer.accept(y + 1, x, z, fy * rfz);
                consumer.accept(y, x, z + 1, rfy * fz);
                consumer.accept(y + 1, x, z + 1, fy * fz);
                intery += gradientY;
                interz += gradientZ;
            }
        } else if (steepZ) {
            for (int x = bx0 + 1; x <= bx1 - 1; ++x) {
                fy = Rasterization3D.fpart(intery);
                rfy = 1.0f - fy;
                fz = Rasterization3D.fpart(interz);
                rfz = 1.0f - fz;
                int y = (int)Math.floor(intery);
                int z = (int)Math.floor(interz);
                consumer.accept(z, y, x, rfy * rfz);
                consumer.accept(z, y + 1, x, fy * rfz);
                consumer.accept(z + 1, y, x, rfy * fz);
                consumer.accept(z + 1, y + 1, x, fy * fz);
                intery += gradientY;
                interz += gradientZ;
            }
        } else {
            for (int x = bx0 + 1; x <= bx1 - 1; ++x) {
                fy = Rasterization3D.fpart(intery);
                rfy = 1.0f - fy;
                fz = Rasterization3D.fpart(interz);
                rfz = 1.0f - fz;
                int y = (int)Math.floor(intery);
                int z = (int)Math.floor(interz);
                consumer.accept(x, y, z, rfy * rfz);
                consumer.accept(x, y + 1, z, fy * rfz);
                consumer.accept(x, y, z + 1, rfy * fz);
                consumer.accept(x, y + 1, z + 1, fy * fz);
                intery += gradientY;
                interz += gradientZ;
            }
        }
    }
}

